/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.LocalLitematicState;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;

public class FileStorage {
    private final HashMap<ServerPlacement, Long> buffer = new HashMap();

    public LocalLitematicState getLocalState(ServerPlacement placement) {
        File localFile = this.getSchematicPath(placement);
        if (localFile.isFile()) {
            if (this.isDownloading(placement)) {
                return LocalLitematicState.DOWNLOADING_LITEMATIC;
            }
            if (this.buffer.containsKey(placement) && this.buffer.get(placement).longValue() == localFile.lastModified() || this.hashCompare(localFile, placement)) {
                return LocalLitematicState.LOCAL_LITEMATIC_PRESENT;
            }
            return LocalLitematicState.LOCAL_LITEMATIC_DESYNC;
        }
        return LocalLitematicState.NO_LOCAL_LITEMATIC;
    }

    private boolean isDownloading(ServerPlacement placement) {
        return SyncmaticaProtocol.getCommunicationManager().getDownloadState(placement);
    }

    public File getLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            return this.getSchematicPath(placement);
        }
        return null;
    }

    public File createLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            throw new IllegalArgumentException("");
        }
        File file = this.getSchematicPath(placement);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return file;
    }

    private boolean hashCompare(File localFile, ServerPlacement placement) {
        UUID hash = null;
        try {
            hash = SyncmaticaProtocol.createChecksum(new FileInputStream(localFile));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (hash == null) {
            return false;
        }
        if (hash.equals(placement.getHash())) {
            this.buffer.put(placement, localFile.lastModified());
            return true;
        }
        return false;
    }

    @Contract(value="_ -> new")
    @NotNull
    private File getSchematicPath(@NotNull ServerPlacement placement) {
        return new File(SyncmaticaProtocol.getLitematicFolder(), placement.getHash().toString() + ".litematic");
    }
}

