/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import top.leavesmc.leaves.protocol.syncmatica.CommunicationManager;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.Exchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public abstract class AbstractExchange
implements Exchange {
    private boolean success = false;
    private boolean finished = false;
    private final ExchangeTarget partner;

    protected AbstractExchange(ExchangeTarget partner) {
        this.partner = partner;
    }

    @Override
    public ExchangeTarget getPartner() {
        return this.partner;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public void close(boolean notifyPartner) {
        this.finished = true;
        this.success = false;
        this.onClose();
        if (notifyPartner) {
            this.sendCancelPacket();
        }
    }

    public CommunicationManager getManager() {
        return SyncmaticaProtocol.getCommunicationManager();
    }

    protected void sendCancelPacket() {
    }

    protected void onClose() {
    }

    protected void succeed() {
        this.finished = true;
        this.success = true;
        this.onClose();
    }

    protected static boolean checkUUID(PacketDataSerializer sourceBuf, UUID targetId) {
        int r2 = sourceBuf.readerIndex();
        UUID sourceId = sourceBuf.o();
        sourceBuf.readerIndex(r2);
        return sourceId.equals(targetId);
    }
}

