/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import java.util.regex.Pattern;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class MathUtils {
    private static final Pattern numericPattern = Pattern.compile("^-?[1-9]\\d*$|^0$");

    public static void clean(Vector vector) {
        if (!NumberConversions.isFinite((double)vector.getX())) {
            vector.setX(0);
        }
        if (!NumberConversions.isFinite((double)vector.getY())) {
            vector.setY(0);
        }
        if (!NumberConversions.isFinite((double)vector.getZ())) {
            vector.setZ(0);
        }
    }

    public static boolean isNumeric(String str) {
        return numericPattern.matcher(str).matches();
    }

    public static float[] fetchYawPitch(Vector dir) {
        double x2 = dir.getX();
        double z2 = dir.getZ();
        float[] out = new float[2];
        if (x2 == 0.0 && z2 == 0.0) {
            out[1] = dir.getY() > 0.0 ? -90 : 90;
        } else {
            double theta = Math.atan2(-x2, z2);
            out[0] = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
            double x22 = NumberConversions.square((double)x2);
            double z22 = NumberConversions.square((double)z2);
            double xz = Math.sqrt(x22 + z22);
            out[1] = (float)Math.toDegrees(Math.atan(-dir.getY() / xz));
        }
        return out;
    }

    public static float fetchPitch(Vector dir) {
        float result;
        double x2 = dir.getX();
        double z2 = dir.getZ();
        if (x2 == 0.0 && z2 == 0.0) {
            result = dir.getY() > 0.0 ? -90 : 90;
        } else {
            double x22 = NumberConversions.square((double)x2);
            double z22 = NumberConversions.square((double)z2);
            double xz = Math.sqrt(x22 + z22);
            result = (float)Math.toDegrees(Math.atan(-dir.getY() / xz));
        }
        return result;
    }

    public static Vector getDirection(double rotX, double rotY) {
        Vector vector = new Vector();
        rotX = Math.toRadians(rotX);
        rotY = Math.toRadians(rotY);
        double xz = Math.abs(Math.cos(rotY));
        vector.setX(-Math.sin(rotX) * xz);
        vector.setZ(Math.cos(rotX) * xz);
        vector.setY(-Math.sin(rotY));
        return vector;
    }
}

