/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import org.bukkit.Material;
import org.bukkit.entity.Witch;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitchReadyPotionEvent
extends EntityEvent
implements Cancellable {
    private ItemStack potion;
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;

    public WitchReadyPotionEvent(@NotNull Witch witch, @Nullable ItemStack potion) {
        super(witch);
        this.potion = potion;
    }

    @Nullable
    public static ItemStack process(@NotNull Witch witch, @Nullable ItemStack potion) {
        WitchReadyPotionEvent event = new WitchReadyPotionEvent(witch, potion);
        if (!event.callEvent() || event.getPotion() == null) {
            return new ItemStack(Material.AIR);
        }
        return event.getPotion();
    }

    @Override
    @NotNull
    public Witch getEntity() {
        return (Witch)super.getEntity();
    }

    @Nullable
    public ItemStack getPotion() {
        return this.potion;
    }

    public void setPotion(@Nullable ItemStack potion) {
        this.potion = potion != null ? potion.clone() : null;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

