/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.advancements.ConverterAbstractAdvancementsRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class V2503 {
    protected static final int VERSION = 2503;
    private static final Set<String> WALL_BLOCKS = ImmutableSet.of((Object)"minecraft:andesite_wall", (Object)"minecraft:brick_wall", (Object)"minecraft:cobblestone_wall", (Object)"minecraft:diorite_wall", (Object)"minecraft:end_stone_brick_wall", (Object)"minecraft:granite_wall", (Object[])new String[]{"minecraft:mossy_cobblestone_wall", "minecraft:mossy_stone_brick_wall", "minecraft:nether_brick_wall", "minecraft:prismarine_wall", "minecraft:red_nether_brick_wall", "minecraft:red_sandstone_wall", "minecraft:sandstone_wall", "minecraft:stone_brick_wall"});

    private V2503() {
    }

    private static void changeWallProperty(MapType<String> properties, String path) {
        String property = properties.getString(path);
        if (property != null) {
            properties.setString(path, "true".equals(property) ? "low" : "none");
        }
    }

    public static void register() {
        MCTypeRegistry.BLOCK_STATE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2503){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                if (!WALL_BLOCKS.contains(data.getString("Name"))) {
                    return null;
                }
                MapType<String> properties = data.getMap("Properties");
                if (properties == null) {
                    return null;
                }
                V2503.changeWallProperty(properties, "east");
                V2503.changeWallProperty(properties, "west");
                V2503.changeWallProperty(properties, "north");
                V2503.changeWallProperty(properties, "south");
                return null;
            }
        });
        ConverterAbstractAdvancementsRename.register(2503, arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"minecraft:recipes/misc/composter", (Object)"minecraft:recipes/decorations/composter")).get(arg_0));
    }
}

