/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;

public final class V3439 {
    private static final int VERSION = 3439;

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> signTileUpdater = new DataConverter<MapType<String>, MapType<String>>(3439){
            private static final String BLANK_TEXT_LINE = IChatBaseComponent.ChatSerializer.a(CommonComponents.a);
            private static final String DEFAULT_COLOR = "black";

            private static ListType migrateToList(MapType<String> root, String prefix) {
                if (root == null) {
                    return null;
                }
                ListType ret = root.getTypeUtil().createEmptyList();
                ret.addString(root.getString(prefix.concat("1"), BLANK_TEXT_LINE));
                ret.addString(root.getString(prefix.concat("2"), BLANK_TEXT_LINE));
                ret.addString(root.getString(prefix.concat("3"), BLANK_TEXT_LINE));
                ret.addString(root.getString(prefix.concat("4"), BLANK_TEXT_LINE));
                return ret;
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType<String> frontText = data.getTypeUtil().createEmptyMap();
                data.setMap("front_text", frontText);
                frontText.setList("messages", 1.migrateToList(data, "Text"));
                frontText.setList("filtered_messages", 1.migrateToList(data, "FilteredText"));
                frontText.setString("color", data.getString("Color", DEFAULT_COLOR));
                frontText.setBoolean("has_glowing_text", data.getBoolean("GlowingText", false));
                MapType<String> backText = data.getTypeUtil().createEmptyMap();
                data.setMap("back_text", backText);
                ListType blankMessages = data.getTypeUtil().createEmptyList();
                for (int i2 = 0; i2 < 4; ++i2) {
                    blankMessages.addString(BLANK_TEXT_LINE);
                }
                backText.setList("messages", blankMessages);
                backText.setList("filtered_messages", blankMessages.copy());
                backText.setString("color", DEFAULT_COLOR);
                backText.setBoolean("has_glowing_text", false);
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", signTileUpdater);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:hanging_sign", signTileUpdater);
    }
}

