/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class NBTListType
implements ListType {
    private final NBTTagList list;

    public NBTListType() {
        this.list = new NBTTagList();
    }

    public NBTListType(NBTTagList tag) {
        this.list = tag;
    }

    @Override
    public TypeUtil getTypeUtil() {
        return Types.NBT;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NBTListType.class) {
            return false;
        }
        return this.list.equals(((NBTListType)obj).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return "NBTListType{list=" + this.list + "}";
    }

    public NBTTagList getTag() {
        return this.list;
    }

    @Override
    public ListType copy() {
        return new NBTListType(this.list.e());
    }

    protected static ObjectType getType(byte id) {
        switch (id) {
            case 0: {
                return ObjectType.NONE;
            }
            case 1: {
                return ObjectType.BYTE;
            }
            case 2: {
                return ObjectType.SHORT;
            }
            case 3: {
                return ObjectType.INT;
            }
            case 4: {
                return ObjectType.LONG;
            }
            case 5: {
                return ObjectType.FLOAT;
            }
            case 6: {
                return ObjectType.DOUBLE;
            }
            case 7: {
                return ObjectType.BYTE_ARRAY;
            }
            case 8: {
                return ObjectType.STRING;
            }
            case 9: {
                return ObjectType.LIST;
            }
            case 10: {
                return ObjectType.MAP;
            }
            case 11: {
                return ObjectType.INT_ARRAY;
            }
            case 12: {
                return ObjectType.LONG_ARRAY;
            }
        }
        throw new IllegalStateException("Unknown type: " + id);
    }

    @Override
    public ObjectType getType() {
        return NBTListType.getType(this.list.f());
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void remove(int index) {
        this.list.c(index);
    }

    @Override
    public Number getNumber(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).l();
    }

    @Override
    public byte getByte(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).i();
    }

    @Override
    public void setByte(int index, byte to) {
        this.list.d(index, NBTTagByte.a(to));
    }

    @Override
    public short getShort(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).h();
    }

    @Override
    public void setShort(int index, short to) {
        this.list.d(index, NBTTagShort.a(to));
    }

    @Override
    public int getInt(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).g();
    }

    @Override
    public void setInt(int index, int to) {
        this.list.d(index, NBTTagInt.a(to));
    }

    @Override
    public long getLong(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).f();
    }

    @Override
    public void setLong(int index, long to) {
        this.list.d(index, NBTTagLong.a(to));
    }

    @Override
    public float getFloat(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).k();
    }

    @Override
    public void setFloat(int index, float to) {
        this.list.d(index, NBTTagFloat.a(to));
    }

    @Override
    public double getDouble(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTNumber)) {
            throw new IllegalStateException();
        }
        return ((NBTNumber)tag).j();
    }

    @Override
    public void setDouble(int index, double to) {
        this.list.d(index, NBTTagDouble.a(to));
    }

    @Override
    public byte[] getBytes(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagByteArray)) {
            throw new IllegalStateException();
        }
        return ((NBTTagByteArray)tag).e();
    }

    @Override
    public void setBytes(int index, byte[] to) {
        this.list.d(index, new NBTTagByteArray(to));
    }

    @Override
    public short[] getShorts(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShorts(int index, short[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagIntArray)) {
            throw new IllegalStateException();
        }
        return ((NBTTagIntArray)tag).g();
    }

    @Override
    public void setInts(int index, int[] to) {
        this.list.d(index, new NBTTagIntArray(to));
    }

    @Override
    public long[] getLongs(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagLongArray)) {
            throw new IllegalStateException();
        }
        return ((NBTTagLongArray)tag).g();
    }

    @Override
    public void setLongs(int index, long[] to) {
        this.list.d(index, new NBTTagLongArray(to));
    }

    @Override
    public ListType getList(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagList)) {
            throw new IllegalStateException();
        }
        return new NBTListType((NBTTagList)tag);
    }

    @Override
    public void setList(int index, ListType list) {
        this.list.d(index, ((NBTListType)list).getTag());
    }

    public MapType<String> getMap(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagCompound)) {
            throw new IllegalStateException();
        }
        return new NBTMapType((NBTTagCompound)tag);
    }

    @Override
    public void setMap(int index, MapType<?> to) {
        this.list.d(index, ((NBTMapType)to).getTag());
    }

    @Override
    public String getString(int index) {
        NBTBase tag = this.list.k(index);
        if (!(tag instanceof NBTTagString)) {
            throw new IllegalStateException();
        }
        return ((NBTTagString)tag).m_();
    }

    @Override
    public void setString(int index, String to) {
        this.list.d(index, NBTTagString.a(to));
    }

    @Override
    public void addByte(byte b2) {
        this.list.add(NBTTagByte.a(b2));
    }

    @Override
    public void addByte(int index, byte b2) {
        this.list.c(index, NBTTagByte.a(b2));
    }

    @Override
    public void addShort(short s2) {
        this.list.add(NBTTagShort.a(s2));
    }

    @Override
    public void addShort(int index, short s2) {
        this.list.c(index, NBTTagShort.a(s2));
    }

    @Override
    public void addInt(int i2) {
        this.list.add(NBTTagInt.a(i2));
    }

    @Override
    public void addInt(int index, int i2) {
        this.list.c(index, NBTTagInt.a(i2));
    }

    @Override
    public void addLong(long l2) {
        this.list.add(NBTTagLong.a(l2));
    }

    @Override
    public void addLong(int index, long l2) {
        this.list.c(index, NBTTagLong.a(l2));
    }

    @Override
    public void addFloat(float f2) {
        this.list.add(NBTTagFloat.a(f2));
    }

    @Override
    public void addFloat(int index, float f2) {
        this.list.c(index, NBTTagFloat.a(f2));
    }

    @Override
    public void addDouble(double d2) {
        this.list.add(NBTTagDouble.a(d2));
    }

    @Override
    public void addDouble(int index, double d2) {
        this.list.c(index, NBTTagDouble.a(d2));
    }

    @Override
    public void addByteArray(byte[] arr) {
        this.list.add(new NBTTagByteArray(arr));
    }

    @Override
    public void addByteArray(int index, byte[] arr) {
        this.list.c(index, new NBTTagByteArray(arr));
    }

    @Override
    public void addShortArray(short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addShortArray(int index, short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIntArray(int[] arr) {
        this.list.add(new NBTTagIntArray(arr));
    }

    @Override
    public void addIntArray(int index, int[] arr) {
        this.list.c(index, new NBTTagIntArray(arr));
    }

    @Override
    public void addLongArray(long[] arr) {
        this.list.add(new NBTTagLongArray(arr));
    }

    @Override
    public void addLongArray(int index, long[] arr) {
        this.list.c(index, new NBTTagLongArray(arr));
    }

    @Override
    public void addList(ListType list) {
        this.list.add(((NBTListType)list).getTag());
    }

    @Override
    public void addList(int index, ListType list) {
        this.list.c(index, ((NBTListType)list).getTag());
    }

    @Override
    public void addMap(MapType<?> map) {
        this.list.add(((NBTMapType)map).getTag());
    }

    @Override
    public void addMap(int index, MapType<?> map) {
        this.list.c(index, ((NBTMapType)map).getTag());
    }

    @Override
    public void addString(String string) {
        this.list.add(NBTTagString.a(string));
    }

    @Override
    public void addString(int index, String string) {
        this.list.c(index, NBTTagString.a(string));
    }
}

