/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.IntegerUtil;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class StarLightEngine {
    protected static final IBlockData AIR_BLOCK_STATE = Blocks.a.n();
    protected static final AxisDirection[] DIRECTIONS = AxisDirection.values();
    protected static final AxisDirection[] AXIS_DIRECTIONS = DIRECTIONS;
    protected static final AxisDirection[] ONLY_HORIZONTAL_DIRECTIONS = new AxisDirection[]{AxisDirection.POSITIVE_X, AxisDirection.NEGATIVE_X, AxisDirection.POSITIVE_Z, AxisDirection.NEGATIVE_Z};
    protected final ChunkSection[] sectionCache;
    protected final SWMRNibbleArray[] nibbleCache;
    protected final boolean[] notifyUpdateCache;
    protected final IChunkAccess[] chunkCache = new IChunkAccess[25];
    protected final boolean[][] emptinessMapCache = new boolean[25][];
    protected final BlockPosition.MutableBlockPosition mutablePos1 = new BlockPosition.MutableBlockPosition();
    protected final BlockPosition.MutableBlockPosition mutablePos2 = new BlockPosition.MutableBlockPosition();
    protected final BlockPosition.MutableBlockPosition mutablePos3 = new BlockPosition.MutableBlockPosition();
    protected int encodeOffsetX;
    protected int encodeOffsetY;
    protected int encodeOffsetZ;
    protected int coordinateOffset;
    protected int chunkOffsetX;
    protected int chunkOffsetY;
    protected int chunkOffsetZ;
    protected int chunkIndexOffset;
    protected int chunkSectionIndexOffset;
    protected final boolean skylightPropagator;
    protected final int emittedLightMask;
    protected final boolean isClientSide;
    protected final World world;
    protected final int minLightSection;
    protected final int maxLightSection;
    protected final int minSection;
    protected final int maxSection;
    protected final int[] chunkCheckDelayedUpdatesCenter = new int[256];
    protected final int[] chunkCheckDelayedUpdatesNeighbour = new int[256];
    protected static final long FLAG_WRITE_LEVEL = 0x2000000000000000L;
    protected static final long FLAG_RECHECK_LEVEL = 0x4000000000000000L;
    protected static final long FLAG_HAS_SIDED_TRANSPARENT_BLOCKS = Long.MIN_VALUE;
    protected long[] increaseQueue = new long[4096];
    protected int increaseQueueInitialLength;
    protected long[] decreaseQueue = new long[4096];
    protected int decreaseQueueInitialLength;
    protected static final AxisDirection[][] OLD_CHECK_DIRECTIONS = new AxisDirection[64][];
    protected static final int ALL_DIRECTIONS_BITSET = 63;

    protected StarLightEngine(boolean skylightPropagator, World world) {
        this.skylightPropagator = skylightPropagator;
        this.emittedLightMask = skylightPropagator ? 0 : 15;
        this.isClientSide = world.B;
        this.world = world;
        this.minLightSection = WorldUtil.getMinLightSection(world);
        this.maxLightSection = WorldUtil.getMaxLightSection(world);
        this.minSection = WorldUtil.getMinSection(world);
        this.maxSection = WorldUtil.getMaxSection(world);
        this.sectionCache = new ChunkSection[25 * (this.maxLightSection - this.minLightSection + 1 + 2)];
        this.nibbleCache = new SWMRNibbleArray[25 * (this.maxLightSection - this.minLightSection + 1 + 2)];
        this.notifyUpdateCache = new boolean[25 * (this.maxLightSection - this.minLightSection + 1 + 2)];
    }

    protected final void setupEncodeOffset(int centerX, int centerY, int centerZ) {
        this.encodeOffsetX = 31 - centerX;
        this.encodeOffsetY = -(this.minLightSection - 1) << 4;
        this.encodeOffsetZ = 31 - centerZ;
        this.coordinateOffset = this.encodeOffsetX + (this.encodeOffsetZ << 6) + (this.encodeOffsetY << 12);
        this.chunkOffsetX = 2 - (centerX >> 4);
        this.chunkOffsetY = -(this.minLightSection - 1);
        this.chunkOffsetZ = 2 - (centerZ >> 4);
        this.chunkIndexOffset = this.chunkOffsetX + 5 * this.chunkOffsetZ;
        this.chunkSectionIndexOffset = this.chunkIndexOffset + 25 * this.chunkOffsetY;
    }

    protected final void setupCaches(ILightAccess chunkProvider, int centerX, int centerY, int centerZ, boolean relaxed, boolean tryToLoadChunksFor2Radius) {
        int centerChunkX = centerX >> 4;
        int centerChunkY = centerY >> 4;
        int centerChunkZ = centerZ >> 4;
        this.setupEncodeOffset(centerChunkX * 16 + 7, centerChunkY * 16 + 7, centerChunkZ * 16 + 7);
        int radius = tryToLoadChunksFor2Radius ? 2 : 1;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                int cx = centerChunkX + dx;
                int cz = centerChunkZ + dz;
                boolean isTwoRadius = Math.max(IntegerUtil.branchlessAbs(dx), IntegerUtil.branchlessAbs(dz)) == 2;
                IChunkAccess chunk = (IChunkAccess)chunkProvider.c(cx, cz);
                if (chunk == null) {
                    if (relaxed | isTwoRadius) continue;
                    throw new IllegalArgumentException("Trying to propagate light update before 1 radius neighbours ready");
                }
                if (!this.canUseChunk(chunk)) continue;
                this.setChunkInCache(cx, cz, chunk);
                this.setEmptinessMapCache(cx, cz, this.getEmptinessMap(chunk));
                if (isTwoRadius) continue;
                this.setBlocksForChunkInCache(cx, cz, chunk.d());
                this.setNibblesForChunkInCache(cx, cz, this.getNibblesOnChunk(chunk));
            }
        }
    }

    protected final IChunkAccess getChunkInCache(int chunkX, int chunkZ) {
        return this.chunkCache[chunkX + 5 * chunkZ + this.chunkIndexOffset];
    }

    protected final void setChunkInCache(int chunkX, int chunkZ, IChunkAccess chunk) {
        this.chunkCache[chunkX + 5 * chunkZ + this.chunkIndexOffset] = chunk;
    }

    protected final ChunkSection getChunkSection(int chunkX, int chunkY, int chunkZ) {
        return this.sectionCache[chunkX + 5 * chunkZ + 25 * chunkY + this.chunkSectionIndexOffset];
    }

    protected final void setChunkSectionInCache(int chunkX, int chunkY, int chunkZ, ChunkSection section) {
        this.sectionCache[chunkX + 5 * chunkZ + 25 * chunkY + this.chunkSectionIndexOffset] = section;
    }

    protected final void setBlocksForChunkInCache(int chunkX, int chunkZ, ChunkSection[] sections) {
        for (int cy = this.minLightSection; cy <= this.maxLightSection; ++cy) {
            this.setChunkSectionInCache(chunkX, cy, chunkZ, sections == null ? null : (cy >= this.minSection && cy <= this.maxSection ? sections[cy - this.minSection] : null));
        }
    }

    protected final SWMRNibbleArray getNibbleFromCache(int chunkX, int chunkY, int chunkZ) {
        return this.nibbleCache[chunkX + 5 * chunkZ + 25 * chunkY + this.chunkSectionIndexOffset];
    }

    protected final SWMRNibbleArray[] getNibblesForChunkFromCache(int chunkX, int chunkZ) {
        SWMRNibbleArray[] ret = new SWMRNibbleArray[this.maxLightSection - this.minLightSection + 1];
        for (int cy = this.minLightSection; cy <= this.maxLightSection; ++cy) {
            ret[cy - this.minLightSection] = this.nibbleCache[chunkX + 5 * chunkZ + cy * 25 + this.chunkSectionIndexOffset];
        }
        return ret;
    }

    protected final void setNibbleInCache(int chunkX, int chunkY, int chunkZ, SWMRNibbleArray nibble) {
        this.nibbleCache[chunkX + 5 * chunkZ + 25 * chunkY + this.chunkSectionIndexOffset] = nibble;
    }

    protected final void setNibblesForChunkInCache(int chunkX, int chunkZ, SWMRNibbleArray[] nibbles) {
        for (int cy = this.minLightSection; cy <= this.maxLightSection; ++cy) {
            this.setNibbleInCache(chunkX, cy, chunkZ, nibbles == null ? null : nibbles[cy - this.minLightSection]);
        }
    }

    protected final void updateVisible(ILightAccess lightAccess) {
        int max = this.nibbleCache.length;
        for (int index = 0; index < max; ++index) {
            SWMRNibbleArray nibble = this.nibbleCache[index];
            if (!this.notifyUpdateCache[index] && (nibble == null || !nibble.isDirty())) continue;
            int chunkX = index % 5 - this.chunkOffsetX;
            int chunkZ = index / 5 % 5 - this.chunkOffsetZ;
            int ySections = this.maxSection - this.minSection + 1;
            int chunkY = index / 25 % (ySections + 2 + 2) - this.chunkOffsetY;
            if ((nibble == null || !nibble.updateVisible()) && !this.notifyUpdateCache[index]) continue;
            lightAccess.a(this.skylightPropagator ? EnumSkyBlock.a : EnumSkyBlock.b, SectionPosition.a(chunkX, chunkY, chunkZ));
        }
    }

    protected final void destroyCaches() {
        Arrays.fill(this.sectionCache, null);
        Arrays.fill(this.nibbleCache, null);
        Arrays.fill(this.chunkCache, null);
        Arrays.fill((Object[])this.emptinessMapCache, null);
        if (this.isClientSide) {
            Arrays.fill(this.notifyUpdateCache, false);
        }
    }

    protected final IBlockData getBlockState(int worldX, int worldY, int worldZ) {
        ChunkSection section = this.sectionCache[(worldX >> 4) + 5 * (worldZ >> 4) + 25 * (worldY >> 4) + this.chunkSectionIndexOffset];
        if (section != null) {
            return section.c() ? AIR_BLOCK_STATE : section.a(worldX & 0xF, worldY & 0xF, worldZ & 0xF);
        }
        return AIR_BLOCK_STATE;
    }

    protected final IBlockData getBlockState(int sectionIndex, int localIndex) {
        ChunkSection section = this.sectionCache[sectionIndex];
        if (section != null) {
            return section.c() ? AIR_BLOCK_STATE : section.h.a(localIndex);
        }
        return AIR_BLOCK_STATE;
    }

    protected final int getLightLevel(int worldX, int worldY, int worldZ) {
        SWMRNibbleArray nibble = this.nibbleCache[(worldX >> 4) + 5 * (worldZ >> 4) + 25 * (worldY >> 4) + this.chunkSectionIndexOffset];
        return nibble == null ? 0 : nibble.getUpdating(worldX & 0xF | (worldZ & 0xF) << 4 | (worldY & 0xF) << 8);
    }

    protected final int getLightLevel(int sectionIndex, int localIndex) {
        SWMRNibbleArray nibble = this.nibbleCache[sectionIndex];
        return nibble == null ? 0 : nibble.getUpdating(localIndex);
    }

    protected final void setLightLevel(int worldX, int worldY, int worldZ, int level) {
        int sectionIndex = (worldX >> 4) + 5 * (worldZ >> 4) + 25 * (worldY >> 4) + this.chunkSectionIndexOffset;
        SWMRNibbleArray nibble = this.nibbleCache[sectionIndex];
        if (nibble != null) {
            nibble.set(worldX & 0xF | (worldZ & 0xF) << 4 | (worldY & 0xF) << 8, level);
            if (this.isClientSide) {
                int cx1 = worldX - 1 >> 4;
                int cx2 = worldX + 1 >> 4;
                int cy1 = worldY - 1 >> 4;
                int cy2 = worldY + 1 >> 4;
                int cz1 = worldZ - 1 >> 4;
                int cz2 = worldZ + 1 >> 4;
                for (int x2 = cx1; x2 <= cx2; ++x2) {
                    for (int y2 = cy1; y2 <= cy2; ++y2) {
                        for (int z2 = cz1; z2 <= cz2; ++z2) {
                            this.notifyUpdateCache[x2 + 5 * z2 + 25 * y2 + this.chunkSectionIndexOffset] = true;
                        }
                    }
                }
            }
        }
    }

    protected final void postLightUpdate(int worldX, int worldY, int worldZ) {
        if (this.isClientSide) {
            int cx1 = worldX - 1 >> 4;
            int cx2 = worldX + 1 >> 4;
            int cy1 = worldY - 1 >> 4;
            int cy2 = worldY + 1 >> 4;
            int cz1 = worldZ - 1 >> 4;
            int cz2 = worldZ + 1 >> 4;
            for (int x2 = cx1; x2 <= cx2; ++x2) {
                for (int y2 = cy1; y2 <= cy2; ++y2) {
                    for (int z2 = cz1; z2 <= cz2; ++z2) {
                        this.notifyUpdateCache[x2 + 5 * z2 + 25 * y2 + this.chunkSectionIndexOffset] = true;
                    }
                }
            }
        }
    }

    protected final void setLightLevel(int sectionIndex, int localIndex, int worldX, int worldY, int worldZ, int level) {
        SWMRNibbleArray nibble = this.nibbleCache[sectionIndex];
        if (nibble != null) {
            nibble.set(localIndex, level);
            if (this.isClientSide) {
                int cx1 = worldX - 1 >> 4;
                int cx2 = worldX + 1 >> 4;
                int cy1 = worldY - 1 >> 4;
                int cy2 = worldY + 1 >> 4;
                int cz1 = worldZ - 1 >> 4;
                int cz2 = worldZ + 1 >> 4;
                for (int x2 = cx1; x2 <= cx2; ++x2) {
                    for (int y2 = cy1; y2 <= cy2; ++y2) {
                        for (int z2 = cz1; z2 <= cz2; ++z2) {
                            this.notifyUpdateCache[x2 + 5 * z2 + 25 * y2 + this.chunkSectionIndexOffset] = true;
                        }
                    }
                }
            }
        }
    }

    protected final boolean[] getEmptinessMap(int chunkX, int chunkZ) {
        return this.emptinessMapCache[chunkX + 5 * chunkZ + this.chunkIndexOffset];
    }

    protected final void setEmptinessMapCache(int chunkX, int chunkZ, boolean[] emptinessMap) {
        this.emptinessMapCache[chunkX + 5 * chunkZ + this.chunkIndexOffset] = emptinessMap;
    }

    public static SWMRNibbleArray[] getFilledEmptyLight(LevelHeightAccessor world) {
        return StarLightEngine.getFilledEmptyLight(WorldUtil.getTotalLightSections(world));
    }

    private static SWMRNibbleArray[] getFilledEmptyLight(int totalLightSections) {
        SWMRNibbleArray[] ret = new SWMRNibbleArray[totalLightSections];
        int len = ret.length;
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = new SWMRNibbleArray(null, true);
        }
        return ret;
    }

    protected abstract boolean[] getEmptinessMap(IChunkAccess var1);

    protected abstract void setEmptinessMap(IChunkAccess var1, boolean[] var2);

    protected abstract SWMRNibbleArray[] getNibblesOnChunk(IChunkAccess var1);

    protected abstract void setNibbles(IChunkAccess var1, SWMRNibbleArray[] var2);

    protected abstract boolean canUseChunk(IChunkAccess var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void blocksChangedInChunk(ILightAccess lightAccess, int chunkX, int chunkZ, Set<BlockPosition> positions, Boolean[] changedSections) {
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, true);
        try {
            boolean[] ret;
            IChunkAccess chunk = this.getChunkInCache(chunkX, chunkZ);
            if (chunk == null) {
                return;
            }
            if (changedSections != null && (ret = this.handleEmptySectionChanges(lightAccess, chunk, changedSections, false)) != null) {
                this.setEmptinessMap(chunk, ret);
            }
            if (!positions.isEmpty()) {
                this.propagateBlockChanges(lightAccess, chunk, positions);
            }
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    protected abstract void propagateBlockChanges(ILightAccess var1, IChunkAccess var2, Set<BlockPosition> var3);

    protected abstract void checkBlock(ILightAccess var1, int var2, int var3, int var4);

    protected abstract int calculateLightValue(ILightAccess var1, int var2, int var3, int var4, int var5);

    protected void checkChunkEdge(ILightAccess lightAccess, IChunkAccess chunk, int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray currNibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (currNibble == null) {
            return;
        }
        for (AxisDirection direction : ONLY_HORIZONTAL_DIRECTIONS) {
            int currY;
            int startZ;
            int startX;
            int incZ;
            int incX;
            int neighbourOffX = direction.x;
            int neighbourOffZ = direction.z;
            SWMRNibbleArray neighbourNibble = this.getNibbleFromCache(chunkX + neighbourOffX, chunkY, chunkZ + neighbourOffZ);
            if (neighbourNibble == null || !currNibble.isInitialisedUpdating() && !neighbourNibble.isInitialisedUpdating()) continue;
            if (neighbourOffX != 0) {
                incX = 0;
                incZ = 1;
                startX = direction.x < 0 ? chunkX << 4 : chunkX << 4 | 0xF;
                startZ = chunkZ << 4;
            } else {
                incX = 1;
                incZ = 0;
                startZ = neighbourOffZ < 0 ? chunkZ << 4 : chunkZ << 4 | 0xF;
                startX = chunkX << 4;
            }
            int centerDelayedChecks = 0;
            int neighbourDelayedChecks = 0;
            int maxY = currY | 0xF;
            for (currY = chunkY << 4; currY <= maxY; ++currY) {
                int i2 = 0;
                int currX = startX;
                int currZ = startZ;
                while (i2 < 16) {
                    int neighbourX = currX + neighbourOffX;
                    int neighbourZ = currZ + neighbourOffZ;
                    int currentIndex = currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8;
                    int currentLevel = currNibble.getUpdating(currentIndex);
                    int neighbourIndex = neighbourX & 0xF | (neighbourZ & 0xF) << 4 | (currY & 0xF) << 8;
                    int neighbourLevel = neighbourNibble.getUpdating(neighbourIndex);
                    if (this.calculateLightValue(lightAccess, currX, currY, currZ, currentLevel) != currentLevel) {
                        this.chunkCheckDelayedUpdatesCenter[centerDelayedChecks++] = currentIndex;
                    }
                    if (this.calculateLightValue(lightAccess, neighbourX, currY, neighbourZ, neighbourLevel) != neighbourLevel) {
                        this.chunkCheckDelayedUpdatesNeighbour[neighbourDelayedChecks++] = neighbourIndex;
                    }
                    ++i2;
                    currX += incX;
                    currZ += incZ;
                }
            }
            int currentChunkOffX = chunkX << 4;
            int currentChunkOffZ = chunkZ << 4;
            int neighbourChunkOffX = chunkX + direction.x << 4;
            int neighbourChunkOffZ = chunkZ + direction.z << 4;
            int chunkOffY = chunkY << 4;
            int len = Math.max(centerDelayedChecks, neighbourDelayedChecks);
            for (int i3 = 0; i3 < len; ++i3) {
                int value;
                if (i3 < centerDelayedChecks) {
                    value = this.chunkCheckDelayedUpdatesCenter[i3];
                    this.checkBlock(lightAccess, currentChunkOffX | value & 0xF, chunkOffY | value >>> 8, currentChunkOffZ | value >>> 4 & 0xF);
                }
                if (i3 >= neighbourDelayedChecks) continue;
                value = this.chunkCheckDelayedUpdatesNeighbour[i3];
                this.checkBlock(lightAccess, neighbourChunkOffX | value & 0xF, chunkOffY | value >>> 8, neighbourChunkOffZ | value >>> 4 & 0xF);
            }
        }
    }

    protected void checkChunkEdges(ILightAccess lightAccess, IChunkAccess chunk, ShortCollection sections) {
        ChunkCoordIntPair chunkPos = chunk.f();
        int chunkX = chunkPos.e;
        int chunkZ = chunkPos.f;
        ShortIterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            this.checkChunkEdge(lightAccess, chunk, chunkX, iterator.nextShort(), chunkZ);
        }
        this.performLightDecrease(lightAccess);
    }

    protected void checkChunkEdges(ILightAccess lightAccess, IChunkAccess chunk, int fromSection, int toSection) {
        ChunkCoordIntPair chunkPos = chunk.f();
        int chunkX = chunkPos.e;
        int chunkZ = chunkPos.f;
        for (int currSectionY = toSection; currSectionY >= fromSection; --currSectionY) {
            this.checkChunkEdge(lightAccess, chunk, chunkX, currSectionY, chunkZ);
        }
        this.performLightDecrease(lightAccess);
    }

    protected final void propagateNeighbourLevels(ILightAccess lightAccess, IChunkAccess chunk, int fromSection, int toSection) {
        ChunkCoordIntPair chunkPos = chunk.f();
        int chunkX = chunkPos.e;
        int chunkZ = chunkPos.f;
        for (int currSectionY = toSection; currSectionY >= fromSection; --currSectionY) {
            SWMRNibbleArray currNibble = this.getNibbleFromCache(chunkX, currSectionY, chunkZ);
            if (currNibble == null) continue;
            for (AxisDirection direction : ONLY_HORIZONTAL_DIRECTIONS) {
                int currY;
                int startZ;
                int startX;
                int incZ;
                int incX;
                int neighbourOffX = direction.x;
                int neighbourOffZ = direction.z;
                SWMRNibbleArray neighbourNibble = this.getNibbleFromCache(chunkX + neighbourOffX, currSectionY, chunkZ + neighbourOffZ);
                if (neighbourNibble == null || !neighbourNibble.isInitialisedUpdating()) continue;
                if (neighbourOffX != 0) {
                    incX = 0;
                    incZ = 1;
                    startX = direction.x < 0 ? (chunkX << 4) - 1 : (chunkX << 4) + 16;
                    startZ = chunkZ << 4;
                } else {
                    incX = 1;
                    incZ = 0;
                    startZ = neighbourOffZ < 0 ? (chunkZ << 4) - 1 : (chunkZ << 4) + 16;
                    startX = chunkX << 4;
                }
                long propagateDirection = 1L << direction.getOpposite().ordinal();
                int encodeOffset = this.coordinateOffset;
                int maxY = currY | 0xF;
                for (currY = currSectionY << 4; currY <= maxY; ++currY) {
                    int i2 = 0;
                    int currX = startX;
                    int currZ = startZ;
                    while (i2 < 16) {
                        int level = neighbourNibble.getUpdating(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8);
                        if (level > 1) {
                            this.appendToIncreaseQueue((long)(currX + (currZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)level & 0xFL) << 28 | propagateDirection << 32 | Long.MIN_VALUE);
                        }
                        ++i2;
                        currX += incX;
                        currZ += incZ;
                    }
                }
            }
        }
    }

    public static Boolean[] getEmptySectionsForChunk(IChunkAccess chunk) {
        ChunkSection[] sections = chunk.d();
        Boolean[] ret = new Boolean[sections.length];
        for (int i2 = 0; i2 < sections.length; ++i2) {
            ret[i2] = sections[i2] == null || sections[i2].c() ? Boolean.TRUE : Boolean.FALSE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceHandleEmptySectionChanges(ILightAccess lightAccess, IChunkAccess chunk, Boolean[] emptinessChanges) {
        int chunkX = chunk.f().e;
        int chunkZ = chunk.f().f;
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, true);
        try {
            this.setChunkInCache(chunkX, chunkZ, chunk);
            this.setBlocksForChunkInCache(chunkX, chunkZ, chunk.d());
            this.setNibblesForChunkInCache(chunkX, chunkZ, this.getNibblesOnChunk(chunk));
            this.setEmptinessMapCache(chunkX, chunkZ, this.getEmptinessMap(chunk));
            boolean[] ret = this.handleEmptySectionChanges(lightAccess, chunk, emptinessChanges, false);
            if (ret != null) {
                this.setEmptinessMap(chunk, ret);
            }
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleEmptySectionChanges(ILightAccess lightAccess, int chunkX, int chunkZ, Boolean[] emptinessChanges) {
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, true);
        try {
            IChunkAccess chunk = this.getChunkInCache(chunkX, chunkZ);
            if (chunk == null) {
                return;
            }
            boolean[] ret = this.handleEmptySectionChanges(lightAccess, chunk, emptinessChanges, false);
            if (ret != null) {
                this.setEmptinessMap(chunk, ret);
            }
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    protected abstract void initNibble(int var1, int var2, int var3, boolean var4, boolean var5);

    protected abstract void setNibbleNull(int var1, int var2, int var3);

    protected final boolean[] handleEmptySectionChanges(ILightAccess lightAccess, IChunkAccess chunk, Boolean[] emptinessChanges, boolean unlit) {
        Boolean valueBoxed;
        int sectionIndex;
        boolean needsInit;
        World world = (World)lightAccess.q();
        int chunkX = chunk.f().e;
        int chunkZ = chunk.f().f;
        boolean[] chunkEmptinessMap = this.getEmptinessMap(chunkX, chunkZ);
        boolean[] ret = null;
        boolean bl = needsInit = unlit || chunkEmptinessMap == null;
        if (needsInit) {
            chunkEmptinessMap = new boolean[WorldUtil.getTotalSections(world)];
            ret = chunkEmptinessMap;
            this.setEmptinessMapCache(chunkX, chunkZ, chunkEmptinessMap);
        }
        for (sectionIndex = emptinessChanges.length - 1; sectionIndex >= 0; --sectionIndex) {
            valueBoxed = emptinessChanges[sectionIndex];
            if (valueBoxed == null) {
                if (!needsInit) continue;
                ChunkSection section = this.getChunkSection(chunkX, sectionIndex + this.minSection, chunkZ);
                valueBoxed = section == null || section.c() ? Boolean.TRUE : Boolean.FALSE;
                emptinessChanges[sectionIndex] = valueBoxed;
            }
            chunkEmptinessMap[sectionIndex] = valueBoxed;
        }
        for (sectionIndex = emptinessChanges.length - 1; sectionIndex >= 0; --sectionIndex) {
            boolean empty;
            valueBoxed = emptinessChanges[sectionIndex];
            int sectionY = sectionIndex + this.minSection;
            if (valueBoxed == null || (empty = valueBoxed.booleanValue())) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    boolean extrude = (dx | dz) != 0 || !unlit;
                    for (int dy = 1; dy >= -1; --dy) {
                        this.initNibble(dx + chunkX, dy + sectionY, dz + chunkZ, extrude, false);
                    }
                }
            }
        }
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                boolean neighboursLoaded = true;
                block7: for (int dz2 = -1; dz2 <= 1; ++dz2) {
                    for (int dx2 = -1; dx2 <= 1; ++dx2) {
                        if (this.getEmptinessMap(dx + dx2 + chunkX, dz + dz2 + chunkZ) != null) continue;
                        neighboursLoaded = false;
                        break block7;
                    }
                }
                for (int sectionY = this.maxLightSection; sectionY >= this.minLightSection; --sectionY) {
                    boolean allEmpty = true;
                    block10: for (int dy2 = -1; dy2 <= 1; ++dy2) {
                        for (int dz2 = -1; dz2 <= 1; ++dz2) {
                            for (int dx2 = -1; dx2 <= 1; ++dx2) {
                                int y2 = sectionY + dy2;
                                if (y2 < this.minSection || y2 > this.maxSection) continue;
                                boolean[] emptinessMap = this.getEmptinessMap(dx + dx2 + chunkX, dz + dz2 + chunkZ);
                                if (emptinessMap != null) {
                                    if (emptinessMap[y2 - this.minSection]) continue;
                                    allEmpty = false;
                                    break block10;
                                }
                                ChunkSection section = this.getChunkSection(dx + dx2 + chunkX, y2, dz + dz2 + chunkZ);
                                if (section == null || section.c()) continue;
                                allEmpty = false;
                                break block10;
                            }
                        }
                    }
                    if (allEmpty & neighboursLoaded) {
                        this.setNibbleNull(dx + chunkX, sectionY, dz + chunkZ);
                        continue;
                    }
                    if (allEmpty) continue;
                    boolean extrude = (dx | dz) != 0 || !unlit;
                    this.initNibble(dx + chunkX, sectionY, dz + chunkZ, extrude, false);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkChunkEdges(ILightAccess lightAccess, int chunkX, int chunkZ) {
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, false);
        try {
            IChunkAccess chunk = this.getChunkInCache(chunkX, chunkZ);
            if (chunk == null) {
                return;
            }
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkChunkEdges(ILightAccess lightAccess, int chunkX, int chunkZ, ShortCollection sections) {
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, false);
        try {
            IChunkAccess chunk = this.getChunkInCache(chunkX, chunkZ);
            if (chunk == null) {
                return;
            }
            this.checkChunkEdges(lightAccess, chunk, sections);
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    protected abstract void lightChunk(ILightAccess var1, IChunkAccess var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void light(ILightAccess lightAccess, IChunkAccess chunk, Boolean[] emptySections) {
        int chunkX = chunk.f().e;
        int chunkZ = chunk.f().f;
        this.setupCaches(lightAccess, chunkX * 16 + 7, 128, chunkZ * 16 + 7, true, true);
        try {
            SWMRNibbleArray[] nibbles = StarLightEngine.getFilledEmptyLight(this.maxLightSection - this.minLightSection + 1);
            this.setChunkInCache(chunkX, chunkZ, chunk);
            this.setBlocksForChunkInCache(chunkX, chunkZ, chunk.d());
            this.setNibblesForChunkInCache(chunkX, chunkZ, nibbles);
            this.setEmptinessMapCache(chunkX, chunkZ, this.getEmptinessMap(chunk));
            boolean[] ret = this.handleEmptySectionChanges(lightAccess, chunk, emptySections, true);
            if (ret != null) {
                this.setEmptinessMap(chunk, ret);
            }
            this.lightChunk(lightAccess, chunk, true);
            this.setNibbles(chunk, nibbles);
            this.updateVisible(lightAccess);
        }
        finally {
            this.destroyCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void relightChunks(ILightAccess lightAccess, Set<ChunkCoordIntPair> chunks, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        Long2ObjectOpenHashMap nibblesByChunk = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap emptinessMapByChunk = new Long2ObjectOpenHashMap();
        int[] neighbourLightOrder = new int[]{0, 0, -1, 0, 0, -1, 1, 0, 0, 1, -1, 1, 1, 1, -1, -1, 1, -1};
        int lightCalls = 0;
        for (ChunkCoordIntPair chunkPos : chunks) {
            SWMRNibbleArray[] nibbles;
            int chunkX = chunkPos.e;
            int chunkZ = chunkPos.f;
            IChunkAccess chunk = (IChunkAccess)lightAccess.c(chunkX, chunkZ);
            if (chunk == null || !this.canUseChunk(chunk)) {
                throw new IllegalStateException();
            }
            int len = neighbourLightOrder.length;
            for (int i2 = 0; i2 < len; i2 += 2) {
                int dx = neighbourLightOrder[i2];
                int neighbourX = dx + chunkX;
                int dz = neighbourLightOrder[i2 + 1];
                int neighbourZ = dz + chunkZ;
                IChunkAccess neighbour = (IChunkAccess)lightAccess.c(neighbourX, neighbourZ);
                if (neighbour == null || !this.canUseChunk(neighbour) || nibblesByChunk.get(CoordinateUtils.getChunkKey(neighbourX, neighbourZ)) != null) continue;
                this.setupEncodeOffset(neighbourX * 16 + 7, 128, neighbourZ * 16 + 7);
                try {
                    for (int dz2 = -1; dz2 <= 1; ++dz2) {
                        for (int dx2 = -1; dx2 <= 1; ++dx2) {
                            SWMRNibbleArray[] nibbles2;
                            int neighbourX2 = neighbourX + dx2;
                            int neighbourZ2 = neighbourZ + dz2;
                            long key = CoordinateUtils.getChunkKey(neighbourX2, neighbourZ2);
                            IChunkAccess neighbour2 = (IChunkAccess)lightAccess.c(neighbourX2, neighbourZ2);
                            if (neighbour2 == null || !this.canUseChunk(neighbour2) || (nibbles2 = (SWMRNibbleArray[])nibblesByChunk.get(key)) == null) continue;
                            this.setChunkInCache(neighbourX2, neighbourZ2, neighbour2);
                            this.setBlocksForChunkInCache(neighbourX2, neighbourZ2, neighbour2.d());
                            this.setNibblesForChunkInCache(neighbourX2, neighbourZ2, nibbles2);
                            this.setEmptinessMapCache(neighbourX2, neighbourZ2, (boolean[])emptinessMapByChunk.get(key));
                        }
                    }
                    long key = CoordinateUtils.getChunkKey(neighbourX, neighbourZ);
                    SWMRNibbleArray[] nibbles3 = StarLightEngine.getFilledEmptyLight(this.world);
                    nibblesByChunk.put(key, (Object)nibbles3);
                    this.setChunkInCache(neighbourX, neighbourZ, neighbour);
                    this.setBlocksForChunkInCache(neighbourX, neighbourZ, neighbour.d());
                    this.setNibblesForChunkInCache(neighbourX, neighbourZ, nibbles3);
                    boolean[] neighbourEmptiness = this.handleEmptySectionChanges(lightAccess, neighbour, StarLightEngine.getEmptySectionsForChunk(neighbour), true);
                    emptinessMapByChunk.put(key, (Object)neighbourEmptiness);
                    if (chunks.contains(new ChunkCoordIntPair(neighbourX, neighbourZ))) {
                        this.setEmptinessMap(neighbour, neighbourEmptiness);
                    }
                    this.lightChunk(lightAccess, neighbour, false);
                    continue;
                }
                finally {
                    this.destroyCaches();
                }
            }
            for (SWMRNibbleArray nibble : nibbles = (SWMRNibbleArray[])nibblesByChunk.get(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                nibble.updateVisible();
            }
            this.setNibbles(chunk, nibbles);
            for (int y2 = this.minLightSection; y2 <= this.maxLightSection; ++y2) {
                lightAccess.a(this.skylightPropagator ? EnumSkyBlock.a : EnumSkyBlock.b, SectionPosition.a(chunkX, y2, chunkX));
            }
            if (chunkLightCallback != null) {
                chunkLightCallback.accept(chunkPos);
            }
            ++lightCalls;
        }
        if (onComplete != null) {
            onComplete.accept(lightCalls);
        }
    }

    protected final long[] resizeIncreaseQueue() {
        this.increaseQueue = Arrays.copyOf(this.increaseQueue, this.increaseQueue.length * 2);
        return this.increaseQueue;
    }

    protected final long[] resizeDecreaseQueue() {
        this.decreaseQueue = Arrays.copyOf(this.decreaseQueue, this.decreaseQueue.length * 2);
        return this.decreaseQueue;
    }

    protected final void appendToIncreaseQueue(long value) {
        int idx;
        long[] queue = this.increaseQueue;
        if ((idx = this.increaseQueueInitialLength++) >= queue.length) {
            queue = this.resizeIncreaseQueue();
            queue[idx] = value;
        } else {
            queue[idx] = value;
        }
    }

    protected final void appendToDecreaseQueue(long value) {
        int idx;
        long[] queue = this.decreaseQueue;
        if ((idx = this.decreaseQueueInitialLength++) >= queue.length) {
            queue = this.resizeDecreaseQueue();
            queue[idx] = value;
        } else {
            queue[idx] = value;
        }
    }

    protected final void performLightIncrease(ILightAccess lightAccess) {
        IBlockAccess world = lightAccess.q();
        long[] queue = this.increaseQueue;
        int queueReadIndex = 0;
        int queueLength = this.increaseQueueInitialLength;
        this.increaseQueueInitialLength = 0;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int encodeOffset = this.coordinateOffset;
        int sectionOffset = this.chunkSectionIndexOffset;
        while (queueReadIndex < queueLength) {
            long queueValue = queue[queueReadIndex++];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            int propagatedLightLevel = (int)(queueValue >>> 28 & 0xFL);
            AxisDirection[] checkDirections = OLD_CHECK_DIRECTIONS[(int)(queueValue >>> 32 & 0x3FL)];
            if ((queueValue & 0x4000000000000000L) != 0L) {
                if (this.getLightLevel(posX, posY, posZ) != propagatedLightLevel) {
                    continue;
                }
            } else if ((queueValue & 0x2000000000000000L) != 0L) {
                this.setLightLevel(posX, posY, posZ, propagatedLightLevel);
            }
            if ((queueValue & Long.MIN_VALUE) == 0L) {
                for (AxisDirection propagate : checkDirections) {
                    int opacity;
                    int targetLevel;
                    IBlockData blockState;
                    int currentLevel;
                    int offX = posX + propagate.x;
                    int offY = posY + propagate.y;
                    int offZ = posZ + propagate.z;
                    int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
                    int localIndex = offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8;
                    SWMRNibbleArray currentNibble = this.nibbleCache[sectionIndex];
                    if (currentNibble == null || (currentLevel = currentNibble.getUpdating(localIndex)) >= propagatedLightLevel - 1 || (blockState = this.getBlockState(sectionIndex, localIndex)) == null) continue;
                    int opacityCached = blockState.getOpacityIfCached();
                    if (opacityCached != -1) {
                        int targetLevel2 = propagatedLightLevel - Math.max(1, opacityCached);
                        if (targetLevel2 <= currentLevel) continue;
                        currentNibble.set(localIndex, targetLevel2);
                        this.postLightUpdate(offX, offY, offZ);
                        if (targetLevel2 <= 1) continue;
                        if (queueLength >= queue.length) {
                            queue = this.resizeIncreaseQueue();
                        }
                        queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel2 & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32;
                        continue;
                    }
                    this.mutablePos1.d(offX, offY, offZ);
                    long flags = 0L;
                    if (blockState.isConditionallyFullOpaque()) {
                        VoxelShape cullingFace = blockState.a(world, (BlockPosition)this.mutablePos1, propagate.getOpposite().nms);
                        if (VoxelShapes.b(VoxelShapes.a(), cullingFace)) continue;
                        flags |= Long.MIN_VALUE;
                    }
                    if ((targetLevel = propagatedLightLevel - Math.max(1, opacity = blockState.b(world, (BlockPosition)this.mutablePos1))) <= currentLevel) continue;
                    currentNibble.set(localIndex, targetLevel);
                    this.postLightUpdate(offX, offY, offZ);
                    if (targetLevel <= 1) continue;
                    if (queueLength >= queue.length) {
                        queue = this.resizeIncreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32 | flags;
                }
                continue;
            }
            IBlockData fromBlock = this.getBlockState(posX, posY, posZ);
            this.mutablePos2.d(posX, posY, posZ);
            for (AxisDirection propagate : checkDirections) {
                int opacity;
                int targetLevel;
                IBlockData blockState;
                int currentLevel;
                VoxelShape fromShape;
                int offX = posX + propagate.x;
                int offY = posY + propagate.y;
                int offZ = posZ + propagate.z;
                VoxelShape voxelShape = fromShape = fromBlock.isConditionallyFullOpaque() ? fromBlock.a(world, (BlockPosition)this.mutablePos2, propagate.nms) : VoxelShapes.a();
                if (fromShape != VoxelShapes.a() && VoxelShapes.b(VoxelShapes.a(), fromShape)) continue;
                int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
                int localIndex = offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8;
                SWMRNibbleArray currentNibble = this.nibbleCache[sectionIndex];
                if (currentNibble == null || (currentLevel = currentNibble.getUpdating(localIndex)) >= propagatedLightLevel - 1 || (blockState = this.getBlockState(sectionIndex, localIndex)) == null) continue;
                int opacityCached = blockState.getOpacityIfCached();
                if (opacityCached != -1) {
                    int targetLevel3 = propagatedLightLevel - Math.max(1, opacityCached);
                    if (targetLevel3 <= currentLevel) continue;
                    currentNibble.set(localIndex, targetLevel3);
                    this.postLightUpdate(offX, offY, offZ);
                    if (targetLevel3 <= 1) continue;
                    if (queueLength >= queue.length) {
                        queue = this.resizeIncreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel3 & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32;
                    continue;
                }
                this.mutablePos1.d(offX, offY, offZ);
                long flags = 0L;
                if (blockState.isConditionallyFullOpaque()) {
                    VoxelShape cullingFace = blockState.a(world, (BlockPosition)this.mutablePos1, propagate.getOpposite().nms);
                    if (VoxelShapes.b(fromShape, cullingFace)) continue;
                    flags |= Long.MIN_VALUE;
                }
                if ((targetLevel = propagatedLightLevel - Math.max(1, opacity = blockState.b(world, (BlockPosition)this.mutablePos1))) <= currentLevel) continue;
                currentNibble.set(localIndex, targetLevel);
                this.postLightUpdate(offX, offY, offZ);
                if (targetLevel <= 1) continue;
                if (queueLength >= queue.length) {
                    queue = this.resizeIncreaseQueue();
                }
                queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32 | flags;
            }
        }
    }

    protected final void performLightDecrease(ILightAccess lightAccess) {
        IBlockAccess world = lightAccess.q();
        long[] queue = this.decreaseQueue;
        long[] increaseQueue = this.increaseQueue;
        int queueReadIndex = 0;
        int queueLength = this.decreaseQueueInitialLength;
        this.decreaseQueueInitialLength = 0;
        int increaseQueueLength = this.increaseQueueInitialLength;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int encodeOffset = this.coordinateOffset;
        int sectionOffset = this.chunkSectionIndexOffset;
        int emittedMask = this.emittedLightMask;
        while (queueReadIndex < queueLength) {
            long queueValue = queue[queueReadIndex++];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            int propagatedLightLevel = (int)(queueValue >>> 28 & 0xFL);
            AxisDirection[] checkDirections = OLD_CHECK_DIRECTIONS[(int)(queueValue >>> 32 & 0x3FL)];
            if ((queueValue & Long.MIN_VALUE) == 0L) {
                for (AxisDirection propagate : checkDirections) {
                    int opacity;
                    int targetLevel;
                    IBlockData blockState;
                    int lightLevel;
                    int offX = posX + propagate.x;
                    int offY = posY + propagate.y;
                    int offZ = posZ + propagate.z;
                    int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
                    int localIndex = offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8;
                    SWMRNibbleArray currentNibble = this.nibbleCache[sectionIndex];
                    if (currentNibble == null || (lightLevel = currentNibble.getUpdating(localIndex)) == 0 || (blockState = this.getBlockState(sectionIndex, localIndex)) == null) continue;
                    int opacityCached = blockState.getOpacityIfCached();
                    if (opacityCached != -1) {
                        int targetLevel2 = Math.max(0, propagatedLightLevel - Math.max(1, opacityCached));
                        if (lightLevel > targetLevel2) {
                            if (increaseQueueLength >= increaseQueue.length) {
                                increaseQueue = this.resizeIncreaseQueue();
                            }
                            increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)lightLevel & 0xFL) << 28 | 0x3F00000000L | 0x4000000000000000L;
                            continue;
                        }
                        int emittedLight = blockState.h() & emittedMask;
                        if (emittedLight != 0) {
                            if (increaseQueueLength >= increaseQueue.length) {
                                increaseQueue = this.resizeIncreaseQueue();
                            }
                            increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (blockState.isConditionallyFullOpaque() ? -6917529027641081856L : 0x2000000000000000L);
                        }
                        currentNibble.set(localIndex, 0);
                        this.postLightUpdate(offX, offY, offZ);
                        if (targetLevel2 <= 0) continue;
                        if (queueLength >= queue.length) {
                            queue = this.resizeDecreaseQueue();
                        }
                        queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel2 & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32;
                        continue;
                    }
                    this.mutablePos1.d(offX, offY, offZ);
                    long flags = 0L;
                    if (blockState.isConditionallyFullOpaque()) {
                        VoxelShape cullingFace = blockState.a(world, (BlockPosition)this.mutablePos1, propagate.getOpposite().nms);
                        if (VoxelShapes.b(VoxelShapes.a(), cullingFace)) continue;
                        flags |= Long.MIN_VALUE;
                    }
                    if (lightLevel > (targetLevel = Math.max(0, propagatedLightLevel - Math.max(1, opacity = blockState.b(world, (BlockPosition)this.mutablePos1))))) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)lightLevel & 0xFL) << 28 | 0x3F00000000L | (0x4000000000000000L | flags);
                        continue;
                    }
                    int emittedLight = blockState.h() & emittedMask;
                    if (emittedLight != 0) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (flags | 0x2000000000000000L);
                    }
                    currentNibble.set(localIndex, 0);
                    this.postLightUpdate(offX, offY, offZ);
                    if (targetLevel <= 0) continue;
                    if (queueLength >= queue.length) {
                        queue = this.resizeDecreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32 | flags;
                }
                continue;
            }
            IBlockData fromBlock = this.getBlockState(posX, posY, posZ);
            this.mutablePos2.d(posX, posY, posZ);
            for (AxisDirection propagate : checkDirections) {
                int opacity;
                int targetLevel;
                IBlockData blockState;
                int lightLevel;
                SWMRNibbleArray currentNibble;
                VoxelShape fromShape;
                int offX = posX + propagate.x;
                int offY = posY + propagate.y;
                int offZ = posZ + propagate.z;
                int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
                int localIndex = offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8;
                VoxelShape voxelShape = fromShape = fromBlock.isConditionallyFullOpaque() ? fromBlock.a(world, (BlockPosition)this.mutablePos2, propagate.nms) : VoxelShapes.a();
                if (fromShape != VoxelShapes.a() && VoxelShapes.b(VoxelShapes.a(), fromShape) || (currentNibble = this.nibbleCache[sectionIndex]) == null || (lightLevel = currentNibble.getUpdating(localIndex)) == 0 || (blockState = this.getBlockState(sectionIndex, localIndex)) == null) continue;
                int opacityCached = blockState.getOpacityIfCached();
                if (opacityCached != -1) {
                    int targetLevel3 = Math.max(0, propagatedLightLevel - Math.max(1, opacityCached));
                    if (lightLevel > targetLevel3) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)lightLevel & 0xFL) << 28 | 0x3F00000000L | 0x4000000000000000L;
                        continue;
                    }
                    int emittedLight = blockState.h() & emittedMask;
                    if (emittedLight != 0) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (blockState.isConditionallyFullOpaque() ? -6917529027641081856L : 0x2000000000000000L);
                    }
                    currentNibble.set(localIndex, 0);
                    this.postLightUpdate(offX, offY, offZ);
                    if (targetLevel3 <= 0) continue;
                    if (queueLength >= queue.length) {
                        queue = this.resizeDecreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel3 & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32;
                    continue;
                }
                this.mutablePos1.d(offX, offY, offZ);
                long flags = 0L;
                if (blockState.isConditionallyFullOpaque()) {
                    VoxelShape cullingFace = blockState.a(world, (BlockPosition)this.mutablePos1, propagate.getOpposite().nms);
                    if (VoxelShapes.b(fromShape, cullingFace)) continue;
                    flags |= Long.MIN_VALUE;
                }
                if (lightLevel > (targetLevel = Math.max(0, propagatedLightLevel - Math.max(1, opacity = blockState.b(world, (BlockPosition)this.mutablePos1))))) {
                    if (increaseQueueLength >= increaseQueue.length) {
                        increaseQueue = this.resizeIncreaseQueue();
                    }
                    increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)lightLevel & 0xFL) << 28 | 0x3F00000000L | (0x4000000000000000L | flags);
                    continue;
                }
                int emittedLight = blockState.h() & emittedMask;
                if (emittedLight != 0) {
                    if (increaseQueueLength >= increaseQueue.length) {
                        increaseQueue = this.resizeIncreaseQueue();
                    }
                    increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (flags | 0x2000000000000000L);
                }
                currentNibble.set(localIndex, 0);
                this.postLightUpdate(offX, offY, offZ);
                if (targetLevel <= 0) continue;
                if (queueLength >= queue.length) {
                    queue = this.resizeDecreaseQueue();
                }
                queue[queueLength++] = (long)(offX + (offZ << 6) + (offY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)targetLevel & 0xFL) << 28 | propagate.everythingButTheOppositeDirection << 32 | flags;
            }
        }
        this.increaseQueueInitialLength = increaseQueueLength;
        this.performLightIncrease(lightAccess);
    }

    static {
        for (int i2 = 0; i2 < OLD_CHECK_DIRECTIONS.length; ++i2) {
            ArrayList<AxisDirection> directions = new ArrayList<AxisDirection>();
            int bitset = i2;
            int len = Integer.bitCount(i2);
            int index = 0;
            while (index < len) {
                directions.add(AXIS_DIRECTIONS[IntegerUtil.trailingZeros(bitset)]);
                ++index;
                bitset ^= IntegerUtil.getTrailingBit(bitset);
            }
            StarLightEngine.OLD_CHECK_DIRECTIONS[i2] = directions.toArray(new AxisDirection[0]);
        }
    }

    protected static enum AxisDirection {
        POSITIVE_X(1, 0, 0),
        NEGATIVE_X(-1, 0, 0),
        POSITIVE_Z(0, 0, 1),
        NEGATIVE_Z(0, 0, -1),
        POSITIVE_Y(0, 1, 0),
        NEGATIVE_Y(0, -1, 0);

        protected AxisDirection opposite;
        public final int x;
        public final int y;
        public final int z;
        public final EnumDirection nms;
        public final long everythingButThisDirection;
        public final long everythingButTheOppositeDirection;

        private AxisDirection(int x2, int y2, int z2) {
            this.x = x2;
            this.y = y2;
            this.z = z2;
            this.nms = EnumDirection.a(x2, y2, z2);
            this.everythingButThisDirection = 0x3F ^ 1 << this.ordinal();
            this.everythingButTheOppositeDirection = 0x3F ^ 1 << (this.ordinal() ^ 1);
        }

        public AxisDirection getOpposite() {
            return this.opposite;
        }

        static {
            AxisDirection.POSITIVE_X.opposite = NEGATIVE_X;
            AxisDirection.NEGATIVE_X.opposite = POSITIVE_X;
            AxisDirection.POSITIVE_Z.opposite = NEGATIVE_Z;
            AxisDirection.NEGATIVE_Z.opposite = POSITIVE_Z;
            AxisDirection.POSITIVE_Y.opposite = NEGATIVE_Y;
            AxisDirection.NEGATIVE_Y.opposite = POSITIVE_Y;
        }
    }
}

