/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.light.BlockStarLightEngine;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.SkyStarLightEngine;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import io.papermc.paper.chunk.system.light.LightQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;

public final class StarLightInterface {
    public static final TicketType<ChunkCoordIntPair> CHUNK_WORK_TICKET = TicketType.a("starlight_chunk_work_ticket", (p1, p2) -> Long.compare(p1.a(), p2.a()));
    protected final World world;
    protected final ILightAccess lightAccess;
    protected final ArrayDeque<SkyStarLightEngine> cachedSkyPropagators;
    protected final ArrayDeque<BlockStarLightEngine> cachedBlockPropagators;
    public final io.papermc.paper.chunk.system.light.LightQueue lightQueue;
    protected final LightEngineLayerEventListener skyReader;
    protected final LightEngineLayerEventListener blockReader;
    protected final boolean isClientSide;
    public final int minSection;
    public final int maxSection;
    protected final int minLightSection;
    protected final int maxLightSection;
    public final LevelLightEngine lightEngine;
    private final boolean hasBlockLight;
    private final boolean hasSkyLight;

    public StarLightInterface(ILightAccess lightAccess, boolean hasSkyLight, boolean hasBlockLight, LevelLightEngine lightEngine) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (World)lightAccess.q();
        this.cachedSkyPropagators = hasSkyLight && lightAccess != null ? new ArrayDeque() : null;
        this.cachedBlockPropagators = hasBlockLight && lightAccess != null ? new ArrayDeque() : null;
        boolean bl = this.isClientSide = !(this.world instanceof WorldServer);
        if (this.world == null) {
            this.minSection = -4;
            this.maxSection = 19;
            this.minLightSection = -5;
            this.maxLightSection = 20;
        } else {
            this.minSection = WorldUtil.getMinSection(this.world);
            this.maxSection = WorldUtil.getMaxSection(this.world);
            this.minLightSection = WorldUtil.getMinLightSection(this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection(this.world);
        }
        this.lightEngine = lightEngine;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
        this.skyReader = !hasSkyLight ? LightEngineLayerEventListener.Void.a : new LightEngineLayerEventListener(){

            @Override
            public void a(BlockPosition blockPos) {
                StarLightInterface.this.lightEngine.a(blockPos.i());
            }

            @Override
            public void b(ChunkCoordIntPair chunkPos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean E_() {
                return StarLightInterface.this.hasUpdates();
            }

            @Override
            public int a() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void a(ChunkCoordIntPair chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public NibbleArray a(SectionPosition pos) {
                IChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.u(), pos.w());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
                    return null;
                }
                int sectionY = pos.v();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (chunk.getSkyEmptinessMap() == null) {
                    return null;
                }
                return chunk.getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            @Override
            public int b(BlockPosition blockPos) {
                return StarLightInterface.this.getSkyLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.u() >> 4, blockPos.w() >> 4));
            }

            @Override
            public void a(SectionPosition pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? LightEngineLayerEventListener.Void.a : new LightEngineLayerEventListener(){

            @Override
            public void a(BlockPosition blockPos) {
                StarLightInterface.this.lightEngine.a(blockPos.i());
            }

            @Override
            public void b(ChunkCoordIntPair chunkPos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean E_() {
                return StarLightInterface.this.hasUpdates();
            }

            @Override
            public int a() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void a(ChunkCoordIntPair chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public NibbleArray a(SectionPosition pos) {
                IChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.u(), pos.w());
                if (chunk == null || pos.v() < StarLightInterface.this.minLightSection || pos.v() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return chunk.getBlockNibbles()[pos.v() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            @Override
            public int b(BlockPosition blockPos) {
                return StarLightInterface.this.getBlockLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.u() >> 4, blockPos.w() >> 4));
            }

            @Override
            public void a(SectionPosition pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.lightQueue = new io.papermc.paper.chunk.system.light.LightQueue(this);
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasBlockLight() {
        return this.hasBlockLight;
    }

    public int getSkyLightValue(BlockPosition blockPos, IChunkAccess chunk) {
        int currY;
        SWMRNibbleArray[] nibbles;
        SWMRNibbleArray immediate;
        if (!this.hasSkyLight) {
            return 0;
        }
        int x2 = blockPos.u();
        int y2 = blockPos.v();
        int z2 = blockPos.w();
        int minSection = this.minSection;
        int maxSection = this.maxSection;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (chunk == null || !this.isClientSide && !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
            return 15;
        }
        int sectionY = y2 >> 4;
        if (sectionY > maxLightSection) {
            return 15;
        }
        if (sectionY < minLightSection) {
            sectionY = minLightSection;
            y2 = sectionY << 4;
        }
        if (!(immediate = (nibbles = chunk.getSkyNibbles())[sectionY - minLightSection]).isNullNibbleVisible()) {
            return immediate.getVisible(x2, y2, z2);
        }
        boolean[] emptinessMap = chunk.getSkyEmptinessMap();
        if (emptinessMap == null) {
            return 15;
        }
        int lowestY = minLightSection - 1;
        for (currY = maxSection; currY >= minSection; --currY) {
            if (emptinessMap[currY - minSection]) continue;
            lowestY = currY;
            break;
        }
        if (sectionY > lowestY) {
            return 15;
        }
        for (currY = sectionY + 1; currY <= maxLightSection; ++currY) {
            SWMRNibbleArray nibble = nibbles[currY - minLightSection];
            if (nibble.isNullNibbleVisible()) continue;
            return nibble.getVisible(x2, 0, z2);
        }
        return 15;
    }

    public int getBlockLightValue(BlockPosition blockPos, IChunkAccess chunk) {
        if (!this.hasBlockLight) {
            return 0;
        }
        int y2 = blockPos.v();
        int cy = y2 >> 4;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (cy < minLightSection || cy > maxLightSection) {
            return 0;
        }
        if (chunk == null) {
            return 0;
        }
        SWMRNibbleArray nibble = chunk.getBlockNibbles()[cy - minLightSection];
        return nibble.getVisible(blockPos.u(), y2, blockPos.w());
    }

    public int getRawBrightness(BlockPosition pos, int ambientDarkness) {
        IChunkAccess chunk = this.getAnyChunkNow(pos.u() >> 4, pos.w() >> 4);
        int sky = this.getSkyLightValue(pos, chunk) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.getBlockLightValue(pos, chunk);
        return Math.max(sky, block);
    }

    public LightEngineLayerEventListener getSkyReader() {
        return this.skyReader;
    }

    public LightEngineLayerEventListener getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public IChunkAccess getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        ChunkProviderServer chunkProvider = ((WorldServer)this.world).k();
        Chunk fullLoaded = chunkProvider.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (fullLoaded != null) {
            return fullLoaded;
        }
        return chunkProvider.getChunkAtImmediately(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public World getWorld() {
        return this.world;
    }

    public ILightAccess getLightAccess() {
        return this.lightAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SkyStarLightEngine getSkyLightEngine() {
        SkyStarLightEngine ret;
        if (this.cachedSkyPropagators == null) {
            return null;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedSkyPropagators.pollFirst();
        }
        if (ret == null) {
            return new SkyStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (this.cachedSkyPropagators == null) {
            return;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            this.cachedSkyPropagators.addFirst(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BlockStarLightEngine getBlockLightEngine() {
        BlockStarLightEngine ret;
        if (this.cachedBlockPropagators == null) {
            return null;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedBlockPropagators.pollFirst();
        }
        if (ret == null) {
            return new BlockStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (this.cachedBlockPropagators == null) {
            return;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            this.cachedBlockPropagators.addFirst(engine);
        }
    }

    public LightQueue.ChunkTasks blockChange(BlockPosition pos) {
        if (this.world == null || pos.v() < WorldUtil.getMinBlockY(this.world) || pos.v() > WorldUtil.getMaxBlockY(this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public LightQueue.ChunkTasks sectionChange(SectionPosition pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(IChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(IChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<ChunkCoordIntPair> chunks, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ, ShortCollection sections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ, ShortCollection sections) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void scheduleChunkLight(ChunkCoordIntPair pos, Runnable run) {
        throw new UnsupportedOperationException("No longer implemented, use the new lightQueue field to queue tasks");
    }

    public void removeChunkTasks(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException("No longer implemented, use the new lightQueue field to queue tasks");
    }

    public void propagateChanges() {
        throw new UnsupportedOperationException("No longer implemented, task draining is now performed by the light thread");
    }

    public static final class LightQueue {
        protected final Long2ObjectLinkedOpenHashMap<ChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();
        protected final StarLightInterface manager;

        public LightQueue(StarLightInterface manager) {
            this.manager = manager;
        }

        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        public synchronized ChunkTasks queueBlockChange(BlockPosition pos) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            tasks.changedPositions.add(pos.i());
            return tasks;
        }

        public synchronized ChunkTasks queueSectionChange(SectionPosition pos, boolean newEmptyValue) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.changedSectionSet == null) {
                tasks.changedSectionSet = new Boolean[this.manager.maxSection - this.manager.minSection + 1];
            }
            tasks.changedSectionSet[pos.v() - this.manager.minSection] = newEmptyValue;
            return tasks;
        }

        public synchronized ChunkTasks queueChunkLighting(ChunkCoordIntPair pos, Runnable lightTask) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.lightTasks == null) {
                tasks.lightTasks = new ArrayList<Runnable>();
            }
            tasks.lightTasks.add(lightTask);
            return tasks;
        }

        public synchronized ChunkTasks queueChunkSkylightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksSky;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksSky = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks;
        }

        public synchronized ChunkTasks queueChunkBlocklightEdgeCheck(SectionPosition pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksBlock;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksBlock = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChunk(ChunkCoordIntPair pos) {
            ChunkTasks tasks;
            LightQueue lightQueue = this;
            synchronized (lightQueue) {
                tasks = (ChunkTasks)this.chunkTasks.remove(CoordinateUtils.getChunkKey(pos));
            }
            if (tasks != null) {
                tasks.onComplete.complete(null);
            }
        }

        public synchronized ChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ChunkTasks)this.chunkTasks.removeFirst();
        }

        public static final class ChunkTasks {
            public final Set<BlockPosition> changedPositions = new ObjectOpenHashSet();
            public Boolean[] changedSectionSet;
            public ShortOpenHashSet queuedEdgeChecksSky;
            public ShortOpenHashSet queuedEdgeChecksBlock;
            public List<Runnable> lightTasks;
            public boolean isTicketAdded = false;
            public final CompletableFuture<Void> onComplete = new CompletableFuture();
            public final long chunkCoordinate;

            public ChunkTasks(long chunkCoordinate) {
                this.chunkCoordinate = chunkCoordinate;
            }
        }
    }
}

