/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.ExtraCodecs;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transformation {
    private final Matrix4f c;
    public static final Codec<Transformation> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.d.fieldOf("translation").forGetter(transformation -> transformation.e), (App)ExtraCodecs.g.fieldOf("left_rotation").forGetter(affineTransformation -> affineTransformation.f), (App)ExtraCodecs.d.fieldOf("scale").forGetter(affineTransformation -> affineTransformation.g), (App)ExtraCodecs.g.fieldOf("right_rotation").forGetter(affineTransformation -> affineTransformation.h)).apply((Applicative)instance, Transformation::new));
    public static final Codec<Transformation> b = Codec.either(a, (Codec)ExtraCodecs.h.xmap(Transformation::new, Transformation::c)).xmap(either -> either.map(affineTransformation -> affineTransformation, affineTransformation -> affineTransformation), Either::left);
    private boolean d;
    @Nullable
    private Vector3f e;
    @Nullable
    private Quaternionf f;
    @Nullable
    private Vector3f g;
    @Nullable
    private Quaternionf h;
    private static final Transformation i = SystemUtils.a(() -> {
        Transformation transformation = new Transformation(new Matrix4f());
        transformation.e = new Vector3f();
        transformation.f = new Quaternionf();
        transformation.g = new Vector3f(1.0f, 1.0f, 1.0f);
        transformation.h = new Quaternionf();
        transformation.d = true;
        return transformation;
    });

    public Transformation(@Nullable Matrix4f matrix) {
        this.c = matrix == null ? new Matrix4f() : matrix;
    }

    public Transformation(@Nullable Vector3f translation, @Nullable Quaternionf leftRotation, @Nullable Vector3f scale, @Nullable Quaternionf rightRotation) {
        this.c = Transformation.a(translation, leftRotation, scale, rightRotation);
        this.e = translation != null ? translation : new Vector3f();
        this.f = leftRotation != null ? leftRotation : new Quaternionf();
        this.g = scale != null ? scale : new Vector3f(1.0f, 1.0f, 1.0f);
        this.h = rightRotation != null ? rightRotation : new Quaternionf();
        this.d = true;
    }

    public static Transformation a() {
        return i;
    }

    public Transformation a(Transformation other) {
        Matrix4f matrix4f = this.c();
        matrix4f.mul((Matrix4fc)other.c());
        return new Transformation(matrix4f);
    }

    @Nullable
    public Transformation b() {
        if (this == i) {
            return this;
        }
        Matrix4f matrix4f = this.c().invert();
        if (matrix4f.isFinite()) {
            return new Transformation(matrix4f);
        }
        return null;
    }

    private void h() {
        if (!this.d) {
            float f2 = 1.0f / this.c.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> triple = MatrixUtil.a(new Matrix3f((Matrix4fc)this.c).scale(f2));
            this.e = this.c.getTranslation(new Vector3f()).mul(f2);
            this.f = new Quaternionf((Quaternionfc)triple.getLeft());
            this.g = new Vector3f((Vector3fc)triple.getMiddle());
            this.h = new Quaternionf((Quaternionfc)triple.getRight());
            this.d = true;
        }
    }

    private static Matrix4f a(@Nullable Vector3f translation, @Nullable Quaternionf leftRotation, @Nullable Vector3f scale, @Nullable Quaternionf rightRotation) {
        Matrix4f matrix4f = new Matrix4f();
        if (translation != null) {
            matrix4f.translation((Vector3fc)translation);
        }
        if (leftRotation != null) {
            matrix4f.rotate((Quaternionfc)leftRotation);
        }
        if (scale != null) {
            matrix4f.scale((Vector3fc)scale);
        }
        if (rightRotation != null) {
            matrix4f.rotate((Quaternionfc)rightRotation);
        }
        return matrix4f;
    }

    public Matrix4f c() {
        return new Matrix4f((Matrix4fc)this.c);
    }

    public Vector3f d() {
        this.h();
        return new Vector3f((Vector3fc)this.e);
    }

    public Quaternionf e() {
        this.h();
        return new Quaternionf((Quaternionfc)this.f);
    }

    public Vector3f f() {
        this.h();
        return new Vector3f((Vector3fc)this.g);
    }

    public Quaternionf g() {
        this.h();
        return new Quaternionf((Quaternionfc)this.h);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Transformation transformation = (Transformation)object;
        return Objects.equals(this.c, transformation.c);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.c);
    }

    public Transformation a(Transformation target, float factor) {
        Vector3f vector3f = this.d();
        Quaternionf quaternionf = this.e();
        Vector3f vector3f2 = this.f();
        Quaternionf quaternionf2 = this.g();
        vector3f.lerp((Vector3fc)target.d(), factor);
        quaternionf.slerp((Quaternionfc)target.e(), factor);
        vector3f2.lerp((Vector3fc)target.f(), factor);
        quaternionf2.slerp((Quaternionfc)target.g(), factor);
        return new Transformation(vector3f, quaternionf, vector3f2, quaternionf2);
    }
}

