/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import com.mojang.logging.LogUtils;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.configuration.ConfigurationLoaders;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.configuration.constraint.Constraint;
import io.papermc.paper.configuration.constraint.Constraints;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.Constraint;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedFunction;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public abstract class Configurations<G, W> {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final String WORLD_DEFAULTS = "__world_defaults__";
    public static final MinecraftKey WORLD_DEFAULTS_KEY = new MinecraftKey("configurations", "__world_defaults__");
    protected final Path globalFolder;
    protected final Class<G> globalConfigClass;
    protected final Class<W> worldConfigClass;
    protected final String globalConfigFileName;
    protected final String defaultWorldConfigFileName;
    protected final String worldConfigFileName;
    public static final ContextKey<Path> WORLD_DIRECTORY = new ContextKey<Path>(Path.class, "world directory");
    public static final ContextKey<String> WORLD_NAME = new ContextKey<String>(String.class, "world name");
    public static final ContextKey<MinecraftKey> WORLD_KEY = new ContextKey<MinecraftKey>(MinecraftKey.class, "world key");
    public static final ContextKey<Void> FIRST_DEFAULT = new ContextKey<Void>(Void.class, "first default");

    public Configurations(Path globalFolder, Class<G> globalConfigType, Class<W> worldConfigClass, String globalConfigFileName, String defaultWorldConfigFileName, String worldConfigFileName) {
        this.globalFolder = globalFolder;
        this.globalConfigClass = globalConfigType;
        this.worldConfigClass = worldConfigClass;
        this.globalConfigFileName = globalConfigFileName;
        this.defaultWorldConfigFileName = defaultWorldConfigFileName;
        this.worldConfigFileName = worldConfigFileName;
    }

    protected ObjectMapper.Factory.Builder createObjectMapper() {
        return ObjectMapper.factoryBuilder().addConstraint(Constraint.class, (Constraint.Factory)new Constraint.Factory()).addConstraint(Constraints.Min.class, Number.class, (Constraint.Factory)new Constraints.Min.Factory());
    }

    protected YamlConfigurationLoader.Builder createLoaderBuilder() {
        return ConfigurationLoaders.naturallySorted();
    }

    protected abstract boolean isConfigType(Type var1);

    protected ObjectMapper.Factory.Builder createGlobalObjectMapperFactoryBuilder() {
        return this.createObjectMapper();
    }

    @MustBeInvokedByOverriders
    protected YamlConfigurationLoader.Builder createGlobalLoaderBuilder() {
        return this.createLoaderBuilder();
    }

    static <T> CheckedFunction<ConfigurationNode, T, SerializationException> creator(Class<T> type, boolean refreshNode) {
        return node -> {
            Object instance = node.require(type);
            if (refreshNode) {
                node.set(type, instance);
            }
            return instance;
        };
    }

    static <T> CheckedFunction<ConfigurationNode, T, SerializationException> reloader(Class<T> type, T instance) {
        return node -> {
            ObjectMapper.Factory factory = (ObjectMapper.Factory)Objects.requireNonNull(node.options().serializers().get(type));
            ObjectMapper.Mutable mutable = (ObjectMapper.Mutable)factory.get(type);
            mutable.load(instance, node);
            return instance;
        };
    }

    public G initializeGlobalConfiguration() throws ConfigurateException {
        return this.initializeGlobalConfiguration(Configurations.creator(this.globalConfigClass, true));
    }

    private void trySaveFileNode(YamlConfigurationLoader loader, ConfigurationNode node, String filename) throws ConfigurateException {
        try {
            loader.save(node);
        }
        catch (ConfigurateException ex) {
            if (ex.getCause() instanceof AccessDeniedException) {
                LOGGER.warn("Could not save {}: Paper could not persist the full set of configuration settings in the configuration file. Any setting missing from the configuration file will be set with its default value in memory. Admins should make sure to review the configuration documentation at https://docs.papermc.io/paper/configuration for more details.", (Object)filename, (Object)ex);
            }
            throw ex;
        }
    }

    protected G initializeGlobalConfiguration(CheckedFunction<ConfigurationNode, G, SerializationException> creator) throws ConfigurateException {
        Path configFile = this.globalFolder.resolve(this.globalConfigFileName);
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)this.createGlobalLoaderBuilder().defaultOptions(this.applyObjectMapperFactory(this.createGlobalObjectMapperFactoryBuilder().build()))).path(configFile)).build();
        Object node = Files.exists(configFile, new LinkOption[0]) ? loader.load() : CommentedConfigurationNode.root((ConfigurationOptions)loader.defaultOptions());
        this.applyGlobalConfigTransformations((ConfigurationNode)node);
        Object instance = creator.apply(node);
        this.trySaveFileNode(loader, (ConfigurationNode)node, configFile.toString());
        return (G)instance;
    }

    protected void applyGlobalConfigTransformations(ConfigurationNode node) throws ConfigurateException {
    }

    @MustBeInvokedByOverriders
    protected ContextMap.Builder createDefaultContextMap() {
        return ContextMap.builder().put(WORLD_NAME, WORLD_DEFAULTS).put(WORLD_KEY, WORLD_DEFAULTS_KEY);
    }

    public void initializeWorldDefaultsConfiguration() throws ConfigurateException {
        ContextMap contextMap = this.createDefaultContextMap().put(FIRST_DEFAULT).build();
        Path configFile = this.globalFolder.resolve(this.defaultWorldConfigFileName);
        DefaultWorldLoader result = this.createDefaultWorldLoader(false, contextMap, configFile);
        YamlConfigurationLoader loader = result.loader();
        ConfigurationNode node = loader.load();
        if (result.isNewFile()) {
            node.node(new Object[]{"_version"}).raw((Object)30);
        }
        this.applyWorldConfigTransformations(contextMap, node);
        Object instance = node.require(this.worldConfigClass);
        node.set(this.worldConfigClass, instance);
        this.trySaveFileNode(loader, node, configFile.toString());
    }

    private DefaultWorldLoader createDefaultWorldLoader(boolean requireFile, ContextMap contextMap, Path configFile) {
        boolean willCreate = Files.notExists(configFile, new LinkOption[0]);
        if (requireFile && willCreate) {
            throw new IllegalStateException("World defaults configuration file '" + configFile + "' doesn't exist");
        }
        return new DefaultWorldLoader(((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)this.createWorldConfigLoaderBuilder(contextMap).defaultOptions(this.applyObjectMapperFactory(this.createWorldObjectMapperFactoryBuilder(contextMap).build()))).path(configFile)).build(), willCreate);
    }

    protected ObjectMapper.Factory.Builder createWorldObjectMapperFactoryBuilder(ContextMap contextMap) {
        return this.createObjectMapper();
    }

    @MustBeInvokedByOverriders
    protected YamlConfigurationLoader.Builder createWorldConfigLoaderBuilder(ContextMap contextMap) {
        return this.createLoaderBuilder();
    }

    public W createWorldConfig(ContextMap contextMap) throws IOException {
        return this.createWorldConfig(contextMap, Configurations.creator(this.worldConfigClass, false));
    }

    protected W createWorldConfig(ContextMap contextMap, CheckedFunction<ConfigurationNode, W, SerializationException> creator) throws IOException {
        Path defaultsConfigFile = this.globalFolder.resolve(this.defaultWorldConfigFileName);
        YamlConfigurationLoader defaultsLoader = this.createDefaultWorldLoader(true, this.createDefaultContextMap().build(), defaultsConfigFile).loader();
        ConfigurationNode defaultsNode = defaultsLoader.load();
        boolean newFile = false;
        Path dir = contextMap.require(WORLD_DIRECTORY);
        Path worldConfigFile = dir.resolve(this.worldConfigFileName);
        if (Files.notExists(worldConfigFile, new LinkOption[0])) {
            PaperConfigurations.createDirectoriesSymlinkAware(dir);
            Files.createFile(worldConfigFile, new FileAttribute[0]);
            newFile = true;
        }
        YamlConfigurationLoader worldLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)this.createWorldConfigLoaderBuilder(contextMap).defaultOptions(this.applyObjectMapperFactory(this.createWorldObjectMapperFactoryBuilder(contextMap).build()))).path(worldConfigFile)).build();
        ConfigurationNode worldNode = worldLoader.load();
        if (newFile) {
            worldNode.node(new Object[]{"_version"}).set((Object)30);
        }
        this.applyWorldConfigTransformations(contextMap, worldNode);
        this.applyDefaultsAwareWorldConfigTransformations(contextMap, worldNode, defaultsNode);
        this.trySaveFileNode(worldLoader, worldNode, worldConfigFile.toString());
        worldNode.mergeFrom(defaultsNode);
        return (W)creator.apply((Object)worldNode);
    }

    protected void applyWorldConfigTransformations(ContextMap contextMap, ConfigurationNode node) throws ConfigurateException {
    }

    protected void applyDefaultsAwareWorldConfigTransformations(ContextMap contextMap, ConfigurationNode worldNode, ConfigurationNode defaultsNode) throws ConfigurateException {
    }

    private UnaryOperator<ConfigurationOptions> applyObjectMapperFactory(ObjectMapper.Factory factory) {
        return options -> options.serializers(builder -> builder.register(this::isConfigType, factory.asTypeSerializer()).registerAnnotatedObjects(factory));
    }

    public Path getWorldConfigFile(WorldServer level) {
        return level.convertable.c.f().resolve(this.worldConfigFileName);
    }

    public static class ContextMap {
        private static final Object VOID = new Object();
        private final Map<ContextKey<?>, Object> backingMap;

        public static Builder builder() {
            return new Builder();
        }

        private ContextMap(Map<ContextKey<?>, Object> map) {
            this.backingMap = Map.copyOf(map);
        }

        public <T> T require(ContextKey<T> key) {
            @Nullable Object value = this.backingMap.get(key);
            if (value == null) {
                throw new NoSuchElementException("No element found for " + key + " with type " + key.type());
            }
            if (value == VOID) {
                throw new IllegalArgumentException("Cannot get the value of a Void key");
            }
            return (T)value;
        }

        public <T> @Nullable T get(ContextKey<T> key) {
            return (T)this.backingMap.get(key);
        }

        public boolean has(ContextKey<?> key) {
            return this.backingMap.containsKey(key);
        }

        public boolean isDefaultWorldContext() {
            return this.require(WORLD_KEY).equals(WORLD_DEFAULTS_KEY);
        }

        public static class Builder {
            private final Map<ContextKey<?>, Object> buildingMap = new HashMap();

            private Builder() {
            }

            public <T> Builder put(ContextKey<T> key, T value) {
                this.buildingMap.put(key, value);
                return this;
            }

            public Builder put(ContextKey<Void> key) {
                this.buildingMap.put(key, VOID);
                return this;
            }

            public ContextMap build() {
                return new ContextMap(this.buildingMap);
            }
        }
    }

    public record ContextKey<T>(TypeToken<T> type, String name) {
        public ContextKey(Class<T> type, String name) {
            this(TypeToken.get(type), name);
        }

        @Override
        public String toString() {
            return "ContextKey{" + this.name + "}";
        }
    }

    private record DefaultWorldLoader(YamlConfigurationLoader loader, boolean isNewFile) {
    }
}

