/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public interface IntOr {
    public static final Logger LOGGER = LogUtils.getClassLogger();

    default public int or(int fallback) {
        return this.value().orElse(fallback);
    }

    public OptionalInt value();

    default public int intValue() {
        return this.value().orElseThrow();
    }

    public static final class Serializer<T extends IntOr>
    extends ScalarSerializer<T> {
        private final Function<OptionalInt, T> creator;
        private final String otherSerializedValue;
        private final T otherValue;

        public Serializer(Class<T> classOfT, Function<OptionalInt, T> creator, String otherSerializedValue, T otherValue) {
            super(classOfT);
            this.creator = creator;
            this.otherSerializedValue = otherSerializedValue;
            this.otherValue = otherValue;
        }

        public T deserialize(Type type, Object obj) throws SerializationException {
            if (obj instanceof String) {
                String string = (String)obj;
                if (this.otherSerializedValue.equalsIgnoreCase(string)) {
                    return this.otherValue;
                }
                if (NumberUtils.isParsable((String)string)) {
                    return (T)((IntOr)this.creator.apply(OptionalInt.of(Integer.parseInt(string))));
                }
            } else if (obj instanceof Number) {
                Number num = (Number)obj;
                if ((double)num.intValue() != num.doubleValue() || (long)num.intValue() != num.longValue()) {
                    LOGGER.error("{} cannot be converted to an integer without losing information", (Object)num);
                }
                return (T)((IntOr)this.creator.apply(OptionalInt.of(num.intValue())));
            }
            throw new SerializationException(obj + "(" + type + ") is not a integer or '" + this.otherSerializedValue + "'");
        }

        protected Object serialize(T item, Predicate<Class<?>> typeSupported) {
            OptionalInt value = item.value();
            if (value.isPresent()) {
                return value.getAsInt();
            }
            return this.otherSerializedValue;
        }
    }

    public record Disabled(OptionalInt value) implements IntOr
    {
        private static final String DISABLED_VALUE = "disabled";
        public static final Disabled DISABLED = new Disabled(OptionalInt.empty());
        public static final ScalarSerializer<Disabled> SERIALIZER = new Serializer<Disabled>(Disabled.class, Disabled::new, "disabled", DISABLED);

        public boolean test(IntPredicate predicate) {
            return this.value.isPresent() && predicate.test(this.value.getAsInt());
        }

        public boolean enabled() {
            return this.value.isPresent();
        }
    }

    public record Default(OptionalInt value) implements IntOr
    {
        private static final String DEFAULT_VALUE = "default";
        public static final Default USE_DEFAULT = new Default(OptionalInt.empty());
        public static final ScalarSerializer<Default> SERIALIZER = new Serializer<Default>(Default.class, Default::new, "default", USE_DEFAULT);
    }
}

