/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.inventory.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class StackedContentsExtraMap {
    private final AtomicInteger idCounter = new AtomicInteger(BuiltInRegistries.i.b());
    private final Object2IntMap<ItemStack> exactChoiceIds = new Object2IntOpenCustomHashMap(ItemStackLinkedSet.a);
    private final Int2ObjectMap<ItemStack> idToExactChoice = new Int2ObjectOpenHashMap();
    private final AutoRecipeStackManager contents;
    public final Map<RecipeItemStack, IntList> extraStackingIds = new IdentityHashMap<RecipeItemStack, IntList>();

    public StackedContentsExtraMap(AutoRecipeStackManager contents, IRecipe<?> recipe) {
        this.exactChoiceIds.defaultReturnValue(-1);
        this.contents = contents;
        this.initialize(recipe);
    }

    private void initialize(IRecipe<?> recipe) {
        if (recipe.hasExactIngredients()) {
            for (RecipeItemStack ingredient : recipe.a()) {
                if (ingredient.d() || !ingredient.exact) continue;
                ItemStack[] items = ingredient.a();
                IntArrayList idList = new IntArrayList(items.length);
                for (ItemStack item : items) {
                    idList.add(this.registerExact(item));
                    if (item.u()) continue;
                    idList.add(AutoRecipeStackManager.c(item));
                }
                idList.sort(IntComparators.NATURAL_COMPARATOR);
                this.extraStackingIds.put(ingredient, (IntList)idList);
            }
        }
    }

    private int registerExact(ItemStack exactChoice) {
        int existing = this.exactChoiceIds.getInt((Object)exactChoice);
        if (existing > -1) {
            return existing;
        }
        int id = this.idCounter.getAndIncrement();
        this.exactChoiceIds.put((Object)exactChoice, id);
        this.idToExactChoice.put(id, (Object)exactChoice);
        return id;
    }

    public ItemStack getById(int id) {
        return (ItemStack)this.idToExactChoice.get(id);
    }

    public boolean accountStack(ItemStack stack, int count) {
        int id;
        if (!this.exactChoiceIds.isEmpty() && (id = this.exactChoiceIds.getInt((Object)stack)) >= 0) {
            this.contents.b(id, count);
            return true;
        }
        return false;
    }
}

