/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.source;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.provider.source.FileProviderSource;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public class DirectoryProviderSource
extends FileProviderSource {
    public static final DirectoryProviderSource INSTANCE = new DirectoryProviderSource();
    private static final Logger LOGGER = LogUtils.getClassLogger();

    public DirectoryProviderSource() {
        super(arg_0 -> DirectoryProviderSource.lambda$new$0("Directory '%s'", arg_0));
    }

    @Override
    public void registerProviders(EntrypointHandler entrypointHandler, Path context) throws Exception {
        if (!Files.isDirectory(context, new LinkOption[0])) {
            Files.createDirectories(context, new FileAttribute[0]);
        }
        Files.walk(context, 1, FileVisitOption.FOLLOW_LINKS).filter(this::isValidFile).forEach(path -> {
            try {
                super.registerProviders(entrypointHandler, (Path)path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e2) {
                LOGGER.error("Error loading plugin: " + e2.getMessage(), (Throwable)e2);
            }
        });
    }

    public boolean isValidFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && !path.startsWith(".");
    }

    private static /* synthetic */ String lambda$new$0(String rec$, Object xva$0) {
        return "Directory '%s'".formatted(xva$0);
    }
}

