/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import com.destroystokyo.paper.util.maplist.EntityList;
import io.papermc.paper.chunk.system.entity.EntityLookup;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import top.leavesmc.leaves.util.ArrayConstants;

public final class ChunkEntitySlices {
    protected final int minSection;
    protected final int maxSection;
    public final int chunkX;
    public final int chunkZ;
    protected final WorldServer world;
    protected final EntityCollectionBySection allEntities;
    protected final EntityCollectionBySection hardCollidingEntities;
    protected final Reference2ObjectOpenHashMap<Class<? extends net.minecraft.world.entity.Entity>, EntityCollectionBySection> entitiesByClass;
    protected final EntityList entities = new EntityList();
    public FullChunkStatus status;
    protected boolean isTransient;
    private boolean preventStatusUpdates;

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public ChunkEntitySlices(WorldServer world, int chunkX, int chunkZ, FullChunkStatus status, int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.allEntities = new EntityCollectionBySection(this);
        this.hardCollidingEntities = new EntityCollectionBySection(this);
        this.entitiesByClass = new Reference2ObjectOpenHashMap();
        this.status = status;
    }

    public Entity[] getChunkEntities() {
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        net.minecraft.world.entity.Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i2 = 0; i2 < size; ++i2) {
            CraftEntity bukkit;
            net.minecraft.world.entity.Entity entity = entities[i2];
            if (entity == null || (bukkit = entity.getBukkitEntity()) == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(ArrayConstants.emptyBukkitEntityArray);
    }

    public NBTTagCompound save() {
        int len = this.entities.size();
        if (len == 0) {
            return null;
        }
        net.minecraft.world.entity.Entity[] rawData = this.entities.getRawData();
        ArrayList<net.minecraft.world.entity.Entity> collectedEntities = new ArrayList<net.minecraft.world.entity.Entity>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = rawData[i2];
            if (!entity.dG()) continue;
            collectedEntities.add(entity);
        }
        if (collectedEntities.isEmpty()) {
            return null;
        }
        return EntityStorage.saveEntityChunk(collectedEntities, new ChunkCoordIntPair(this.chunkX, this.chunkZ), this.world);
    }

    public boolean unload() {
        int len = this.entities.size();
        net.minecraft.world.entity.Entity[] collectedEntities = Arrays.copyOf(this.entities.getRawData(), len);
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = collectedEntities[i2];
            if (entity.dD() || !entity.dG()) continue;
            entity.b(Entity.RemovalReason.c);
            if (!entity.bN()) continue;
            for (net.minecraft.world.entity.Entity passenger : entity.cR()) {
                passenger.b(Entity.RemovalReason.c);
            }
        }
        return this.entities.size() != 0;
    }

    private List<net.minecraft.world.entity.Entity> getAllEntities() {
        int len = this.entities.size();
        if (len == 0) {
            return new ArrayList<net.minecraft.world.entity.Entity>();
        }
        net.minecraft.world.entity.Entity[] rawData = this.entities.getRawData();
        ArrayList<net.minecraft.world.entity.Entity> collectedEntities = new ArrayList<net.minecraft.world.entity.Entity>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            collectedEntities.add(rawData[i2]);
        }
        return collectedEntities;
    }

    public void callEntitiesLoadEvent() {
        CraftEventFactory.callEntitiesLoadEvent(this.world, new ChunkCoordIntPair(this.chunkX, this.chunkZ), this.getAllEntities());
    }

    public void callEntitiesUnloadEvent() {
        CraftEventFactory.callEntitiesUnloadEvent(this.world, new ChunkCoordIntPair(this.chunkX, this.chunkZ), this.getAllEntities());
    }

    public boolean isEmpty() {
        return this.entities.size() == 0;
    }

    public void mergeInto(ChunkEntitySlices slices) {
        net.minecraft.world.entity.Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i2 = 0; i2 < size; ++i2) {
            net.minecraft.world.entity.Entity entity = entities[i2];
            slices.addEntity(entity, entity.sectionY);
        }
    }

    public boolean startPreventingStatusUpdates() {
        boolean ret = this.preventStatusUpdates;
        this.preventStatusUpdates = true;
        return ret;
    }

    public boolean isPreventingStatusUpdates() {
        return this.preventStatusUpdates;
    }

    public void stopPreventingStatusUpdates(boolean prev) {
        this.preventStatusUpdates = prev;
    }

    public void updateStatus(FullChunkStatus status, EntityLookup lookup) {
        this.status = status;
        net.minecraft.world.entity.Entity[] entities = this.entities.getRawData();
        int size = this.entities.size();
        for (int i2 = 0; i2 < size; ++i2) {
            net.minecraft.world.entity.Entity entity = entities[i2];
            Visibility oldVisibility = EntityLookup.getEntityStatus(entity);
            entity.chunkStatus = status;
            Visibility newVisibility = EntityLookup.getEntityStatus(entity);
            lookup.entityStatusChange(entity, this, oldVisibility, newVisibility, false, false, false);
        }
    }

    public boolean addEntity(net.minecraft.world.entity.Entity entity, int chunkSection) {
        if (!this.entities.add(entity)) {
            return false;
        }
        entity.chunkStatus = this.status;
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.addEntity(entity, sectionIndex);
        if (entity.hardCollides()) {
            this.hardCollidingEntities.addEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).addEntity(entity, sectionIndex);
        }
        return true;
    }

    public boolean removeEntity(net.minecraft.world.entity.Entity entity, int chunkSection) {
        if (!this.entities.remove(entity)) {
            return false;
        }
        entity.chunkStatus = null;
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.removeEntity(entity, sectionIndex);
        if (entity.hardCollides()) {
            this.hardCollidingEntities.removeEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).removeEntity(entity, sectionIndex);
        }
        return true;
    }

    public void getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.hardCollidingEntities.getEntities(except, box, into, predicate);
    }

    public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.allEntities.getEntitiesWithEnderDragonParts(except, box, into, predicate);
    }

    public void getEntitiesWithoutDragonParts(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.allEntities.getEntities(except, box, into, predicate);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        this.allEntities.getEntities(type, box, into, predicate);
    }

    protected EntityCollectionBySection initClass(Class<? extends net.minecraft.world.entity.Entity> clazz) {
        EntityCollectionBySection ret = new EntityCollectionBySection(this);
        for (int sectionIndex = 0; sectionIndex < this.allEntities.entitiesBySection.length; ++sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> sectionEntities = this.allEntities.entitiesBySection[sectionIndex];
            if (sectionEntities == null) continue;
            E[] storage = sectionEntities.storage;
            int len = Math.min(storage.length, sectionEntities.size());
            for (int i2 = 0; i2 < len; ++i2) {
                Object entity = storage[i2];
                if (!clazz.isInstance(entity)) continue;
                ret.addEntity((net.minecraft.world.entity.Entity)entity, sectionIndex);
            }
        }
        return ret;
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(Class<? extends T> clazz, net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            collection.getEntitiesWithEnderDragonParts(except, clazz, box, into, predicate);
        } else {
            collection = this.initClass(clazz);
            this.entitiesByClass.putIfAbsent(clazz, (Object)collection);
            collection.getEntitiesWithEnderDragonParts(except, clazz, box, into, predicate);
        }
    }

    protected static final class EntityCollectionBySection {
        protected final ChunkEntitySlices manager;
        protected final long[] nonEmptyBitset;
        protected final BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection;
        protected int count;

        public EntityCollectionBySection(ChunkEntitySlices manager) {
            this.manager = manager;
            int sectionCount = manager.maxSection - manager.minSection + 1;
            this.nonEmptyBitset = new long[sectionCount + 63 >>> 6];
            this.entitiesBySection = new BasicEntityList[sectionCount];
        }

        public void addEntity(net.minecraft.world.entity.Entity entity, int sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> list = this.entitiesBySection[sectionIndex];
            if (list != null && list.has(entity)) {
                return;
            }
            if (list == null) {
                this.entitiesBySection[sectionIndex] = list = new BasicEntityList();
                int n2 = sectionIndex >>> 6;
                this.nonEmptyBitset[n2] = this.nonEmptyBitset[n2] | 1L << (sectionIndex & 0x3F);
            }
            list.add(entity);
            ++this.count;
        }

        public void removeEntity(net.minecraft.world.entity.Entity entity, int sectionIndex) {
            BasicEntityList<net.minecraft.world.entity.Entity> list = this.entitiesBySection[sectionIndex];
            if (list == null || !list.remove(entity)) {
                return;
            }
            --this.count;
            if (list.isEmpty()) {
                this.entitiesBySection[sectionIndex] = null;
                int n2 = sectionIndex >>> 6;
                this.nonEmptyBitset[n2] = this.nonEmptyBitset[n2] ^ 1L << (sectionIndex & 0x3F);
            }
        }

        public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cE().c(box) || predicate != null && !predicate.test((net.minecraft.world.entity.Entity)entity)) continue;
                    into.add((net.minecraft.world.entity.Entity)entity);
                }
            }
        }

        public void getEntitiesWithEnderDragonParts(net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cE().c(box)) continue;
                    if (predicate == null || predicate.test((net.minecraft.world.entity.Entity)entity)) {
                        into.add((net.minecraft.world.entity.Entity)entity);
                    }
                    if (!(entity instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart part : ((EntityEnderDragon)entity).cf) {
                        if (part == except || !part.cE().c(box) || predicate != null && !predicate.test(part)) continue;
                        into.add(part);
                    }
                }
            }
        }

        public void getEntitiesWithEnderDragonParts(net.minecraft.world.entity.Entity except, Class<?> clazz, AxisAlignedBB box, List<net.minecraft.world.entity.Entity> into, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || entity == except || !((net.minecraft.world.entity.Entity)entity).cE().c(box)) continue;
                    if (predicate == null || predicate.test((net.minecraft.world.entity.Entity)entity)) {
                        into.add((net.minecraft.world.entity.Entity)entity);
                    }
                    if (!(entity instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart part : ((EntityEnderDragon)entity).cf) {
                        if (part == except || !part.cE().c(box) || !clazz.isInstance(part) || predicate != null && !predicate.test(part)) continue;
                        into.add(part);
                    }
                }
            }
        }

        public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.manager.minSection;
            int maxSection = this.manager.maxSection;
            int min = MathHelper.a(MathHelper.a(box.b - 2.0) >> 4, minSection, maxSection);
            int max = MathHelper.a(MathHelper.a(box.e + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<net.minecraft.world.entity.Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<net.minecraft.world.entity.Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i2 = 0; i2 < len; ++i2) {
                    Object entity = storage[i2];
                    if (entity == null || type != null && ((net.minecraft.world.entity.Entity)entity).ae() != type || !((net.minecraft.world.entity.Entity)entity).cE().c(box) || predicate != null && !predicate.test(entity)) continue;
                    into.add(entity);
                }
            }
        }
    }

    protected static final class BasicEntityList<E extends net.minecraft.world.entity.Entity> {
        protected static final int DEFAULT_CAPACITY = 4;
        protected E[] storage;
        protected int size;

        public BasicEntityList() {
            this(0);
        }

        public BasicEntityList(int cap) {
            this.storage = cap <= 0 ? ArrayConstants.emptyEntityArray : new net.minecraft.world.entity.Entity[cap];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        private void resize() {
            this.storage = this.storage == ArrayConstants.emptyEntityArray ? new net.minecraft.world.entity.Entity[4] : (net.minecraft.world.entity.Entity[])Arrays.copyOf(this.storage, this.storage.length * 2);
        }

        public void add(E entity) {
            int idx;
            if ((idx = this.size++) >= this.storage.length) {
                this.resize();
                this.storage[idx] = entity;
            } else {
                this.storage[idx] = entity;
            }
        }

        public int indexOf(E entity) {
            E[] storage = this.storage;
            int len = Math.min(this.storage.length, this.size);
            for (int i2 = 0; i2 < len; ++i2) {
                if (storage[i2] != entity) continue;
                return i2;
            }
            return -1;
        }

        public boolean remove(E entity) {
            int idx = this.indexOf(entity);
            if (idx == -1) {
                return false;
            }
            int size = --this.size;
            E[] storage = this.storage;
            if (idx != size) {
                System.arraycopy(storage, idx + 1, storage, idx, size - idx);
            }
            storage[size] = null;
            return true;
        }

        public boolean has(E entity) {
            return this.indexOf(entity) != -1;
        }
    }
}

