/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Ticker;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import io.papermc.paper.util.ServerWorkerThread;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.slf4j.Logger;

public class SystemUtils {
    static final Logger e = LogUtils.getLogger();
    private static final int f = 255;
    private static final String g = "max.bg.threads";
    private static final AtomicInteger h = new AtomicInteger(1);
    private static final ExecutorService i = SystemUtils.makeExecutor("Main", -1);
    public static final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable run) {
            Thread ret = new Thread(run);
            ret.setName("Profile Lookup Executor #" + this.count.getAndIncrement());
            ret.setUncaughtExceptionHandler((thread, throwable) -> e.error("Uncaught exception in thread " + thread.getName(), throwable));
            return ret;
        }
    });
    private static final ExecutorService j = SystemUtils.n();
    private static final DateTimeFormatter k = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static TimeSource.a a = System::nanoTime;
    public static final Ticker b = new Ticker(){

        public long read() {
            return a.getAsLong();
        }
    };
    public static final UUID c = new UUID(0L, 0L);
    public static final FileSystemProvider d = FileSystemProvider.installedProviders().stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    public static final double COLLISION_EPSILON = 1.0E-7;
    private static Consumer<String> l = message -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String a(IBlockState<T> property, Object value) {
        return property.a((Comparable)value);
    }

    public static String a(String type, @Nullable MinecraftKey id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.b() + "." + id.a().replace('/', '.');
    }

    public static long b() {
        return SystemUtils.c() / 1000000L;
    }

    public static long c() {
        return System.nanoTime();
    }

    public static long d() {
        return Instant.now().toEpochMilli();
    }

    public static String e() {
        return k.format(ZonedDateTime.now());
    }

    private static ExecutorService makeExecutor(String s2, int priorityModifier) {
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        int i2 = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : (cpus <= 8 ? Math.max(3, cpus - 2) : cpus * 2 / 3);
        i2 = Math.min(8, i2);
        i2 = Integer.getInteger("Paper.WorkerThreadCount", i2);
        Object executorService = i2 <= 0 ? MoreExecutors.newDirectExecutorService() : new ThreadPoolExecutor(i2, i2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), target -> new ServerWorkerThread(target, s2, priorityModifier));
        return executorService;
    }

    private static int m() {
        String string = System.getProperty(g);
        if (string != null) {
            try {
                int i2 = Integer.parseInt(string);
                if (i2 >= 1 && i2 <= 255) {
                    return i2;
                }
                e.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{g, string, 255});
            }
            catch (NumberFormatException var2) {
                e.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{g, string, 255});
            }
        }
        return 255;
    }

    public static ExecutorService f() {
        return i;
    }

    public static ExecutorService g() {
        return j;
    }

    public static void h() {
        SystemUtils.a(i);
        SystemUtils.a(j);
    }

    private static void a(ExecutorService service) {
        boolean bl;
        service.shutdown();
        try {
            bl = service.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            bl = false;
        }
        if (!bl) {
            service.shutdownNow();
        }
    }

    private static ExecutorService n() {
        return Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("IO-Worker-" + h.getAndIncrement());
            thread.setUncaughtExceptionHandler(SystemUtils::a);
            return thread;
        });
    }

    public static void a(Throwable t2) {
        throw t2 instanceof RuntimeException ? (RuntimeException)t2 : new RuntimeException(t2);
    }

    public static void a(Thread thread, Throwable t2) {
        SystemUtils.b(t2);
        if (t2 instanceof CompletionException) {
            t2 = t2.getCause();
        }
        if (t2 instanceof ReportedException) {
            DispenserRegistry.a(((ReportedException)t2).a().e());
            System.exit(-1);
        }
        e.error(String.format(Locale.ROOT, "Caught exception in thread %s", thread), t2);
    }

    @Nullable
    public static Type<?> a(DSL.TypeReference typeReference, String id) {
        return !SharedConstants.aR ? null : SystemUtils.b(typeReference, id);
    }

    @Nullable
    private static Type<?> b(DSL.TypeReference typeReference, String id) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataConverterRegistry.a().getSchema(DataFixUtils.makeKey((int)SharedConstants.b().d().c())).getChoiceType(typeReference, id);
            }
            catch (IllegalArgumentException var4) {
                e.error("No data fixer registered for {}", (Object)id);
                if (!SharedConstants.aS) break block2;
                throw var4;
            }
        }
        return type;
    }

    public static Runnable a(String activeThreadName, Runnable task) {
        return SharedConstants.aS ? () -> {
            Thread thread = Thread.currentThread();
            String string2 = thread.getName();
            thread.setName(activeThreadName);
            try {
                task.run();
            }
            finally {
                thread.setName(string2);
            }
        } : task;
    }

    public static <V> Supplier<V> a(String activeThreadName, Supplier<V> supplier) {
        return SharedConstants.aS ? () -> {
            Object var4;
            Thread thread = Thread.currentThread();
            String string2 = thread.getName();
            thread.setName(activeThreadName);
            try {
                var4 = supplier.get();
            }
            finally {
                thread.setName(string2);
            }
            return var4;
        } : supplier;
    }

    public static OS i() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.c;
        }
        if (string.contains("mac")) {
            return OS.d;
        }
        if (string.contains("solaris")) {
            return OS.b;
        }
        if (string.contains("sunos")) {
            return OS.b;
        }
        if (string.contains("linux")) {
            return OS.a;
        }
        return string.contains("unix") ? OS.a : OS.e;
    }

    public static Stream<String> j() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(runtimeArg -> runtimeArg.startsWith("-X"));
    }

    public static <T> T a(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T a(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = iterator.next();
        if (object != null) {
            T object3 = object2;
            while (object3 != object) {
                if (!iterator.hasNext()) continue;
                object3 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return object2;
    }

    public static <T> T b(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = null;
        while (iterator.hasNext()) {
            T object3 = iterator.next();
            if (object3 == object) {
                if (object2 != null) break;
                object2 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : object);
                break;
            }
            object2 = object3;
        }
        return object2;
    }

    public static <T> T a(Supplier<T> factory) {
        return factory.get();
    }

    public static <T> T a(T object, Consumer<T> initializer) {
        initializer.accept(object);
        return object;
    }

    public static <K> Hash.Strategy<K> k() {
        return IdentityHashingStrategy.a;
    }

    public static <V> CompletableFuture<List<V>> b(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(void_ -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> c(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(futures, completableFuture::completeExceptionally).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    public static <V> CompletableFuture<List<V>> d(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(futures, (Throwable throwable) -> {
            if (completableFuture.completeExceptionally((Throwable)throwable)) {
                for (CompletableFuture completableFuture2 : futures) {
                    completableFuture2.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    private static <V> CompletableFuture<List<V>> a(List<? extends CompletableFuture<? extends V>> futures, Consumer<Throwable> exceptionHandler) {
        ArrayList list = Lists.newArrayListWithCapacity((int)futures.size());
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        futures.forEach(future -> {
            int i2 = list.size();
            list.add(null);
            completableFutures[i2] = future.whenComplete((value, throwable) -> {
                if (throwable != null) {
                    exceptionHandler.accept((Throwable)throwable);
                } else {
                    list.set(i2, value);
                }
            });
        });
        return CompletableFuture.allOf(completableFutures).thenApply(void_ -> list);
    }

    public static <T> Optional<T> a(Optional<T> optional, Consumer<T> presentAction, Runnable elseAction) {
        if (optional.isPresent()) {
            presentAction.accept(optional.get());
        } else {
            elseAction.run();
        }
        return optional;
    }

    public static <T> Supplier<T> a(Supplier<T> supplier, Supplier<String> messageSupplier) {
        return supplier;
    }

    public static Runnable a(Runnable runnable, Supplier<String> messageSupplier) {
        return runnable;
    }

    public static void a(String message) {
        e.error(message);
        if (SharedConstants.aS) {
            SystemUtils.d(message);
        }
    }

    public static void a(String message, Throwable throwable) {
        e.error(message, throwable);
        if (SharedConstants.aS) {
            SystemUtils.d(message);
        }
    }

    public static <T extends Throwable> T b(T t2) {
        if (SharedConstants.aS) {
            e.error("Trying to throw a fatal exception, pausing in IDE", t2);
            SystemUtils.d(t2.getMessage());
        }
        return t2;
    }

    public static void a(Consumer<String> missingBreakpointHandler) {
        l = missingBreakpointHandler;
    }

    private static void d(String message) {
        boolean bl;
        Instant instant = Instant.now();
        e.warn("Did you remember to set a breakpoint here?");
        boolean bl2 = bl = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!bl) {
            l.accept(message);
        }
    }

    public static String c(Throwable t2) {
        if (t2.getCause() != null) {
            return SystemUtils.c(t2.getCause());
        }
        return t2.getMessage() != null ? t2.getMessage() : t2.toString();
    }

    public static <T> T a(T[] array, RandomSource random) {
        return array[random.a(array.length)];
    }

    public static int a(int[] array, RandomSource random) {
        return array[random.a(array.length)];
    }

    public static <T> T a(List<T> list, RandomSource random) {
        return list.get(random.a(list.size()));
    }

    public static <T> Optional<T> b(List<T> list, RandomSource random) {
        return list.isEmpty() ? Optional.empty() : Optional.of(SystemUtils.a(list, random));
    }

    private static BooleanSupplier a(Path src, Path dest) {
        return new BooleanSupplier(){
            final /* synthetic */ Path val$src;
            final /* synthetic */ Path val$dest;
            {
                this.val$src = path;
                this.val$dest = path2;
            }

            public boolean getAsBoolean() {
                try {
                    Files.move(this.val$src, this.val$dest, new CopyOption[0]);
                    return true;
                }
                catch (IOException var2) {
                    SystemUtils.e.error("Failed to rename", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "rename " + this.val$src + " to " + this.val$dest;
            }
        };
    }

    private static BooleanSupplier a(Path path) {
        return new BooleanSupplier(path){
            final /* synthetic */ Path val$path;
            {
                this.val$path = path;
            }

            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(this.val$path);
                    return true;
                }
                catch (IOException var2) {
                    SystemUtils.e.warn("Failed to delete", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + this.val$path;
            }
        };
    }

    private static BooleanSupplier b(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + path + " is deleted";
            }
        };
    }

    private static BooleanSupplier c(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + path + " is present";
            }
        };
    }

    private static boolean a(BooleanSupplier ... tasks) {
        for (BooleanSupplier booleanSupplier : tasks) {
            if (booleanSupplier.getAsBoolean()) continue;
            e.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean a(int retries, String taskName, BooleanSupplier ... tasks) {
        for (int i2 = 0; i2 < retries; ++i2) {
            if (SystemUtils.a(tasks)) {
                return true;
            }
            e.error("Failed to {}, retrying {}/{}", new Object[]{taskName, i2, retries});
        }
        e.error("Failed to {}, aborting, progress might be lost", (Object)taskName);
        return false;
    }

    public static void a(File current, File newFile, File backup) {
        SystemUtils.a(current.toPath(), newFile.toPath(), backup.toPath());
    }

    public static void a(Path current, Path newPath, Path backup) {
        SystemUtils.a(current, newPath, backup, false);
    }

    public static void a(File current, File newPath, File backup, boolean noRestoreOnFail) {
        SystemUtils.a(current.toPath(), newPath.toPath(), backup.toPath(), noRestoreOnFail);
    }

    public static void a(Path current, Path newPath, Path backup, boolean noRestoreOnFail) {
        int i2 = 10;
        if (!(Files.exists(current, new LinkOption[0]) && !SystemUtils.a(10, "create backup " + backup, SystemUtils.a(backup), SystemUtils.a(current, backup), SystemUtils.c(backup)) || !SystemUtils.a(10, "remove old " + current, SystemUtils.a(current), SystemUtils.b(current)) || SystemUtils.a(10, "replace " + current + " with " + newPath, SystemUtils.a(newPath, current), SystemUtils.c(current)) || noRestoreOnFail)) {
            SystemUtils.a(10, "restore " + current + " from " + backup, SystemUtils.a(backup, current), SystemUtils.c(current));
        }
    }

    public static int a(String string, int cursor, int delta) {
        int i2 = string.length();
        if (delta >= 0) {
            for (int j2 = 0; cursor < i2 && j2 < delta; ++j2) {
                if (!Character.isHighSurrogate(string.charAt(cursor++)) || cursor >= i2 || !Character.isLowSurrogate(string.charAt(cursor))) continue;
                ++cursor;
            }
        } else {
            for (int k2 = delta; cursor > 0 && k2 < 0; ++k2) {
                if (!Character.isLowSurrogate(string.charAt(--cursor)) || cursor <= 0 || !Character.isHighSurrogate(string.charAt(cursor - 1))) continue;
                --cursor;
            }
        }
        return cursor;
    }

    public static Consumer<String> a(String prefix, Consumer<String> consumer) {
        return string -> consumer.accept(prefix + string);
    }

    public static DataResult<int[]> a(IntStream stream, int length) {
        int[] is = stream.limit(length + 1).toArray();
        if (is.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " ints";
            return is.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(is, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)is);
    }

    public static DataResult<long[]> a(LongStream stream, int length) {
        long[] ls = stream.limit(length + 1).toArray();
        if (ls.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " longs";
            return ls.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(ls, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)ls);
    }

    public static <T> DataResult<List<T>> a(List<T> list, int length) {
        if (list.size() != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " elements";
            return list.size() >= length ? DataResult.error(supplier, list.subList(0, length)) : DataResult.error(supplier);
        }
        return DataResult.success(list);
    }

    public static void l() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var2) {
                    e.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(e));
        thread.start();
    }

    public static void b(Path src, Path dest, Path toCopy) throws IOException {
        Path path = src.relativize(toCopy);
        Path path2 = dest.resolve(path);
        Files.copy(toCopy, path2, new CopyOption[0]);
    }

    public static String a(String string, CharPredicate predicate) {
        return string.toLowerCase(Locale.ROOT).chars().mapToObj(charCode -> predicate.test((char)charCode) ? Character.toString((char)charCode) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> a(Function<K, V> mapper) {
        return new SingleKeyCache<K, V>(mapper);
    }

    public static <T, R> Function<T, R> b(final Function<T, R> function) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object) {
                return this.cache.computeIfAbsent(object, function);
            }

            public String toString() {
                return "memoize/1[function=" + function + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> a(final BiFunction<T, U, R> biFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object, U object2) {
                return this.cache.computeIfAbsent(Pair.of(object, object2), pair -> biFunction.apply(pair.getFirst(), pair.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + biFunction + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> a(Stream<T> stream, RandomSource random) {
        ObjectArrayList objectArrayList = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        SystemUtils.b(objectArrayList, random);
        return objectArrayList;
    }

    public static IntArrayList a(IntStream stream, RandomSource random) {
        int i2;
        IntArrayList intArrayList = IntArrayList.wrap((int[])stream.toArray());
        for (int j2 = i2 = intArrayList.size(); j2 > 1; --j2) {
            int k2 = random.a(j2);
            intArrayList.set(j2 - 1, intArrayList.set(k2, intArrayList.getInt(j2 - 1)));
        }
        return intArrayList;
    }

    public static <T> List<T> b(T[] array, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList((Object[])array);
        SystemUtils.b(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> List<T> a(ObjectArrayList<T> list, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList(list);
        SystemUtils.b(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> void b(ObjectArrayList<T> list, RandomSource random) {
        int i2;
        for (int j2 = i2 = list.size(); j2 > 1; --j2) {
            int k2 = random.a(j2);
            list.set(j2 - 1, list.set(k2, list.get(j2 - 1)));
        }
    }

    public static <T> CompletableFuture<T> c(Function<Executor, CompletableFuture<T>> resultFactory) {
        return SystemUtils.a(resultFactory, CompletableFuture::isDone);
    }

    public static <T> T a(Function<Executor, T> resultFactory, Predicate<T> donePredicate) {
        int i2;
        LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        T object = resultFactory.apply(blockingQueue::add);
        while (!donePredicate.test(object)) {
            try {
                Runnable runnable = (Runnable)blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException var5) {
                e.warn("Interrupted wait");
                break;
            }
        }
        if ((i2 = blockingQueue.size()) > 0) {
            e.warn("Tasks left in queue: {}", (Object)i2);
        }
        return object;
    }

    public static <T> ToIntFunction<T> e(List<T> values) {
        return SystemUtils.a(values, Object2IntOpenHashMap::new);
    }

    public static <T> ToIntFunction<T> a(List<T> values, IntFunction<Object2IntMap<T>> mapCreator) {
        Object2IntMap<T> object2IntMap = mapCreator.apply(values.size());
        for (int i2 = 0; i2 < values.size(); ++i2) {
            object2IntMap.put(values.get(i2), i2);
        }
        return object2IntMap;
    }

    public static <T, E extends Exception> T a(DataResult<T> result, Function<String, E> exceptionGetter) throws E {
        Optional optional = result.error();
        if (optional.isPresent()) {
            throw (Exception)exceptionGetter.apply(((DataResult.PartialResult)optional.get()).message());
        }
        return result.result().orElseThrow();
    }

    public static boolean a(int c2) {
        return Character.isWhitespace(c2) || Character.isSpaceChar(c2);
    }

    public static boolean b(@Nullable String string) {
        return string != null && string.length() != 0 ? string.chars().allMatch(SystemUtils::a) : true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class OS
    extends Enum<OS> {
        public static final /* enum */ OS a = new OS("linux");
        public static final /* enum */ OS b = new OS("solaris");
        public static final /* enum */ OS c = new OS("windows"){

            @Override
            protected String[] b(URL url) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            }
        };
        public static final /* enum */ OS d = new OS("mac"){

            @Override
            protected String[] b(URL url) {
                return new String[]{"open", url.toString()};
            }
        };
        public static final /* enum */ OS e = new OS("unknown");
        private final String f;
        private static final /* synthetic */ OS[] g;

        public static OS[] values() {
            return (OS[])g.clone();
        }

        public static OS valueOf(String name) {
            return Enum.valueOf(OS.class, name);
        }

        private OS(String name) {
            this.f = name;
        }

        public void a(URL url) {
            throw new IllegalStateException("This method is not useful on dedicated servers.");
        }

        public void a(URI uri) {
            try {
                this.a(uri.toURL());
            }
            catch (MalformedURLException var3) {
                e.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public void a(File file) {
            try {
                this.a(file.toURI().toURL());
            }
            catch (MalformedURLException var3) {
                e.error("Couldn't open file '{}'", (Object)file, (Object)var3);
            }
        }

        protected String[] b(URL url) {
            String string = url.toString();
            if ("file".equals(url.getProtocol())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void a(String uri) {
            try {
                this.a(new URI(uri).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException var3) {
                e.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public String a() {
            return this.f;
        }

        private static /* synthetic */ OS[] b() {
            return new OS[]{a, b, c, d, e};
        }

        static {
            g = OS.b();
        }
    }

    static final class IdentityHashingStrategy
    extends Enum<IdentityHashingStrategy>
    implements Hash.Strategy<Object> {
        public static final /* enum */ IdentityHashingStrategy a = new IdentityHashingStrategy();
        private static final /* synthetic */ IdentityHashingStrategy[] b;

        public static IdentityHashingStrategy[] values() {
            return (IdentityHashingStrategy[])b.clone();
        }

        public static IdentityHashingStrategy valueOf(String name) {
            return Enum.valueOf(IdentityHashingStrategy.class, name);
        }

        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }

        private static /* synthetic */ IdentityHashingStrategy[] a() {
            return new IdentityHashingStrategy[]{a};
        }

        static {
            b = IdentityHashingStrategy.a();
        }
    }
}

