/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ArgumentParserItemStack {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.item.tag.disallowed"));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> IChatBaseComponent.a("argument.item.id.invalid", id));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(tag -> IChatBaseComponent.a("arguments.item.tag.unknown", tag));
    private static final char d = '{';
    private static final char e = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> f = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Item> g;
    private final StringReader h;
    private final boolean i;
    private Either<Holder<Item>, HolderSet<Item>> j;
    @Nullable
    private NBTTagCompound k;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> l = f;

    private ArgumentParserItemStack(HolderLookup<Item> registryWrapper, StringReader reader, boolean allowTag) {
        this.g = registryWrapper;
        this.h = reader;
        this.i = allowTag;
    }

    public static a a(HolderLookup<Item> registryWrapper, StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        try {
            ArgumentParserItemStack itemParser = new ArgumentParserItemStack(registryWrapper, reader, false);
            itemParser.d();
            Holder<Item> holder = itemParser.j.left().orElseThrow(() -> new IllegalStateException("Parser returned unexpected tag name"));
            return new a(holder, itemParser.k);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            reader.setCursor(i2);
            throw commandSyntaxException;
        }
    }

    public static Either<a, b> b(HolderLookup<Item> registryWrapper, StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        try {
            ArgumentParserItemStack itemParser = new ArgumentParserItemStack(registryWrapper, reader, true);
            itemParser.d();
            return itemParser.j.mapBoth(item -> new a((Holder<Item>)item, itemParser.k), tag -> new b((HolderSet<Item>)tag, itemParser.k));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            reader.setCursor(i2);
            throw commandSyntaxException;
        }
    }

    public static CompletableFuture<Suggestions> a(HolderLookup<Item> registryWrapper, SuggestionsBuilder builder, boolean allowTag) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ArgumentParserItemStack itemParser = new ArgumentParserItemStack(registryWrapper, stringReader, allowTag);
        try {
            itemParser.d();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return itemParser.l.apply(builder.createOffset(stringReader.getCursor()));
    }

    private void a() throws CommandSyntaxException {
        int i2 = this.h.getCursor();
        MinecraftKey resourceLocation = MinecraftKey.a(this.h);
        Optional<Holder.c<Item>> optional = this.g.a(ResourceKey.a(Registries.D, resourceLocation));
        this.j = Either.left((Holder)optional.orElseThrow(() -> {
            this.h.setCursor(i2);
            return b.createWithContext((ImmutableStringReader)this.h, (Object)resourceLocation);
        }));
    }

    private void b() throws CommandSyntaxException {
        if (!this.i) {
            throw a.createWithContext((ImmutableStringReader)this.h);
        }
        int i2 = this.h.getCursor();
        this.h.expect('#');
        this.l = this::b;
        MinecraftKey resourceLocation = MinecraftKey.a(this.h);
        Optional<HolderSet.Named<Item>> optional = this.g.a(TagKey.a(Registries.D, resourceLocation));
        this.j = Either.right((HolderSet)optional.orElseThrow(() -> {
            this.h.setCursor(i2);
            return c.createWithContext((ImmutableStringReader)this.h, (Object)resourceLocation);
        }));
    }

    private void c() throws CommandSyntaxException {
        this.k = new MojangsonParser(this.h).f();
    }

    private void d() throws CommandSyntaxException {
        this.l = this.i ? this::d : this::c;
        if (this.h.canRead() && this.h.peek() == '#') {
            this.b();
        } else {
            this.a();
        }
        this.l = this::a;
        if (this.h.canRead() && this.h.peek() == '{') {
            this.l = f;
            this.c();
        }
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.g.e().map(TagKey::b), builder, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.g.c().map(ResourceKey::a), builder);
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder) {
        this.b(builder);
        return this.c(builder);
    }

    public record a(Holder<Item> a, @Nullable NBTTagCompound b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "item;nbt", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "item;nbt", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "item;nbt", "a", "b"}, this, object);
        }
    }

    public record b(HolderSet<Item> a, @Nullable NBTTagCompound b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "tag;nbt", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "tag;nbt", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "tag;nbt", "a", "b"}, this, object);
        }
    }
}

