/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.projectiles.CraftBlockProjectileSource;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface IDispenseBehavior {
    public static final Logger a = LogUtils.getLogger();
    public static final IDispenseBehavior b = (isourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(ISourceBlock var1, net.minecraft.world.item.ItemStack var2);

    public static void c() {
        BlockDispenser.a(Items.nH, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c());
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.uw, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c());
                entitytippedarrow.a(stack);
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.uv, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntitySpectralArrow entityspectralarrow = new EntitySpectralArrow(world, position.a(), position.b(), position.c());
                entityspectralarrow.d = EntityArrow.PickupStatus.b;
                return entityspectralarrow;
            }
        });
        BlockDispenser.a(Items.qd, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityEgg(world, position.a(), position.b(), position.c()), entityegg -> entityegg.a(stack));
            }
        });
        BlockDispenser.a(Items.pO, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntitySnowball(world, position.a(), position.b(), position.c()), entitysnowball -> entitysnowball.a(stack));
            }
        });
        BlockDispenser.a(Items.te, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityThrownExpBottle(world, position.a(), position.b(), position.c()), entitythrownexpbottle -> entitythrownexpbottle.a(stack));
            }

            @Override
            protected float a() {
                return super.a() * 0.5f;
            }

            @Override
            protected float b() {
                return super.b() * 1.25f;
            }
        });
        BlockDispenser.a(Items.uu, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        BlockDispenser.a(Items.ux, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        DispenseBehaviorItem dispensebehavioritem = new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                EntityTypes<?> entitytypes = ((ItemMonsterEgg)stack.d()).a(stack.v());
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                try {
                    entitytypes.a(pointer.g(), stack, (EntityHuman)null, pointer.d().a(enumdirection), EnumMobSpawn.o, enumdirection != EnumDirection.b, false);
                }
                catch (Exception exception) {
                    a.error("Error while dispensing spawn egg from dispenser at {}", (Object)pointer.d(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.b;
                }
                if (shrink) {
                    stack.h(1);
                }
                pointer.g().a((Entity)null, GameEvent.t, pointer.d());
                return stack;
            }
        };
        for (ItemMonsterEgg itemmonsteregg : ItemMonsterEgg.h()) {
            BlockDispenser.a(itemmonsteregg, dispensebehavioritem);
        }
        BlockDispenser.a(Items.tL, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                Consumer<EntityArmorStand> consumer = EntityTypes.a(entityarmorstand -> entityarmorstand.a_(enumdirection.p()), worldserver, stack, (EntityHuman)null);
                EntityArmorStand entityarmorstand2 = EntityTypes.d.a(worldserver, stack.v(), consumer, blockposition, EnumMobSpawn.o, false, false);
                if (entityarmorstand2 != null && shrink) {
                    stack.h(1);
                }
                return stack;
            }
        });
        BlockDispenser.a(Items.mZ, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityLiving> list = pointer.g().a(EntityLiving.class, new AxisAlignedBB(blockposition), entityliving -> {
                    if (!(entityliving instanceof ISaddleable)) {
                        return false;
                    }
                    ISaddleable isaddleable = (ISaddleable)((Object)entityliving);
                    return !isaddleable.i() && isaddleable.g();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                    WorldServer world = pointer.g();
                    org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)list.get(0).getBukkitEntity()));
                    if (!BlockDispenser.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    boolean shrink = true;
                    if (!event.getItem().equals((Object)craftItem)) {
                        shrink = false;
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                        if (idispensebehavior != b && idispensebehavior != ItemArmor.a) {
                            idispensebehavior.dispense(pointer, eventStack);
                            return stack;
                        }
                    }
                    ((ISaddleable)((Object)list.get(0))).equipSaddle(SoundCategory.e, CraftItemStack.asNMSCopy(event.getItem()));
                    if (shrink) {
                        stack.h(1);
                    }
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EntityHorseAbstract entityhorseabstract2;
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityHorseAbstract> list = pointer.g().a(EntityHorseAbstract.class, new AxisAlignedBB(blockposition), entityhorseabstract -> entityhorseabstract.bs() && entityhorseabstract.gH());
                Iterator<EntityHorseAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorseabstract2 = iterator1.next()).l(stack) || entityhorseabstract2.gI() || !entityhorseabstract2.gn());
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                WorldServer world = pointer.g();
                org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorseabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != ItemArmor.a) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                if (shrink) {
                    stack.h(1);
                }
                entityhorseabstract2.a_(401).a(CraftItemStack.asNMSCopy(event.getItem()));
                this.a(true);
                return stack;
            }
        };
        BlockDispenser.a(Items.tP, dispensebehaviormaybe);
        BlockDispenser.a(Items.tM, dispensebehaviormaybe);
        BlockDispenser.a(Items.tN, dispensebehaviormaybe);
        BlockDispenser.a(Items.tO, dispensebehaviormaybe);
        BlockDispenser.a(Items.hi, dispensebehaviormaybe);
        BlockDispenser.a(Items.hj, dispensebehaviormaybe);
        BlockDispenser.a(Items.hr, dispensebehaviormaybe);
        BlockDispenser.a(Items.ht, dispensebehaviormaybe);
        BlockDispenser.a(Items.hu, dispensebehaviormaybe);
        BlockDispenser.a(Items.hx, dispensebehaviormaybe);
        BlockDispenser.a(Items.hp, dispensebehaviormaybe);
        BlockDispenser.a(Items.hv, dispensebehaviormaybe);
        BlockDispenser.a(Items.hl, dispensebehaviormaybe);
        BlockDispenser.a(Items.hq, dispensebehaviormaybe);
        BlockDispenser.a(Items.hn, dispensebehaviormaybe);
        BlockDispenser.a(Items.hk, dispensebehaviormaybe);
        BlockDispenser.a(Items.ho, dispensebehaviormaybe);
        BlockDispenser.a(Items.hs, dispensebehaviormaybe);
        BlockDispenser.a(Items.hw, dispensebehaviormaybe);
        BlockDispenser.a(Items.hm, dispensebehaviormaybe);
        BlockDispenser.a(Items.er, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EntityHorseChestedAbstract entityhorsechestedabstract2;
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                List<EntityHorseChestedAbstract> list = pointer.g().a(EntityHorseChestedAbstract.class, new AxisAlignedBB(blockposition), entityhorsechestedabstract -> entityhorsechestedabstract.bs() && !entityhorsechestedabstract.r());
                Iterator<EntityHorseChestedAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorsechestedabstract2 = iterator1.next()).gn());
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                WorldServer world = pointer.g();
                org.bukkit.block.Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != ItemArmor.a) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                entityhorsechestedabstract2.a_(499).a(CraftItemStack.asNMSCopy(event.getItem()));
                if (shrink) {
                    stack.h(1);
                }
                this.a(true);
                return stack;
            }
        });
        BlockDispenser.a(Items.tA, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                WorldServer worldserver = pointer.g();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(enumdirection.j(), enumdirection.k(), enumdirection.l()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
                EntityFireworks entityfireworks = new EntityFireworks((net.minecraft.world.level.World)pointer.g(), itemstack1, pointer.a(), pointer.b(), pointer.a(), true);
                entityfireworks.projectileSource = new CraftBlockProjectileSource((TileEntityDispenser)pointer.f());
                IDispenseBehavior.a(pointer, entityfireworks, enumdirection);
                entityfireworks.c(enumdirection.j(), enumdirection.k(), enumdirection.l(), 0.5f, 1.0f);
                pointer.g().b(entityfireworks);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }

            @Override
            protected void a(ISourceBlock pointer) {
                pointer.g().c(1004, pointer.d(), 0);
            }
        });
        BlockDispenser.a(Items.tf, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                IPosition iposition = BlockDispenser.a(pointer);
                double d0 = iposition.a() + (double)((float)enumdirection.j() * 0.3f);
                double d1 = iposition.b() + (double)((float)enumdirection.k() * 0.3f);
                double d2 = iposition.c() + (double)((float)enumdirection.l() * 0.3f);
                WorldServer worldserver = pointer.g();
                RandomSource randomsource = worldserver.z;
                double d3 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d4 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d5 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(d3, d4, d5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntitySmallFireball entitysmallfireball = new EntitySmallFireball(worldserver, d0, d1, d2, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
                entitysmallfireball.a(itemstack1);
                entitysmallfireball.projectileSource = new CraftBlockProjectileSource((TileEntityDispenser)pointer.f());
                worldserver.b(entitysmallfireball);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }

            @Override
            protected void a(ISourceBlock pointer) {
                pointer.g().c(1018, pointer.d(), 0);
            }
        });
        BlockDispenser.a(Items.ni, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.a));
        BlockDispenser.a(Items.nk, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.b));
        BlockDispenser.a(Items.nm, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.c));
        BlockDispenser.a(Items.no, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.d));
        BlockDispenser.a(Items.nu, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.g));
        BlockDispenser.a(Items.nq, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.e));
        BlockDispenser.a(Items.ns, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.f));
        BlockDispenser.a(Items.nw, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.h));
        BlockDispenser.a(Items.ny, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.i));
        BlockDispenser.a(Items.nj, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.a, true));
        BlockDispenser.a(Items.nl, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.b, true));
        BlockDispenser.a(Items.nn, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.c, true));
        BlockDispenser.a(Items.np, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.d, true));
        BlockDispenser.a(Items.nv, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.g, true));
        BlockDispenser.a(Items.nr, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.e, true));
        BlockDispenser.a(Items.nt, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.f, true));
        BlockDispenser.a(Items.nx, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.h, true));
        BlockDispenser.a(Items.nz, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.i, true));
        DispenseBehaviorItem dispensebehavioritem1 = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)stack.d());
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                WorldServer worldserver = pointer.g();
                int x2 = blockposition.u();
                int y2 = blockposition.v();
                int z2 = blockposition.w();
                IBlockData iblockdata = worldserver.a_(blockposition);
                if (iblockdata.i() || iblockdata.r() || dispensiblecontaineritem instanceof ItemBucket && iblockdata.b() instanceof IFluidContainer && ((IFluidContainer)((Object)iblockdata.b())).a((IBlockAccess)worldserver, blockposition, iblockdata, ((ItemBucket)dispensiblecontaineritem).a)) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                    BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(x2, y2, z2));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    dispensiblecontaineritem = (DispensibleContainerItem)((Object)CraftItemStack.asNMSCopy(event.getItem()).d());
                }
                if (dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, blockposition, (MovingObjectPositionBlock)null)) {
                    dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, stack, blockposition);
                    Item item = Items.pK;
                    stack.h(1);
                    if (stack.b()) {
                        stack = new net.minecraft.world.item.ItemStack(item);
                    } else if (((TileEntityDispenser)pointer.f()).a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return this.c.dispense(pointer, stack);
            }
        };
        BlockDispenser.a(Items.pM, dispensebehavioritem1);
        BlockDispenser.a(Items.pL, dispensebehavioritem1);
        BlockDispenser.a(Items.pN, dispensebehavioritem1);
        BlockDispenser.a(Items.pS, dispensebehavioritem1);
        BlockDispenser.a(Items.pT, dispensebehavioritem1);
        BlockDispenser.a(Items.pR, dispensebehavioritem1);
        BlockDispenser.a(Items.pU, dispensebehavioritem1);
        BlockDispenser.a(Items.pV, dispensebehavioritem1);
        BlockDispenser.a(Items.pW, dispensebehavioritem1);
        BlockDispenser.a(Items.pK, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition;
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a)));
                Block block = iblockdata.b();
                if (block instanceof IFluidSource) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    net.minecraft.world.item.ItemStack itemstack1 = ((IFluidSource)((Object)block)).c(DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.b()) {
                        return super.a(pointer, stack);
                    }
                    worldserver.a((Entity)null, GameEvent.z, blockposition);
                    Item item = itemstack1.d();
                    org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                    BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = ((IFluidSource)((Object)block)).c(worldserver, blockposition, iblockdata);
                    stack.h(1);
                    if (stack.b()) {
                        return new net.minecraft.world.item.ItemStack(item);
                    }
                    if (((TileEntityDispenser)pointer.f()).a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.nE, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                this.a(true);
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                IBlockData iblockdata = worldserver.a_(blockposition);
                if (BlockFireAbstract.a((net.minecraft.world.level.World)worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((net.minecraft.world.level.World)worldserver, blockposition, pointer.d()).isCancelled()) {
                        worldserver.b(blockposition, BlockFireAbstract.a(worldserver, blockposition));
                        worldserver.a((Entity)null, GameEvent.i, blockposition);
                    }
                } else if (!(BlockCampfire.h(iblockdata) || CandleBlock.g(iblockdata) || CandleCakeBlock.g(iblockdata))) {
                    if (iblockdata.b() instanceof BlockTNT && CraftEventFactory.callTNTPrimeEvent(worldserver, blockposition, TNTPrimeEvent.PrimeCause.DISPENSER, null, pointer.d())) {
                        BlockTNT.a(worldserver, blockposition);
                        worldserver.a(blockposition, false);
                    } else {
                        this.a(false);
                    }
                } else {
                    worldserver.b(blockposition, (IBlockData)iblockdata.a(BlockProperties.r, true));
                    worldserver.a((Entity)null, GameEvent.c, blockposition);
                }
                if (this.a() && stack.hurt(1, worldserver.z, null)) {
                    stack.f(0);
                }
                return stack;
            }
        });
        BlockDispenser.a(Items.qK, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(true);
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                worldserver.captureTreeGeneration = true;
                if (!ItemBoneMeal.a(stack, worldserver, blockposition) && !ItemBoneMeal.a(stack, worldserver, blockposition, null)) {
                    this.a(false);
                } else if (!worldserver.B) {
                    worldserver.c(1505, blockposition, 0);
                }
                worldserver.captureTreeGeneration = false;
                if (worldserver.capturedBlockStates.size() > 0) {
                    TreeType treeType = BlockSapling.treeType;
                    BlockSapling.treeType = null;
                    Location location = CraftLocation.toBukkit(blockposition, (World)worldserver.getWorld());
                    ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(worldserver.capturedBlockStates.values());
                    worldserver.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                            worldserver.checkCapturedTreeStateForObserverNotify(blockposition, (CraftBlockState)blockState);
                        }
                    }
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.ck, new DispenseBehaviorItem(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.u() + 0.5, (double)blockposition.v(), (double)blockposition.w() + 0.5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.b(entitytntprimed);
                worldserver.a((EntityHuman)null, entitytntprimed.dn(), entitytntprimed.dp(), entitytntprimed.dt(), SoundEffects.xF, SoundCategory.e, 1.0f, 1.0f);
                worldserver.a((Entity)null, GameEvent.t, blockposition);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe1 = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                this.a(ItemArmor.a(pointer, stack));
                return stack;
            }
        };
        BlockDispenser.a(Items.tv, dispensebehaviormaybe1);
        BlockDispenser.a(Items.tu, dispensebehaviormaybe1);
        BlockDispenser.a(Items.tw, dispensebehaviormaybe1);
        BlockDispenser.a(Items.tr, dispensebehaviormaybe1);
        BlockDispenser.a(Items.tx, dispensebehaviormaybe1);
        BlockDispenser.a(Items.tt, dispensebehaviormaybe1);
        BlockDispenser.a(Items.ts, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.t(blockposition) && BlockWitherSkull.b(worldserver, blockposition, stack)) {
                    worldserver.a(blockposition, (IBlockData)Blocks.gG.n().a(BlockSkull.b, RotationSegment.a(enumdirection)), 3);
                    worldserver.a((Entity)null, GameEvent.i, blockposition);
                    TileEntity tileentity = worldserver.c_(blockposition);
                    if (tileentity instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)worldserver, blockposition, (TileEntitySkull)tileentity);
                    }
                    stack.h(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.a(pointer, stack));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.ef, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                BlockPumpkinCarved blockpumpkincarved = (BlockPumpkinCarved)Blocks.ef;
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.t(blockposition) && blockpumpkincarved.a((IWorldReader)worldserver, blockposition)) {
                    if (!worldserver.B) {
                        worldserver.a(blockposition, blockpumpkincarved.n(), 3);
                        worldserver.a((Entity)null, GameEvent.i, blockposition);
                    }
                    stack.h(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.a(pointer, stack));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.kP.k(), new DispenseBehaviorShulkerBox());
        for (EnumColor enumcolor : EnumColor.values()) {
            BlockDispenser.a(BlockShulkerBox.a(enumcolor).k(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.a(Items.rw.k(), new DispenseBehaviorMaybe(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            private net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack emptyBottleStack, net.minecraft.world.item.ItemStack filledBottleStack) {
                emptyBottleStack.h(1);
                if (emptyBottleStack.b()) {
                    pointer.g().a((Entity)null, GameEvent.z, pointer.d());
                    return filledBottleStack.p();
                }
                if (((TileEntityDispenser)pointer.f()).a(filledBottleStack.p()) < 0) {
                    this.c.dispense(pointer, filledBottleStack.p());
                }
                return emptyBottleStack;
            }

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(false);
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                IBlockData iblockdata = worldserver.a_(blockposition);
                org.bukkit.block.Block bukkitBlock = worldserver.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.c.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (iblockdata.a(TagsBlock.aE, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(BlockBeehive.b) && blockbase_blockdata.b() instanceof BlockBeehive) && iblockdata.c(BlockBeehive.b) >= 5) {
                    ((BlockBeehive)iblockdata.b()).a((net.minecraft.world.level.World)worldserver, iblockdata, blockposition, (EntityHuman)null, TileEntityBeehive.ReleaseStatus.b);
                    this.a(true);
                    return this.a(pointer, stack, new net.minecraft.world.item.ItemStack(Items.vD));
                }
                if (worldserver.b_(blockposition).a(TagsFluid.a)) {
                    this.a(true);
                    return this.a(pointer, stack, PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.rv), Potions.c));
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.eY, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.e().c(BlockDispenser.a);
                BlockPosition blockposition = pointer.d().a(enumdirection);
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition);
                this.a(true);
                if (iblockdata.a(Blocks.pl)) {
                    if (iblockdata.c(BlockRespawnAnchor.c) != 4) {
                        net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                        if (result != null) {
                            this.a(false);
                            return result;
                        }
                        BlockRespawnAnchor.a((Entity)null, (net.minecraft.world.level.World)worldserver, blockposition, iblockdata);
                        stack.h(1);
                    } else {
                        this.a(false);
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.rg.k(), new DispenseBehaviorShears());
        BlockDispenser.a(Items.vA, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
                WorldServer worldserver = pointer.g();
                IBlockData iblockdata = worldserver.a_(blockposition);
                Optional<IBlockData> optional = HoneycombItem.b(iblockdata);
                if (optional.isPresent()) {
                    net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                    if (result != null) {
                        this.a(false);
                        return result;
                    }
                    worldserver.b(blockposition, optional.get());
                    worldserver.c(3003, blockposition, 0);
                    stack.h(1);
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.rv, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(ISourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                if (PotionUtil.d(stack) != Potions.c) {
                    return this.c.dispense(pointer, stack);
                }
                WorldServer worldserver = pointer.g();
                BlockPosition blockposition = pointer.d();
                BlockPosition blockposition1 = pointer.d().a(pointer.e().c(BlockDispenser.a));
                if (!worldserver.a_(blockposition1).a(TagsBlock.bY)) {
                    return this.c.dispense(pointer, stack);
                }
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition1, stack, this);
                if (result != null) {
                    return result;
                }
                if (!worldserver.B) {
                    for (int k2 = 0; k2 < 5; ++k2) {
                        worldserver.a(Particles.ag, (double)blockposition.u() + worldserver.z.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + worldserver.z.j(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                worldserver.a((EntityHuman)null, blockposition, SoundEffects.ch, SoundCategory.e, 1.0f, 1.0f);
                worldserver.a((Entity)null, GameEvent.A, blockposition);
                worldserver.b(blockposition1, Blocks.rH.n());
                return new net.minecraft.world.item.ItemStack(Items.rw);
            }
        });
    }

    public static void a(ISourceBlock pointer, Entity entity, EnumDirection direction) {
        entity.e(pointer.a() + (double)direction.j() * (0.5000099999997474 - (double)entity.dd() / 2.0), pointer.b() + (double)direction.k() * (0.5000099999997474 - (double)entity.de() / 2.0) - (double)entity.de() / 2.0, pointer.c() + (double)direction.l() * (0.5000099999997474 - (double)entity.dd() / 2.0));
    }
}

