/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger aq = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> ar = Maps.newLinkedHashMap();
    public static final MinecraftKey a = new MinecraftKey("root");
    private static final IRegistryWritable<IRegistryWritable<?>> as = new RegistryMaterials(ResourceKey.a(a), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> b = BuiltInRegistries.b(Registries.z, "step", registry -> GameEvent.Q);
    public static final IRegistry<SoundEffect> c = BuiltInRegistries.a(Registries.ad, (IRegistry<T> registry) -> SoundEffects.ma);
    public static final RegistryBlocks<FluidType> d = BuiltInRegistries.b(Registries.w, "empty", registry -> FluidTypes.a);
    public static final IRegistry<MobEffectList> e = BuiltInRegistries.a(Registries.O, (IRegistry<T> registry) -> MobEffects.z);
    public static final RegistryBlocks<Block> f = BuiltInRegistries.b(Registries.e, "air", registry -> Blocks.a);
    public static final IRegistry<Enchantment> g = BuiltInRegistries.a(Registries.r, (IRegistry<T> registry) -> Enchantments.x);
    public static final RegistryBlocks<EntityTypes<?>> h = BuiltInRegistries.b(Registries.s, "pig", registry -> EntityTypes.av);
    public static final RegistryBlocks<Item> i = BuiltInRegistries.b(Registries.D, "air", registry -> Items.a);
    public static final RegistryBlocks<PotionRegistry> j = BuiltInRegistries.a(Registries.V, "empty", (IRegistry<T> registry) -> Potions.b);
    public static final IRegistry<Particle<?>> k = BuiltInRegistries.a(Registries.Q, (IRegistry<T> registry) -> Particles.c);
    public static final IRegistry<TileEntityTypes<?>> l = BuiltInRegistries.a(Registries.f, (IRegistry<T> registry) -> TileEntityTypes.a);
    public static final RegistryBlocks<PaintingVariant> m = BuiltInRegistries.a(Registries.P, "kebab", PaintingVariants::a);
    public static final IRegistry<MinecraftKey> n = BuiltInRegistries.a(Registries.o, (IRegistry<T> registry) -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> o = BuiltInRegistries.a(Registries.l, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> p = BuiltInRegistries.a(Registries.Z, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<RuleBlockEntityModifierType<?>> q = BuiltInRegistries.a(Registries.aa, (IRegistry<T> registry) -> RuleBlockEntityModifierType.b);
    public static final IRegistry<PosRuleTestType<?>> r = BuiltInRegistries.a(Registries.U, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> s = BuiltInRegistries.a(Registries.N, (IRegistry<T> registry) -> Containers.h);
    public static final IRegistry<Recipes<?>> t = BuiltInRegistries.a(Registries.X, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> u = BuiltInRegistries.a(Registries.W, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> v = BuiltInRegistries.a(Registries.b, (IRegistry<T> registry) -> GenericAttributes.k);
    public static final IRegistry<PositionSourceType<?>> w = BuiltInRegistries.a(Registries.T, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> x = BuiltInRegistries.a(Registries.m, ArgumentTypeInfos::a);
    public static final IRegistry<StatisticWrapper<?>> y = BuiltInRegistries.a(Registries.ae, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> z = BuiltInRegistries.a(Registries.an, "plains", (IRegistry<T> registry) -> VillagerType.c);
    public static final RegistryBlocks<VillagerProfession> A = BuiltInRegistries.a(Registries.am, "none", (IRegistry<T> registry) -> VillagerProfession.b);
    public static final IRegistry<VillagePlaceType> B = BuiltInRegistries.a(Registries.S, PoiTypes::a);
    public static final RegistryBlocks<MemoryModuleType<?>> C = BuiltInRegistries.a(Registries.M, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> D = BuiltInRegistries.a(Registries.ac, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> E = BuiltInRegistries.a(Registries.ab, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> F = BuiltInRegistries.a(Registries.a, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> G = BuiltInRegistries.a(Registries.I, (IRegistry<T> registry) -> LootEntries.a);
    public static final IRegistry<LootItemFunctionType> H = BuiltInRegistries.a(Registries.F, (IRegistry<T> registry) -> LootItemFunctions.b);
    public static final IRegistry<LootItemConditionType> I = BuiltInRegistries.a(Registries.E, (IRegistry<T> registry) -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> J = BuiltInRegistries.a(Registries.H, (IRegistry<T> registry) -> NumberProviders.a);
    public static final IRegistry<LootNbtProviderType> K = BuiltInRegistries.a(Registries.G, (IRegistry<T> registry) -> NbtProviders.b);
    public static final IRegistry<LootScoreProviderType> L = BuiltInRegistries.a(Registries.J, (IRegistry<T> registry) -> ScoreboardNameProviders.b);
    public static final IRegistry<FloatProviderType<?>> M = BuiltInRegistries.a(Registries.v, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final IRegistry<IntProviderType<?>> N = BuiltInRegistries.a(Registries.C, (IRegistry<T> registry) -> IntProviderType.a);
    public static final IRegistry<HeightProviderType<?>> O = BuiltInRegistries.a(Registries.A, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final IRegistry<BlockPredicateType<?>> P = BuiltInRegistries.a(Registries.g, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final IRegistry<WorldGenCarverAbstract<?>> Q = BuiltInRegistries.a(Registries.i, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final IRegistry<WorldGenerator<?>> R = BuiltInRegistries.a(Registries.t, (IRegistry<T> registry) -> WorldGenerator.I);
    public static final IRegistry<StructurePlacementType<?>> S = BuiltInRegistries.a(Registries.ag, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final IRegistry<WorldGenFeatureStructurePieceType> T = BuiltInRegistries.a(Registries.af, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final IRegistry<StructureType<?>> U = BuiltInRegistries.a(Registries.aj, (IRegistry<T> registry) -> StructureType.f);
    public static final IRegistry<PlacementModifierType<?>> V = BuiltInRegistries.a(Registries.R, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> W = BuiltInRegistries.a(Registries.h, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> X = BuiltInRegistries.a(Registries.x, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> Y = BuiltInRegistries.a(Registries.al, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<RootPlacerType<?>> Z = BuiltInRegistries.a(Registries.Y, (IRegistry<T> registry) -> RootPlacerType.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> aa = BuiltInRegistries.a(Registries.ak, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> ab = BuiltInRegistries.a(Registries.u, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<Codec<? extends WorldChunkManager>> ac = BuiltInRegistries.a(Registries.d, Lifecycle.stable(), BiomeSources::a);
    public static final IRegistry<Codec<? extends ChunkGenerator>> ad = BuiltInRegistries.a(Registries.k, Lifecycle.stable(), ChunkGenerators::a);
    public static final IRegistry<Codec<? extends SurfaceRules.f>> ae = BuiltInRegistries.a(Registries.K, SurfaceRules.f::a);
    public static final IRegistry<Codec<? extends SurfaceRules.o>> af = BuiltInRegistries.a(Registries.L, SurfaceRules.o::a);
    public static final IRegistry<Codec<? extends DensityFunction>> ag = BuiltInRegistries.a(Registries.q, DensityFunctions::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> ah = BuiltInRegistries.a(Registries.ai, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.e);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> ai = BuiltInRegistries.a(Registries.ah, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    public static final IRegistry<CatVariant> aj = BuiltInRegistries.a(Registries.j, CatVariant::a);
    public static final IRegistry<FrogVariant> ak = BuiltInRegistries.a(Registries.y, (IRegistry<T> registry) -> FrogVariant.a);
    public static final IRegistry<EnumBannerPatternType> al = BuiltInRegistries.a(Registries.c, BannerPatterns::a);
    public static final IRegistry<Instrument> am = BuiltInRegistries.a(Registries.B, Instruments::a);
    public static final IRegistry<String> an = BuiltInRegistries.a(Registries.ao, DecoratedPotPatterns::a);
    public static final IRegistry<CreativeModeTab> ao = BuiltInRegistries.a(Registries.n, CreativeModeTabs::a);
    public static final IRegistry<? extends IRegistry<?>> ap = as;

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, a<T> initializer) {
        return BuiltInRegistries.a(key, Lifecycle.stable(), initializer);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.a(key, defaultId, Lifecycle.stable(), initializer);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.b(key, defaultId, Lifecycle.stable(), initializer);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, lifecycle, false), initializer, lifecycle);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, lifecycle, false), initializer, lifecycle);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, lifecycle, true), initializer, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, a<T> initializer, Lifecycle lifecycle) {
        MinecraftKey resourceLocation = key.a();
        ar.put(resourceLocation, () -> initializer.run(registry));
        as.a(key, registry, lifecycle);
        return registry;
    }

    public static void a() {
        BuiltInRegistries.bootStrap(() -> {});
    }

    public static void bootStrap(Runnable runnable) {
        BuiltInRegistries.b();
        runnable.run();
        BuiltInRegistries.c();
        BuiltInRegistries.a(ap);
    }

    private static void b() {
        ar.forEach((id, initializer) -> {
            if (initializer.get() == null) {
                aq.error("Unable to bootstrap registry '{}'", id);
            }
        });
    }

    private static void c() {
        ap.l();
        for (IRegistry iRegistry : ap) {
            iRegistry.l();
        }
    }

    private static <T extends IRegistry<?>> void a(IRegistry<T> registries) {
        registries.forEach(registry -> {
            if (registry.e().isEmpty()) {
                SystemUtils.a("Registry '" + registries.b(registry) + "' was empty after loading");
            }
            if (registry instanceof RegistryBlocks) {
                MinecraftKey resourceLocation = ((RegistryBlocks)registry).a();
                Validate.notNull(registry.a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }

    @FunctionalInterface
    static interface a<T> {
        public T run(IRegistry<T> var1);
    }
}

