/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger n = LogUtils.getLogger();
    private static final int o = 20;
    private static final Services p = new Services(null, ServicesKeySet.EMPTY, null, null);
    private final List<GameTestHarnessBatch> q;
    private final BlockPosition r;
    private static final GameRules s = SystemUtils.a(new GameRules(), (T gameRules) -> {
        gameRules.a(GameRules.e).set(false, null);
        gameRules.a(GameRules.u).set(false, null);
    });
    private static final WorldOptions t = new WorldOptions(0L, false, false);
    @Nullable
    private GameTestHarnessCollector u;

    public static GameTestServer a(Thread thread, Convertable.ConversionSession session, ResourcePackRepository resourcePackManager, Collection<GameTestHarnessBatch> batches, BlockPosition pos) {
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("No test batches were given!");
        }
        resourcePackManager.a();
        WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(new DataPackConfiguration(new ArrayList<String>(resourcePackManager.b()), List.of()), FeatureFlags.c.a());
        WorldSettings levelSettings = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, s, worldDataConfiguration);
        WorldLoader.d packConfig = new WorldLoader.d(resourcePackManager, worldDataConfiguration, false, true);
        WorldLoader.c initConfig = new WorldLoader.c(packConfig, CommandDispatcher.ServerType.b, 4);
        try {
            n.debug("Starting resource loading");
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldStem worldStem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(initConfig, (WorldLoader.a dataLoadContext) -> {
                IRegistry<WorldDimension> registry = new RegistryMaterials<WorldDimension>(Registries.aI, Lifecycle.stable()).l();
                WorldDimensions.b complete = dataLoadContext.c().d(Registries.aF).f(WorldPresets.b).a().a().a(registry);
                return new WorldLoader.b<WorldDataServer>(new WorldDataServer(levelSettings, t, complete.d(), complete.a()), complete.b());
            }, WorldStem::new, SystemUtils.f(), executor)).get();
            stopwatch.stop();
            n.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return new GameTestServer(thread, session, resourcePackManager, worldStem, batches, pos);
        }
        catch (Exception exception) {
            n.warn("Failed to load vanilla datapack, bit oops", (Throwable)exception);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession session, ResourcePackRepository dataPackManager, WorldStem saveLoader, Collection<GameTestHarnessBatch> batches, BlockPosition pos) {
        super(serverThread, session, dataPackManager, saveLoader, Proxy.NO_PROXY, DataConverterRegistry.a(), p, WorldLoadListenerLogger::new);
        this.q = Lists.newArrayList(batches);
        this.r = pos;
    }

    @Override
    @Override
    public boolean e() {
        this.a(new PlayerList(this, this.aW(), this.i, 1){});
        this.loadLevel();
        WorldServer serverLevel = this.D();
        serverLevel.a(this.r, 0.0f);
        int i2 = 20000000;
        serverLevel.a(20000000, 20000000, false, false);
        n.info("Started game test server");
        return true;
    }

    @Override
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        super.a(shouldKeepTicking);
        WorldServer serverLevel = this.D();
        if (!this.bf()) {
            this.b(serverLevel);
        }
        if (serverLevel.V() % 20L == 0L) {
            n.info(this.u.j());
        }
        if (this.u.i()) {
            this.a(false);
            n.info(this.u.j());
            GlobalTestReporter.a();
            n.info("========= {} GAME TESTS COMPLETE ======================", (Object)this.u.h());
            if (this.u.d()) {
                n.info("{} required tests failed :(", (Object)this.u.a());
                this.u.f().forEach(test -> n.info("   - {}", (Object)test.c()));
            } else {
                n.info("All {} required tests passed :)", (Object)this.u.h());
            }
            if (this.u.e()) {
                n.info("{} optional tests failed", (Object)this.u.b());
                this.u.g().forEach(test -> n.info("   - {}", (Object)test.c()));
            }
            n.info("====================================================");
        }
    }

    @Override
    @Override
    public void p_() {
        this.bp();
    }

    @Override
    @Override
    public SystemReport a(SystemReport details) {
        details.a("Type", "Game test server");
        return details;
    }

    @Override
    @Override
    public void g() {
        super.g();
        n.info("Game test server shutting down");
        System.exit(this.u.a());
    }

    @Override
    @Override
    public void a(CrashReport report) {
        super.a(report);
        n.error("Game test server crashed\n{}", (Object)report.e());
        System.exit(1);
    }

    private void b(WorldServer world) {
        Collection<GameTestHarnessInfo> collection = GameTestHarnessRunner.a(this.q, new BlockPosition(0, -60, 0), EnumBlockRotation.a, world, GameTestHarnessTicker.a, 8);
        this.u = new GameTestHarnessCollector(collection);
        n.info("{} tests are now running!", (Object)this.u.h());
    }

    private boolean bf() {
        return this.u != null;
    }

    @Override
    @Override
    public boolean h() {
        return false;
    }

    @Override
    @Override
    public int i() {
        return 0;
    }

    @Override
    @Override
    public int j() {
        return 4;
    }

    @Override
    @Override
    public boolean k() {
        return false;
    }

    @Override
    @Override
    public boolean l() {
        return false;
    }

    @Override
    @Override
    public int m() {
        return 0;
    }

    @Override
    @Override
    public boolean n() {
        return false;
    }

    @Override
    @Override
    public boolean o() {
        return true;
    }

    @Override
    @Override
    public boolean p() {
        return false;
    }

    @Override
    @Override
    public boolean N_() {
        return false;
    }

    @Override
    @Override
    public boolean a(GameProfile profile) {
        return false;
    }
}

