/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;

public class PacketSplitter
extends ByteToMessageDecoder {
    private final byte[] lenBuf = new byte[3];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!channelHandlerContext.channel().isActive()) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        byteBuf.markReaderIndex();
        byte[] bs = this.lenBuf;
        Arrays.fill(bs, (byte)0);
        for (int i2 = 0; i2 < bs.length; ++i2) {
            if (!byteBuf.isReadable()) {
                byteBuf.resetReaderIndex();
                return;
            }
            bs[i2] = byteBuf.readByte();
            if (bs[i2] < 0) continue;
            PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])bs));
            try {
                int j2 = friendlyByteBuf.m();
                if (byteBuf.readableBytes() >= j2) {
                    list.add(byteBuf.readBytes(j2));
                    return;
                }
                byteBuf.resetReaderIndex();
            }
            finally {
                friendlyByteBuf.release();
            }
            return;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }
}

