/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

@FunctionalInterface
public interface ChatDecorator {
    public static final ChatDecorator a = (sender, message) -> CompletableFuture.completedFuture(message);

    @DoNotUse
    @Deprecated
    public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer var1, IChatBaseComponent var2);

    default public CompletableFuture<Result> decorate(@Nullable EntityPlayer sender, @Nullable CommandListenerWrapper commandSourceStack, IChatBaseComponent message) {
        throw new UnsupportedOperationException("Must override this implementation");
    }

    public static ChatDecorator create(final ImprovedChatDecorator delegate) {
        return new ChatDecorator(){

            @Override
            public CompletableFuture<IChatBaseComponent> decorate(@Nullable EntityPlayer sender, IChatBaseComponent message) {
                return this.decorate(sender, null, message).thenApply(Result::component);
            }

            @Override
            public CompletableFuture<Result> decorate(@Nullable EntityPlayer sender, @Nullable CommandListenerWrapper commandSourceStack, IChatBaseComponent message) {
                return delegate.decorate(sender, commandSourceStack, message);
            }
        };
    }

    @FunctionalInterface
    public static interface ImprovedChatDecorator {
        public CompletableFuture<Result> decorate(@Nullable EntityPlayer var1, @Nullable CommandListenerWrapper var2, IChatBaseComponent var3);
    }

    public record ModernResult(IChatBaseComponent component, boolean hasNoFormatting, boolean modernized) implements Result
    {
        public ModernResult(Component component, boolean hasNoFormatting, boolean modernized) {
            this(PaperAdventure.asVanilla(component), hasNoFormatting, modernized);
        }

        @Override
        public MessagePair message() {
            Component adventureComponent = PaperAdventure.WRAPPER_AWARE_SERIALIZER.deserialize((Object)this.component);
            return new MessagePair(adventureComponent, LegacyComponentSerializer.legacySection().serialize(adventureComponent));
        }
    }

    public record LegacyResult(IChatBaseComponent component, String format, MessagePair message, boolean hasNoFormatting, boolean modernized) implements Result
    {
        public LegacyResult(Component component, String format, MessagePair message, boolean hasNoFormatting, boolean modernified) {
            this(PaperAdventure.asVanilla(component), format, message, hasNoFormatting, modernified);
        }

        public LegacyResult(IChatBaseComponent component, String format, MessagePair message, boolean hasNoFormatting, boolean modernized) {
            IChatBaseComponent iChatBaseComponent;
            if (component instanceof AdventureComponent) {
                AdventureComponent adventureComponent = (AdventureComponent)component;
                iChatBaseComponent = adventureComponent.deepConverted();
            } else {
                iChatBaseComponent = component;
            }
            this.component = component = iChatBaseComponent;
            this.format = format;
            this.message = message;
            this.hasNoFormatting = hasNoFormatting;
            this.modernized = modernized;
        }
    }

    public record MessagePair(Component component, String legacyMessage) {
    }

    public static interface Result {
        public boolean hasNoFormatting();

        public IChatBaseComponent component();

        public MessagePair message();

        public boolean modernized();
    }
}

