/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.util.UpdateSuppressionException;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> ret = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            ret.add(listener);
        }
        return ret;
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, WorldServer world) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, listener, world.n());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, IAsyncTaskHandler<?> engine) throws CancelledPacketHandleException {
        if (!engine.bl()) {
            engine.execute(() -> {
                packetProcessing.push(listener);
                try {
                    if (MinecraftServer.getServer().hasStopped() || listener instanceof PlayerConnection && ((PlayerConnection)listener).processedDisconnect) {
                        return;
                    }
                    if (listener.a()) {
                        try {
                            packet.a(listener);
                        }
                        catch (UpdateSuppressionException exception) {
                            LeavesLogger.LOGGER.info(exception.getMessage());
                        }
                        catch (Exception exception) {
                            if (listener.b()) {
                                throw exception;
                            }
                            a.error("Failed to handle packet {}, suppressing error", (Object)packet, (Object)exception);
                        }
                    } else {
                        a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                }
                finally {
                    totalMainThreadPacketsProcessed.getAndIncrement();
                    packetProcessing.pop();
                }
            });
            throw CancelledPacketHandleException.a;
        }
        if (MinecraftServer.getServer().hasStopped() || listener instanceof PlayerConnection && ((PlayerConnection)listener).processedDisconnect) {
            throw CancelledPacketHandleException.a;
        }
    }
}

