/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class CustomFunctionManager
implements IReloadListener {
    private static final Logger a = LogUtils.getLogger();
    private static final FileToIdConverter b = new FileToIdConverter("functions", ".mcfunction");
    private volatile Map<MinecraftKey, CustomFunction> c = ImmutableMap.of();
    private final TagDataPack<CustomFunction> d = new TagDataPack<CustomFunction>(this::a, "tags/functions");
    private volatile Map<MinecraftKey, Collection<CustomFunction>> e = Map.of();
    private final int f;
    private final CommandDispatcher<CommandListenerWrapper> g;

    public Optional<CustomFunction> a(MinecraftKey id) {
        return Optional.ofNullable(this.c.get(id));
    }

    public Map<MinecraftKey, CustomFunction> a() {
        return this.c;
    }

    public Collection<CustomFunction> b(MinecraftKey id) {
        return this.e.getOrDefault(id, List.of());
    }

    public Iterable<MinecraftKey> b() {
        return this.e.keySet();
    }

    public CustomFunctionManager(int level, CommandDispatcher<CommandListenerWrapper> commandDispatcher) {
        this.f = level;
        this.g = commandDispatcher;
    }

    @Override
    @Override
    public CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, GameProfilerFiller prepareProfiler, GameProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> this.d.a(manager), prepareExecutor);
        CompletionStage completableFuture2 = CompletableFuture.supplyAsync(() -> b.a(manager), prepareExecutor).thenCompose(functions -> {
            HashMap map = Maps.newHashMap();
            CommandListenerWrapper commandSourceStack = new CommandListenerWrapper(ICommandListener.a, Vec3D.b, Vec2F.a, null, this.f, "", CommonComponents.a, null, null);
            for (Map.Entry entry : functions.entrySet()) {
                MinecraftKey resourceLocation = (MinecraftKey)entry.getKey();
                MinecraftKey resourceLocation2 = b.b(resourceLocation);
                map.put(resourceLocation2, CompletableFuture.supplyAsync(() -> {
                    List<String> list = CustomFunctionManager.a((IResource)entry.getValue());
                    return CustomFunction.a(resourceLocation2, this.g, commandSourceStack, list);
                }, prepareExecutor));
            }
            CompletableFuture[] completableFutures = map.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(completableFutures).handle((unused, ex) -> map);
        });
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenCombine(completableFuture2, Pair::of)).thenCompose(synchronizer::a)).thenAcceptAsync(intermediate -> {
            Map map = (Map)intermediate.getSecond();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((id, functionFuture) -> ((CompletableFuture)functionFuture.handle((function, ex) -> {
                if (ex != null) {
                    a.error("Failed to load function {}", id, ex);
                } else {
                    builder.put(id, function);
                }
                return null;
            })).join());
            this.c = builder.build();
            this.e = this.d.a((Map)intermediate.getFirst());
        }, applyExecutor);
    }

    private static List<String> a(IResource resource) {
        List<String> list;
        block8: {
            BufferedReader bufferedReader = resource.e();
            try {
                list = bufferedReader.lines().toList();
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new CompletionException(iOException);
                }
            }
            bufferedReader.close();
        }
        return list;
    }
}

