/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootDataManager;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger a = LogUtils.getLogger();
    private static final CompletableFuture<Unit> b = CompletableFuture.completedFuture(Unit.a);
    private final CommandBuildContext.a c;
    public CommandDispatcher d;
    private final CraftingManager e = new CraftingManager();
    private final TagRegistry f;
    private final LootDataManager g = new LootDataManager();
    private final AdvancementDataWorld h = new AdvancementDataWorld(this.g);
    private final CustomFunctionManager i;

    public DataPackResources(IRegistryCustom.Dimension dynamicRegistryManager, FeatureFlagSet enabledFeatures, CommandDispatcher.ServerType environment, int functionPermissionLevel) {
        this.f = new TagRegistry(dynamicRegistryManager);
        this.c = CommandBuildContext.a(dynamicRegistryManager, enabledFeatures);
        this.d = new CommandDispatcher(environment, this.c);
        this.c.a(CommandBuildContext.b.a);
        this.i = new CustomFunctionManager(functionPermissionLevel, this.d.a());
    }

    public CustomFunctionManager a() {
        return this.i;
    }

    public LootDataManager b() {
        return this.g;
    }

    public CraftingManager c() {
        return this.e;
    }

    public CommandDispatcher d() {
        return this.d;
    }

    public AdvancementDataWorld e() {
        return this.h;
    }

    public List<IReloadListener> f() {
        return List.of(this.f, this.g, this.e, this.i, this.h);
    }

    public static CompletableFuture<DataPackResources> a(IResourceManager manager, IRegistryCustom.Dimension dynamicRegistryManager, FeatureFlagSet enabledFeatures, CommandDispatcher.ServerType environment, int functionPermissionLevel, Executor prepareExecutor, Executor applyExecutor) {
        DataPackResources reloadableServerResources = new DataPackResources(dynamicRegistryManager, enabledFeatures, environment, functionPermissionLevel);
        return ((CompletableFuture)Reloadable.a(manager, reloadableServerResources.f(), prepareExecutor, applyExecutor, b, a.isDebugEnabled()).a().whenComplete((void_, throwable) -> reloadableServerResources.c.a(CommandBuildContext.b.b))).thenApply(void_ -> reloadableServerResources);
    }

    public void a(IRegistryCustom dynamicRegistryManager) {
        this.f.a().forEach(tags -> DataPackResources.a(dynamicRegistryManager, tags));
        Blocks.a();
    }

    private static <T> void a(IRegistryCustom dynamicRegistryManager, TagRegistry.a<T> tags) {
        ResourceKey resourceKey = tags.a();
        Map map = tags.b().entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.a(resourceKey, (MinecraftKey)entry.getKey()), entry -> List.copyOf((Collection)entry.getValue())));
        dynamicRegistryManager.d(resourceKey).a(map);
    }
}

