/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.slf4j.Logger;

public class CommandDebug {
    private static final Logger a = LogUtils.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.debug.alreadyRunning"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("debug").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("start").executes(context -> CommandDebug.a((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> CommandDebug.b((CommandListenerWrapper)context.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("function").requires(commandSourceStack -> commandSourceStack.c(3))).then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.a).executes(context -> CommandDebug.a((CommandListenerWrapper)context.getSource(), ArgumentTag.a((CommandContext<CommandListenerWrapper>)context, "name")))))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.l();
        if (minecraftServer.ba()) {
            throw c.create();
        }
        minecraftServer.bb();
        source.a(() -> IChatBaseComponent.c("commands.debug.started"), true);
        return 0;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.l();
        if (!minecraftServer.ba()) {
            throw b.create();
        }
        MethodProfilerResults profileResults = minecraftServer.bc();
        double d2 = (double)profileResults.g() / (double)TimeRange.a;
        double e2 = (double)profileResults.f() / d2;
        source.a(() -> IChatBaseComponent.a("commands.debug.stopped", new Object[]{String.format(Locale.ROOT, "%.2f", d2), profileResults.f(), String.format(Locale.ROOT, "%.2f", e2)}), true);
        return (int)e2;
    }

    private static int a(CommandListenerWrapper source, Collection<CustomFunction> functions) {
        int i2 = 0;
        MinecraftServer minecraftServer = source.l();
        String string = "debug-trace-" + SystemUtils.e() + ".txt";
        try {
            Path path = minecraftServer.c("debug").toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path.resolve(string), StandardCharsets.UTF_8, new OpenOption[0]);){
                PrintWriter printWriter = new PrintWriter(writer);
                for (CustomFunction commandFunction : functions) {
                    printWriter.println(commandFunction.a());
                    a tracer = new a(printWriter);
                    i2 += source.l().aA().a(commandFunction, source.a(tracer).b(2), tracer);
                }
            }
        }
        catch (IOException | UncheckedIOException exception) {
            a.warn("Tracing failed", (Throwable)exception);
            source.b(IChatBaseComponent.c("commands.debug.function.traceFailed"));
        }
        int j2 = i2;
        if (functions.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.debug.function.success.single", j2, ((CustomFunction)functions.iterator().next()).a(), string), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.debug.function.success.multiple", j2, functions.size(), string), true);
        }
        return i2;
    }

    static class a
    implements CustomFunctionData.TraceCallbacks,
    ICommandListener {
        public static final int b = 1;
        private final PrintWriter c;
        private int d;
        private boolean e;

        a(PrintWriter writer) {
            this.c = writer;
        }

        private void a(int width) {
            this.b(width);
            this.d = width;
        }

        private void b(int width) {
            for (int i2 = 0; i2 < width + 1; ++i2) {
                this.c.write("    ");
            }
        }

        private void e() {
            if (this.e) {
                this.c.println();
                this.e = false;
            }
        }

        @Override
        @Override
        public void a(int depth, String command) {
            this.e();
            this.a(depth);
            this.c.print("[C] ");
            this.c.print(command);
            this.e = true;
        }

        @Override
        @Override
        public void a(int depth, String command, int result) {
            if (this.e) {
                this.c.print(" -> ");
                this.c.println(result);
                this.e = false;
            } else {
                this.a(depth);
                this.c.print("[R = ");
                this.c.print(result);
                this.c.print("] ");
                this.c.println(command);
            }
        }

        @Override
        @Override
        public void a(int depth, MinecraftKey function, int size) {
            this.e();
            this.a(depth);
            this.c.print("[F] ");
            this.c.print(function);
            this.c.print(" size=");
            this.c.println(size);
        }

        @Override
        @Override
        public void b(int depth, String message) {
            this.e();
            this.a(depth + 1);
            this.c.print("[E] ");
            this.c.print(message);
        }

        @Override
        @Override
        public void a(IChatBaseComponent message) {
            this.e();
            this.b(this.d + 1);
            this.c.print("[M] ");
            this.c.println(message.getString());
        }

        @Override
        @Override
        public boolean e_() {
            return true;
        }

        @Override
        @Override
        public boolean q_() {
            return true;
        }

        @Override
        @Override
        public boolean N_() {
            return false;
        }

        @Override
        @Override
        public boolean f_() {
            return true;
        }
    }
}

