/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;

public class CommandWhitelist {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.whitelist.remove.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("whitelist").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("on").executes(context -> CommandWhitelist.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("off").executes(context -> CommandWhitelist.c((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandWhitelist.d((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentProfile.a()).suggests((context, builder) -> {
            PlayerList playerList = ((CommandListenerWrapper)context.getSource()).l().ac();
            return ICompletionProvider.b(playerList.t().stream().filter(player -> !playerList.i().a(player.fM())).map(player -> player.fM().getName()), builder);
        }).executes(context -> CommandWhitelist.a((CommandListenerWrapper)context.getSource(), ArgumentProfile.a((CommandContext<CommandListenerWrapper>)context, "targets")))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentProfile.a()).suggests((context, builder) -> ICompletionProvider.a(((CommandListenerWrapper)context.getSource()).l().ac().j(), builder)).executes(context -> CommandWhitelist.b((CommandListenerWrapper)context.getSource(), ArgumentProfile.a((CommandContext<CommandListenerWrapper>)context, "targets")))))).then(net.minecraft.commands.CommandDispatcher.a("reload").executes(context -> CommandWhitelist.a((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) {
        source.l().ac().a();
        source.a(() -> IChatBaseComponent.c("commands.whitelist.reloaded"), true);
        source.l().a(source);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Collection<GameProfile> targets) throws CommandSyntaxException {
        WhiteList userWhiteList = source.l().ac().i();
        int i2 = 0;
        for (GameProfile gameProfile : targets) {
            if (userWhiteList.a(gameProfile)) continue;
            WhiteListEntry userWhiteListEntry = new WhiteListEntry(gameProfile);
            userWhiteList.a(userWhiteListEntry);
            source.a(() -> IChatBaseComponent.a("commands.whitelist.add.success", ChatComponentUtils.a(gameProfile)), true);
            ++i2;
        }
        if (i2 == 0) {
            throw c.create();
        }
        return i2;
    }

    private static int b(CommandListenerWrapper source, Collection<GameProfile> targets) throws CommandSyntaxException {
        WhiteList userWhiteList = source.l().ac().i();
        int i2 = 0;
        for (GameProfile gameProfile : targets) {
            if (!userWhiteList.a(gameProfile)) continue;
            WhiteListEntry userWhiteListEntry = new WhiteListEntry(gameProfile);
            userWhiteList.b(userWhiteListEntry);
            source.a(() -> IChatBaseComponent.a("commands.whitelist.remove.success", ChatComponentUtils.a(gameProfile)), true);
            ++i2;
        }
        if (i2 == 0) {
            throw d.create();
        }
        source.l().a(source);
        return i2;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        PlayerList playerList = source.l().ac();
        if (playerList.o()) {
            throw a.create();
        }
        playerList.a(true);
        source.a(() -> IChatBaseComponent.c("commands.whitelist.enabled"), true);
        source.l().a(source);
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        PlayerList playerList = source.l().ac();
        if (!playerList.o()) {
            throw b.create();
        }
        playerList.a(false);
        source.a(() -> IChatBaseComponent.c("commands.whitelist.disabled"), true);
        return 1;
    }

    private static int d(CommandListenerWrapper source) {
        String[] strings = source.l().ac().j();
        if (strings.length == 0) {
            source.a(() -> IChatBaseComponent.c("commands.whitelist.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.whitelist.list", strings.length, String.join((CharSequence)", ", strings)), false);
        }
        return strings.length;
    }
}

