/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PlaceCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(id -> IChatBaseComponent.a("commands.place.template.invalid", id));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.template.failed"));
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, builder) -> {
        StructureTemplateManager structureTemplateManager = ((CommandListenerWrapper)context.getSource()).e().p();
        return ICompletionProvider.a(structureTemplateManager.a(), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("place").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("feature").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("feature", ResourceKeyArgument.a(Registries.as)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "feature"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "feature"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("jigsaw").then(net.minecraft.commands.CommandDispatcher.a("pool", ResourceKeyArgument.a(Registries.aC)).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentMinecraftKeyRegistered.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("max_depth", IntegerArgumentType.integer((int)1, (int)7)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)context, "pool"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("position", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)context, "pool"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "position"))))))))).then(net.minecraft.commands.CommandDispatcher.a("structure").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("structure", ResourceKeyArgument.a(Registries.az)).executes(context -> PlaceCommand.b((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)context, "structure"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.b((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)context, "structure"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("template").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("template", ArgumentMinecraftKeyRegistered.a()).suggests(f).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d()), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotation", TemplateRotationArgument.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), EnumBlockMirror.a, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("mirror", TemplateMirrorArgument.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), 0))).then(net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"))))))))))));
    }

    public static int a(CommandListenerWrapper source, Holder.c<WorldGenFeatureConfigured<?, ?>> feature, BlockPosition pos) throws CommandSyntaxException {
        WorldServer serverLevel = source.e();
        WorldGenFeatureConfigured<?, ?> configuredFeature = feature.a();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        PlaceCommand.a(serverLevel, new ChunkCoordIntPair(chunkPos.e - 1, chunkPos.f - 1), new ChunkCoordIntPair(chunkPos.e + 1, chunkPos.f + 1));
        if (!configuredFeature.a(serverLevel, serverLevel.k().g(), serverLevel.y_(), pos)) {
            throw a.create();
        }
        String string = feature.g().a().toString();
        source.a(() -> IChatBaseComponent.a("commands.place.feature.success", new Object[]{string, pos.u(), pos.v(), pos.w()}), true);
        return 1;
    }

    public static int a(CommandListenerWrapper source, Holder<WorldGenFeatureDefinedStructurePoolTemplate> structurePool, MinecraftKey id, int maxDepth, BlockPosition pos) throws CommandSyntaxException {
        WorldServer serverLevel = source.e();
        if (!WorldGenFeatureDefinedStructureJigsawPlacement.a(serverLevel, structurePool, id, maxDepth, pos, false)) {
            throw b.create();
        }
        source.a(() -> IChatBaseComponent.a("commands.place.jigsaw.success", pos.u(), pos.v(), pos.w()), true);
        return 1;
    }

    public static int b(CommandListenerWrapper source, Holder.c<Structure> structure, BlockPosition pos) throws CommandSyntaxException {
        WorldServer serverLevel = source.e();
        Structure structure2 = structure.a();
        ChunkGenerator chunkGenerator = serverLevel.k().g();
        StructureStart structureStart = structure2.a(source.v(), chunkGenerator, chunkGenerator.c(), serverLevel.k().i(), serverLevel.p(), serverLevel.A(), new ChunkCoordIntPair(pos), 0, serverLevel, biome -> true);
        if (!structureStart.b()) {
            throw c.create();
        }
        StructureBoundingBox boundingBox = structureStart.a();
        ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(SectionPosition.a(boundingBox.g()), SectionPosition.a(boundingBox.i()));
        ChunkCoordIntPair chunkPos22 = new ChunkCoordIntPair(SectionPosition.a(boundingBox.j()), SectionPosition.a(boundingBox.l()));
        PlaceCommand.a(serverLevel, chunkPos2, chunkPos22);
        ChunkCoordIntPair.a(chunkPos2, chunkPos22).forEach(chunkPos -> structureStart.a(serverLevel, serverLevel.a(), chunkGenerator, serverLevel.y_(), new StructureBoundingBox(chunkPos.d(), serverLevel.C_(), chunkPos.e(), chunkPos.f(), serverLevel.aj(), chunkPos.g()), (ChunkCoordIntPair)chunkPos));
        String string = structure.g().a().toString();
        source.a(() -> IChatBaseComponent.a("commands.place.structure.success", new Object[]{string, pos.u(), pos.v(), pos.w()}), true);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(CommandListenerWrapper source, MinecraftKey id, BlockPosition pos, EnumBlockRotation rotation, EnumBlockMirror mirror, float integrity, int seed) throws CommandSyntaxException {
        boolean bl;
        void optional2;
        WorldServer serverLevel = source.e();
        StructureTemplateManager structureTemplateManager = serverLevel.p();
        try {
            Optional<DefinedStructure> optional = structureTemplateManager.b(id);
        }
        catch (ResourceKeyInvalidException resourceLocationException) {
            throw d.create((Object)id);
        }
        if (optional2.isEmpty()) {
            throw d.create((Object)id);
        }
        DefinedStructure structureTemplate = (DefinedStructure)optional2.get();
        PlaceCommand.a(serverLevel, new ChunkCoordIntPair(pos), new ChunkCoordIntPair(pos.a(structureTemplate.a())));
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(mirror).a(rotation);
        if (integrity < 1.0f) {
            structurePlaceSettings.b().a(new DefinedStructureProcessorRotation(integrity)).a(TileEntityStructure.b(seed));
        }
        if (!(bl = structureTemplate.a(serverLevel, pos, pos, structurePlaceSettings, TileEntityStructure.b(seed), 2))) {
            throw e.create();
        }
        source.a(() -> IChatBaseComponent.a("commands.place.template.success", id, pos.u(), pos.v(), pos.w()), true);
        return 1;
    }

    private static void a(WorldServer world, ChunkCoordIntPair pos1, ChunkCoordIntPair pos2) throws CommandSyntaxException {
        if (ChunkCoordIntPair.a(pos1, pos2).filter(pos -> !world.o(pos.l())).findAny().isPresent()) {
            throw ArgumentPosition.a.create();
        }
    }
}

