/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EnumItemSlot>, Item> a = SystemUtils.a(Maps.newHashMap(), (T map) -> {
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)((Object)EnumItemSlot.f)), Items.oO);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)((Object)EnumItemSlot.e)), Items.oP);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)((Object)EnumItemSlot.d)), Items.oQ);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)((Object)EnumItemSlot.c)), Items.oR);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)((Object)EnumItemSlot.f)), Items.oS);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)((Object)EnumItemSlot.e)), Items.oT);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)((Object)EnumItemSlot.d)), Items.oU);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)((Object)EnumItemSlot.c)), Items.oV);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)((Object)EnumItemSlot.f)), Items.pa);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)((Object)EnumItemSlot.e)), Items.pb);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)((Object)EnumItemSlot.d)), Items.pc);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)((Object)EnumItemSlot.c)), Items.pd);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)((Object)EnumItemSlot.f)), Items.pe);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)((Object)EnumItemSlot.e)), Items.pf);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)((Object)EnumItemSlot.d)), Items.pg);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)((Object)EnumItemSlot.c)), Items.ph);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)((Object)EnumItemSlot.f)), Items.oW);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)((Object)EnumItemSlot.e)), Items.oX);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)((Object)EnumItemSlot.d)), Items.oY);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)((Object)EnumItemSlot.c)), Items.oZ);
        map.put(Pair.of((Object)EnumArmorMaterial.f, (Object)((Object)EnumItemSlot.f)), Items.nC);
    });
    private static final List<ResourceKey<TrimPattern>> b = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p);
    private static final List<ResourceKey<TrimMaterial>> c = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j);
    private static final ToIntFunction<ResourceKey<TrimPattern>> d = SystemUtils.e(b);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> e = SystemUtils.e(c);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spawn_armor_trims").requires(source -> source.c(2))).executes(context -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).h()))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        World level = player.dI();
        NonNullList<ArmorTrim> nonNullList = NonNullList.a();
        IRegistry<TrimPattern> registry = level.B_().d(Registries.aE);
        IRegistry<TrimMaterial> registry2 = level.B_().d(Registries.aD);
        registry.s().sorted(Comparator.comparing(pattern -> d.applyAsInt(registry.c((TrimPattern)pattern).orElse(null)))).forEachOrdered(pattern -> registry2.s().sorted(Comparator.comparing(material -> e.applyAsInt(registry2.c((TrimMaterial)material).orElse(null)))).forEachOrdered(material -> nonNullList.add(new ArmorTrim(registry2.d((TrimMaterial)material), registry.d((TrimPattern)pattern)))));
        BlockPosition blockPos = player.di().a(player.cB(), 5);
        int i2 = EnumArmorMaterial.values().length - 1;
        double d2 = 3.0;
        int j2 = 0;
        int k2 = 0;
        for (ArmorTrim armorTrim : nonNullList) {
            for (EnumArmorMaterial armorMaterial : EnumArmorMaterial.values()) {
                if (armorMaterial == EnumArmorMaterial.a) continue;
                double e2 = (double)blockPos.u() + 0.5 - (double)(j2 % registry2.b()) * 3.0;
                double f2 = (double)blockPos.v() + 0.5 + (double)(k2 % i2) * 3.0;
                double g2 = (double)blockPos.w() + 0.5 + (double)(j2 / registry2.b() * 10);
                EntityArmorStand armorStand = new EntityArmorStand(level, e2, f2, g2);
                armorStand.a_(180.0f);
                armorStand.e(true);
                for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
                    ItemArmor armorItem;
                    Item item = a.get(Pair.of((Object)armorMaterial, (Object)((Object)equipmentSlot)));
                    if (item == null) continue;
                    ItemStack itemStack = new ItemStack(item);
                    ArmorTrim.a(level.B_(), itemStack, armorTrim);
                    armorStand.a(equipmentSlot, itemStack);
                    if (item instanceof ItemArmor && (armorItem = (ItemArmor)item).d() == EnumArmorMaterial.f) {
                        armorStand.b(armorTrim.a().a().a(armorTrim.b()).e().f(" ").b(armorTrim.b().a().e()));
                        armorStand.n(true);
                        continue;
                    }
                    armorStand.j(true);
                }
                level.b(armorStand);
                ++k2;
            }
            ++j2;
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

