/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ResourcePackFile
extends ResourcePackAbstract {
    private static final Logger d = LogUtils.getLogger();
    public static final Splitter a = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private final File e;
    @Nullable
    private ZipFile f;
    private boolean g;

    public ResourcePackFile(String name, File backingZipFile, boolean alwaysStable) {
        super(name, alwaysStable);
        this.e = backingZipFile;
    }

    @Nullable
    private ZipFile c() {
        if (this.g) {
            return null;
        }
        if (this.f == null) {
            try {
                this.f = new ZipFile(this.e);
            }
            catch (IOException iOException) {
                d.error("Failed to open pack {}", (Object)this.e, (Object)iOException);
                this.g = true;
                return null;
            }
        }
        return this.f;
    }

    private static String b(EnumResourcePackType type, MinecraftKey id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.a(), id.b(), id.a());
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(String ... segments) {
        return this.a(String.join((CharSequence)"/", segments));
    }

    @Override
    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        return this.a(ResourcePackFile.b(type, id));
    }

    @Nullable
    private IoSupplier<InputStream> a(String path) {
        ZipFile zipFile = this.c();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(path);
        if (zipEntry == null) {
            return null;
        }
        return IoSupplier.create(zipFile, zipEntry);
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        ZipFile zipFile = this.c();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet set = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList list;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!string.startsWith(type.a() + "/") || (list = Lists.newArrayList((Iterable)a.split((CharSequence)string))).size() <= 1) continue;
            String string2 = (String)list.get(1);
            if (string2.equals(string2.toLowerCase(Locale.ROOT))) {
                set.add(string2);
                continue;
            }
            d.warn("Ignored non-lowercase namespace: {} in {}", (Object)string2, (Object)this.e);
        }
        return set;
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    @Override
    public void close() {
        if (this.f != null) {
            IOUtils.closeQuietly((Closeable)this.f);
            this.f = null;
        }
    }

    @Override
    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        ZipFile zipFile = this.c();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String string = type.a() + "/" + namespace + "/";
        String string2 = string + prefix + "/";
        while (enumeration.hasMoreElements()) {
            String string3;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).startsWith(string2)) continue;
            String string4 = string3.substring(string.length());
            MinecraftKey resourceLocation = MinecraftKey.a(namespace, string4);
            if (resourceLocation != null) {
                consumer.accept(resourceLocation, IoSupplier.create(zipFile, zipEntry));
                continue;
            }
            d.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)string4);
        }
    }
}

