/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class ResourcePackVanilla
implements IResourcePack {
    private static final Logger a = LogUtils.getLogger();
    private final BuiltInMetadata d;
    private final Set<String> e;
    private final List<Path> f;
    private final Map<EnumResourcePackType, List<Path>> g;

    ResourcePackVanilla(BuiltInMetadata metadata, Set<String> namespaces, List<Path> rootPaths, Map<EnumResourcePackType, List<Path>> namespacePaths) {
        this.d = metadata;
        this.e = namespaces;
        this.f = rootPaths;
        this.g = namespacePaths;
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(String ... segments) {
        FileUtils.a(segments);
        List<String> list = List.of(segments);
        for (Path path : this.f) {
            Path path2 = FileUtils.a(path, list);
            if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.a(path2)) continue;
            return IoSupplier.create(path2);
        }
        return null;
    }

    public void a(EnumResourcePackType type, MinecraftKey path, Consumer<Path> consumer) {
        FileUtils.c(path.a()).get().ifLeft(segments -> {
            String string = path.b();
            for (Path path : this.g.get((Object)type)) {
                Path path2 = path.resolve(string);
                consumer.accept(FileUtils.a(path2, segments));
            }
        }).ifRight(result -> a.error("Invalid path {}: {}", (Object)path, (Object)result.message()));
    }

    @Override
    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        FileUtils.c(prefix).get().ifLeft(segments -> {
            List<Path> list = this.g.get((Object)type);
            int i2 = list.size();
            if (i2 == 1) {
                ResourcePackVanilla.a(consumer, namespace, list.get(0), segments);
            } else if (i2 > 1) {
                HashMap<MinecraftKey, IoSupplier<InputStream>> map = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
                for (int j2 = 0; j2 < i2 - 1; ++j2) {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, list.get(j2), segments);
                }
                Path path = list.get(i2 - 1);
                if (map.isEmpty()) {
                    ResourcePackVanilla.a(consumer, namespace, path, segments);
                } else {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, path, segments);
                    map.forEach(consumer);
                }
            }
        }).ifRight(result -> a.error("Invalid path {}: {}", (Object)prefix, (Object)result.message()));
    }

    private static void a(IResourcePack.a consumer, String namespace, Path root, List<String> prefixSegments) {
        Path path = root.resolve(namespace);
        PathPackResources.a(namespace, path, prefixSegments, consumer);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        return FileUtils.c(id.a()).get().map(segments -> {
            String string = id.b();
            for (Path path : this.g.get((Object)type)) {
                Path path2 = FileUtils.a(path.resolve(string), segments);
                if (!Files.exists(path2, new LinkOption[0]) || !PathPackResources.a(path2)) continue;
                return IoSupplier.create(path2);
            }
            return null;
        }, result -> {
            a.error("Invalid path {}: {}", (Object)id, (Object)result.message());
            return null;
        });
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        return this.e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) {
        IoSupplier<InputStream> ioSupplier = this.a("pack.mcmeta");
        if (ioSupplier == null) return this.d.a(metaReader);
        try (InputStream inputStream = ioSupplier.get();){
            T object = ResourcePackAbstract.a(metaReader, inputStream);
            if (object == null) return this.d.a(metaReader);
            T t2 = object;
            return t2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.d.a(metaReader);
    }

    @Override
    @Override
    public String a() {
        return "vanilla";
    }

    @Override
    @Override
    public boolean b() {
        return true;
    }

    @Override
    @Override
    public void close() {
    }

    public ResourceProvider c() {
        return name -> Optional.ofNullable(this.a(EnumResourcePackType.a, name)).map(stream -> new IResource(this, (IoSupplier<InputStream>)stream));
    }
}

