/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackFile;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import org.slf4j.Logger;

public class ResourcePackSourceFolder
implements ResourcePackSource {
    private static final Logger a = LogUtils.getLogger();
    private final Path b;
    private final EnumResourcePackType c;
    private final PackSource d;

    public ResourcePackSourceFolder(Path packsDir, EnumResourcePackType type, PackSource source) {
        this.b = packsDir;
        this.c = type;
        this.d = source;
    }

    private static String a(Path path) {
        return path.getFileName().toString();
    }

    @Override
    @Override
    public void a(Consumer<ResourcePackLoader> profileAdder) {
        try {
            FileUtils.c(this.b);
            ResourcePackSourceFolder.a(this.b, false, (Path path, ResourcePackLoader.c packFactory) -> {
                String string = ResourcePackSourceFolder.a(path);
                ResourcePackLoader pack = ResourcePackLoader.a("file/" + string, IChatBaseComponent.b(string), false, packFactory, this.c, ResourcePackLoader.Position.a, this.d);
                if (pack != null) {
                    profileAdder.accept(pack);
                }
            });
        }
        catch (IOException iOException) {
            a.warn("Failed to list packs in {}", (Object)this.b, (Object)iOException);
        }
    }

    public static void a(Path packsDir, boolean alwaysStable, BiConsumer<Path, ResourcePackLoader.c> consumer) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(packsDir);){
            for (Path path : directoryStream) {
                ResourcePackLoader.c resourcesSupplier = ResourcePackSourceFolder.a(path, alwaysStable);
                if (resourcesSupplier == null) continue;
                consumer.accept(path, resourcesSupplier);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ResourcePackLoader.c a(Path path, boolean alwaysStable) {
        FileSystem fileSystem;
        void basicFileAttributes2;
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (IOException iOException) {
            a.warn("Failed to read properties of '{}', ignoring", (Object)path, (Object)iOException);
            return null;
        }
        if (basicFileAttributes2.isDirectory() && Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0])) {
            return name -> new PathPackResources(name, path, alwaysStable);
        }
        if (basicFileAttributes2.isRegularFile() && path.getFileName().toString().endsWith(".zip") && ((fileSystem = path.getFileSystem()) == FileSystems.getDefault() || fileSystem instanceof LinkFileSystem)) {
            File file = path.toFile();
            return name -> new ResourcePackFile(name, file, alwaysStable);
        }
        a.info("Found non-pack entry '{}', ignoring", (Object)path);
        return null;
    }
}

