/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class AbstractArrowPickupFix
extends DataFix {
    public AbstractArrowPickupFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        return this.fixTypeEverywhereTyped("AbstractArrowPickupFix", schema.getType(DataConverterTypes.q), this::a);
    }

    private Typed<?> a(Typed<?> typed) {
        typed = this.a(typed, "minecraft:arrow", AbstractArrowPickupFix::a);
        typed = this.a(typed, "minecraft:spectral_arrow", AbstractArrowPickupFix::a);
        typed = this.a(typed, "minecraft:trident", AbstractArrowPickupFix::a);
        return typed;
    }

    private static Dynamic<?> a(Dynamic<?> arrowData) {
        if (arrowData.get("pickup").result().isPresent()) {
            return arrowData;
        }
        boolean bl = arrowData.get("player").asBoolean(true);
        return arrowData.set("pickup", arrowData.createByte((byte)(bl ? 1 : 0))).remove("player");
    }

    private Typed<?> a(Typed<?> typed, String choiceName, Function<Dynamic<?>, Dynamic<?>> updater) {
        Type type = this.getInputSchema().getChoiceType(DataConverterTypes.q, choiceName);
        Type type2 = this.getOutputSchema().getChoiceType(DataConverterTypes.q, choiceName);
        return typed.updateTyped(DSL.namedChoice((String)choiceName, (Type)type), type2, t2 -> t2.update(DSL.remainderFinder(), updater));
    }
}

