/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class EffectDurationFix
extends DataFix {
    private static final Set<String> a = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public EffectDurationFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        Type type = this.getInputSchema().getType(DataConverterTypes.m);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.s.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder2 = type.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EffectDurationEntity", schema.getType(DataConverterTypes.q), typed -> typed.update(DSL.remainderFinder(), this::c)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("EffectDurationPlayer", schema.getType(DataConverterTypes.b), typed -> typed.update(DSL.remainderFinder(), this::c)), this.fixTypeEverywhereTyped("EffectDurationItem", type, typed -> {
            Optional optional2;
            Optional optional = typed.getOptional(opticFinder);
            if (optional.filter(a::contains).isPresent() && (optional2 = typed.getOptionalTyped(opticFinder2)).isPresent()) {
                Dynamic dynamic = (Dynamic)((Object)((Object)((Typed)optional2.get()).get(DSL.remainderFinder())));
                Typed typed2 = ((Typed)optional2.get()).set(DSL.remainderFinder(), dynamic.update("CustomPotionEffects", this::b));
                return typed.set(opticFinder2, typed2);
            }
            return typed;
        })});
    }

    private Dynamic<?> a(Dynamic<?> dynamic) {
        return dynamic.update("FactorCalculationData", dynamic2 -> {
            int i2 = dynamic2.get("effect_changed_timestamp").asInt(-1);
            dynamic2 = dynamic2.remove("effect_changed_timestamp");
            int j2 = dynamic.get("Duration").asInt(-1);
            int k2 = i2 - j2;
            return dynamic2.set("ticks_active", dynamic2.createInt(k2));
        });
    }

    private Dynamic<?> b(Dynamic<?> dynamic) {
        return dynamic.createList(dynamic.asStream().map(this::a));
    }

    private Dynamic<?> c(Dynamic<?> dynamic) {
        dynamic = dynamic.update("Effects", this::b);
        dynamic = dynamic.update("ActiveEffects", this::b);
        dynamic = dynamic.update("CustomPotionEffects", this::b);
        return dynamic;
    }
}

