/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class StructuresBecomeConfiguredFix
extends DataFix {
    private static final Map<String, a> a = ImmutableMap.builder().put((Object)"mineshaft", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:pillager_outpost")).put((Object)"mansion", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:desert_pyramid")).put((Object)"igloo", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:igloo")).put((Object)"swamp_hut", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:swamp_hut")).put((Object)"stronghold", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:stronghold")).put((Object)"monument", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:monument")).put((Object)"fortress", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:fortress")).put((Object)"endcity", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:end_city")).put((Object)"buried_treasure", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:bastion_remnant")).build();

    public StructuresBecomeConfiguredFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        Type type2 = this.getInputSchema().getType(DataConverterTypes.c);
        return this.writeFixAndRead("StucturesToConfiguredStructures", type, type2, this::a);
    }

    private Dynamic<?> a(Dynamic<?> dynamic) {
        return dynamic.update("structures", dynamic22 -> dynamic22.update("starts", dynamic2 -> this.a((Dynamic<?>)((Object)((Object)dynamic2)), dynamic)).update("References", dynamic2 -> this.b((Dynamic<?>)((Object)((Object)dynamic2)), dynamic)));
    }

    private Dynamic<?> a(Dynamic<?> dynamic3, Dynamic<?> dynamic22) {
        Map map = (Map)dynamic3.getMapValues().result().get();
        ArrayList list = new ArrayList();
        map.forEach((dynamic, dynamic2) -> {
            if (dynamic2.get("id").asString("INVALID").equals("INVALID")) {
                list.add(dynamic);
            }
        });
        for (Dynamic dynamic32 : list) {
            dynamic3 = dynamic3.remove(dynamic32.asString(""));
        }
        return dynamic3.updateMapValues(pair -> this.a((Pair<Dynamic<?>, Dynamic<?>>)pair, dynamic22));
    }

    private Pair<Dynamic<?>, Dynamic<?>> a(Pair<Dynamic<?>, Dynamic<?>> pair, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = this.c(pair, dynamic);
        return new Pair(dynamic2, ((Dynamic)((Object)pair.getSecond())).set("id", dynamic2));
    }

    private Dynamic<?> b(Dynamic<?> dynamic3, Dynamic<?> dynamic22) {
        Map map = (Map)dynamic3.getMapValues().result().get();
        ArrayList list = new ArrayList();
        map.forEach((dynamic, dynamic2) -> {
            if (dynamic2.asLongStream().count() == 0L) {
                list.add(dynamic);
            }
        });
        for (Dynamic dynamic32 : list) {
            dynamic3 = dynamic3.remove(dynamic32.asString(""));
        }
        return dynamic3.updateMapValues(pair -> this.b((Pair<Dynamic<?>, Dynamic<?>>)pair, dynamic22));
    }

    private Pair<Dynamic<?>, Dynamic<?>> b(Pair<Dynamic<?>, Dynamic<?>> pair, Dynamic<?> dynamic) {
        return pair.mapFirst(dynamic2 -> this.c(pair, dynamic));
    }

    private Dynamic<?> c(Pair<Dynamic<?>, Dynamic<?>> pair, Dynamic<?> dynamic) {
        Optional<String> optional;
        String string = ((Dynamic)((Object)pair.getFirst())).asString("UNKNOWN").toLowerCase(Locale.ROOT);
        a conversion = a.get(string);
        if (conversion == null) {
            throw new IllegalStateException("Found unknown structure: " + string);
        }
        Dynamic dynamic2 = (Dynamic)((Object)pair.getSecond());
        String string2 = conversion.b;
        if (!conversion.a().isEmpty() && (optional = this.a(dynamic, conversion)).isPresent()) {
            string2 = optional.get();
        }
        Dynamic dynamic3 = dynamic2.createString(string2);
        return dynamic3;
    }

    private Optional<String> a(Dynamic<?> dynamic, a conversion) {
        Object2IntArrayMap object2IntArrayMap = new Object2IntArrayMap();
        dynamic.get("sections").asList(Function.identity()).forEach(dynamic2 -> dynamic2.get("biomes").get("palette").asList(Function.identity()).forEach(dynamic -> {
            String string = conversion.a().get(dynamic.asString(""));
            if (string != null) {
                object2IntArrayMap.mergeInt((Object)string, 1, Integer::sum);
            }
        }));
        return object2IntArrayMap.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
    }

    record a(Map<String, String> a, String b) {
        public static a a(String mapping) {
            return new a(Map.of(), mapping);
        }

        public static a a(Map<List<String>, String> biomeMapping, String fallback) {
            return new a(net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(biomeMapping), fallback);
        }

        private static Map<String, String> a(Map<List<String>, String> biomeMapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<List<String>, String> entry : biomeMapping.entrySet()) {
                entry.getKey().forEach(string -> builder.put(string, (Object)((String)entry.getValue())));
            }
            return builder.build();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this, object);
        }
    }
}

