/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger a = LogUtils.getLogger();
    private final Runnable b;

    protected SummaryReporter(Runnable stopCallback) {
        this.b = stopCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void a(@Nullable Path dumpPath) {
        if (dumpPath == null) {
            return;
        }
        this.b.run();
        SummaryReporter.a(() -> "Dumped flight recorder profiling to " + dumpPath);
        try {
            JfrStatsResult jfrStatsResult = JfrStatsParser.a(dumpPath);
        }
        catch (Throwable throwable) {
            SummaryReporter.a(() -> "Failed to parse JFR recording", throwable);
            return;
        }
        try {
            void jfrStatsResult2;
            SummaryReporter.a(((JfrStatsResult)jfrStatsResult2)::b);
            Path path = dumpPath.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)dumpPath.getFileName().toString(), (String)".jfr") + ".json");
            Files.writeString(path, (CharSequence)jfrStatsResult2.b(), StandardOpenOption.CREATE);
            SummaryReporter.a(() -> "Dumped recording summary to " + path);
        }
        catch (Throwable throwable2) {
            SummaryReporter.a(() -> "Failed to output JFR report", throwable2);
        }
    }

    private static void a(Supplier<String> logSupplier) {
        if (LogUtils.isLoggerActive()) {
            a.info(logSupplier.get());
        } else {
            DispenserRegistry.a(logSupplier.get());
        }
    }

    private static void a(Supplier<String> logSupplier, Throwable throwable) {
        if (LogUtils.isLoggerActive()) {
            a.warn(logSupplier.get(), throwable);
        } else {
            DispenserRegistry.a(logSupplier.get());
            throwable.printStackTrace(DispenserRegistry.a);
        }
    }
}

