/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger a = LogUtils.getLogger();
    private static final ThreadFactory b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final IRegistry<WorldDimension> c;
    private final Set<ResourceKey<World>> d;
    private final boolean e;
    private final Convertable.ConversionSession f;
    private final Thread g;
    private final DataFixer h;
    private volatile boolean i = true;
    private volatile boolean j;
    private volatile float k;
    private volatile int l;
    private volatile int m;
    private volatile int n;
    private final Object2FloatMap<ResourceKey<World>> o = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(SystemUtils.k()));
    private volatile IChatBaseComponent p = IChatBaseComponent.c("optimizeWorld.stage.counting");
    public static final Pattern q = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final WorldPersistentData r;

    public WorldUpgrader(Convertable.ConversionSession session, DataFixer dataFixer, IRegistry<WorldDimension> dimensionOptionsRegistry, boolean eraseCache) {
        this.c = dimensionOptionsRegistry;
        this.d = Stream.of(session.dimensionType).map(Registries::a).collect(Collectors.toUnmodifiableSet());
        this.e = eraseCache;
        this.h = dataFixer;
        this.f = session;
        this.r = new WorldPersistentData(this.f.a(World.h).resolve("data").toFile(), dataFixer);
        this.g = b.newThread(this::i);
        this.g.setUncaughtExceptionHandler((thread, throwable) -> {
            a.error("Error upgrading world", throwable);
            this.p = IChatBaseComponent.c("optimizeWorld.stage.failed");
            this.j = true;
        });
        this.g.start();
    }

    public void a() {
        this.i = false;
        try {
            this.g.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void i() {
        this.l = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceKey<World> resourcekey : this.d) {
            List<ChunkCoordIntPair> list = this.b(resourcekey);
            builder.put(resourcekey, list.listIterator());
            this.l += list.size();
        }
        if (this.l == 0) {
            this.j = true;
        } else {
            float f2 = this.l;
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey<World> resourcekey1 : this.d) {
                Path path = this.f.a(resourcekey1);
                builder1.put(resourcekey1, (Object)new IChunkLoader(path.resolve("region"), this.h, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            long i2 = SystemUtils.b();
            this.p = IChatBaseComponent.c("optimizeWorld.stage.upgrading");
            while (this.i) {
                boolean flag = false;
                float f1 = 0.0f;
                for (ResourceKey<World> resourcekey2 : this.d) {
                    ListIterator listiterator = (ListIterator)immutablemap.get(resourcekey2);
                    IChunkLoader ichunkloader = (IChunkLoader)immutablemap1.get(resourcekey2);
                    if (listiterator.hasNext()) {
                        ChunkCoordIntPair chunkcoordintpair = (ChunkCoordIntPair)listiterator.next();
                        boolean flag1 = false;
                        try {
                            NBTTagCompound nbttagcompound = ichunkloader.e(chunkcoordintpair).join().orElse(null);
                            if (nbttagcompound != null) {
                                boolean flag2;
                                int j2 = IChunkLoader.a(nbttagcompound);
                                ChunkGenerator chunkgenerator = this.c.e(Registries.b(resourcekey2)).b();
                                NBTTagCompound nbttagcompound1 = ichunkloader.upgradeChunkTag(Registries.b(resourcekey2), () -> this.r, nbttagcompound, chunkgenerator.b(), chunkcoordintpair, null);
                                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound1.h("xPos"), nbttagcompound1.h("zPos"));
                                if (!chunkcoordintpair1.equals(chunkcoordintpair)) {
                                    a.warn("Chunk {} has invalid position {}", (Object)chunkcoordintpair, (Object)chunkcoordintpair1);
                                }
                                boolean bl = flag2 = j2 < SharedConstants.b().d().c();
                                if (this.e) {
                                    flag2 = flag2 || nbttagcompound1.e("Heightmaps");
                                    nbttagcompound1.r("Heightmaps");
                                    flag2 = flag2 || nbttagcompound1.e("isLightOn");
                                    nbttagcompound1.r("isLightOn");
                                    NBTTagList nbttaglist = nbttagcompound1.c("sections", 10);
                                    for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
                                        NBTTagCompound nbttagcompound2 = nbttaglist.a(k2);
                                        flag2 = flag2 || nbttagcompound2.e("BlockLight");
                                        nbttagcompound2.r("BlockLight");
                                        flag2 = flag2 || nbttagcompound2.e("SkyLight");
                                        nbttagcompound2.r("SkyLight");
                                    }
                                }
                                if (flag2) {
                                    ichunkloader.a(chunkcoordintpair, nbttagcompound1);
                                    flag1 = true;
                                }
                            }
                        }
                        catch (CompletionException | ReportedException reportedexception) {
                            Throwable throwable = reportedexception.getCause();
                            if (!(throwable instanceof IOException)) {
                                throw reportedexception;
                            }
                            a.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)throwable);
                        }
                        catch (IOException e2) {
                            a.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)e2);
                        }
                        if (flag1) {
                            ++this.m;
                        } else {
                            ++this.n;
                        }
                        flag = true;
                    }
                    float f22 = (float)listiterator.nextIndex() / f2;
                    this.o.put(resourcekey2, f22);
                    f1 += f22;
                }
                this.k = f1;
                if (flag) continue;
                this.i = false;
            }
            this.p = IChatBaseComponent.c("optimizeWorld.stage.finished");
            for (IChunkLoader ichunkloader1 : immutablemap1.values()) {
                try {
                    ichunkloader1.close();
                }
                catch (IOException ioexception) {
                    a.error("Error upgrading chunk", (Throwable)ioexception);
                }
            }
            this.r.a();
            i2 = SystemUtils.b() - i2;
            a.info("World optimizaton finished after {} ms", (Object)i2);
            this.j = true;
        }
    }

    private List<ChunkCoordIntPair> b(ResourceKey<World> world) {
        File file = this.f.a(world).toFile();
        File file1 = new File(file, "region");
        File[] afile = file1.listFiles((file2, s2) -> s2.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        File[] afile1 = afile;
        int i2 = afile.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            File file22 = afile1[j2];
            Matcher matcher = q.matcher(file22.getName());
            if (!matcher.matches()) continue;
            int k2 = Integer.parseInt(matcher.group(1)) << 5;
            int l2 = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file22.toPath(), file1.toPath(), true);){
                for (int i1 = 0; i1 < 32; ++i1) {
                    for (int j1 = 0; j1 < 32; ++j1) {
                        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i1 + k2, j1 + l2);
                        if (!regionfile.b(chunkcoordintpair)) continue;
                        list.add(chunkcoordintpair);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean b() {
        return this.j;
    }

    public Set<ResourceKey<World>> c() {
        return this.d;
    }

    public float a(ResourceKey<World> world) {
        return this.o.getFloat(world);
    }

    public float d() {
        return this.k;
    }

    public int e() {
        return this.l;
    }

    public int f() {
        return this.m;
    }

    public int g() {
        return this.n;
    }

    public IChatBaseComponent h() {
        return this.p;
    }
}

