/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int c;
    public final NonNullList<ItemStack> d;
    @Nullable
    private List<IInventoryListener> e;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    @Nullable
    protected InventoryHolder bukkitOwner;
    @Nullable
    private Supplier<? extends InventoryHolder> bukkitOwnerCreator;

    @Override
    public List<ItemStack> getContents() {
        return this.d;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ac_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    @Override
    public InventoryHolder getOwner() {
        if (this.bukkitOwner == null && this.bukkitOwnerCreator != null) {
            this.bukkitOwner = this.bukkitOwnerCreator.get();
        }
        return this.bukkitOwner;
    }

    @Override
    public Location getLocation() {
        InventoryHolder inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return blockInventoryHolder.getBlock().getLocation();
        }
        inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return entity.getLocation();
        }
        return null;
    }

    public InventorySubcontainer(InventorySubcontainer original) {
        this(original.c);
        for (int slot = 0; slot < original.c; ++slot) {
            this.d.set(slot, original.d.get(slot).p());
        }
    }

    public InventorySubcontainer(int size) {
        this(size, null);
    }

    public InventorySubcontainer(Supplier<? extends InventoryHolder> bukkitOwnerCreator, int size) {
        this(size);
        this.bukkitOwnerCreator = bukkitOwnerCreator;
    }

    public InventorySubcontainer(int i2, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.c = i2;
        this.d = NonNullList.a(i2, ItemStack.b);
    }

    public InventorySubcontainer(ItemStack ... items) {
        this.c = items.length;
        this.d = NonNullList.a(ItemStack.b, items);
    }

    public void a(IInventoryListener listener) {
        if (this.e == null) {
            this.e = Lists.newArrayList();
        }
        this.e.add(listener);
    }

    public void b(IInventoryListener listener) {
        if (this.e != null) {
            this.e.remove(listener);
        }
    }

    @Override
    public ItemStack a(int slot) {
        return slot >= 0 && slot < this.d.size() ? this.d.get(slot) : ItemStack.b;
    }

    public List<ItemStack> f() {
        List<ItemStack> list = this.d.stream().filter(itemstack -> !itemstack.b()).collect(Collectors.toList());
        this.a();
        return list;
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemstack = ContainerUtil.a(this.d, slot, amount);
        if (!itemstack.b()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack a(Item item, int count) {
        ItemStack itemstack = new ItemStack(item, 0);
        for (int j2 = this.c - 1; j2 >= 0; --j2) {
            ItemStack itemstack1 = this.a(j2);
            if (!itemstack1.d().equals(item)) continue;
            int k2 = count - itemstack.L();
            ItemStack itemstack2 = itemstack1.a(k2);
            itemstack.g(itemstack2.L());
            if (itemstack.L() == count) break;
        }
        if (!itemstack.b()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack a(ItemStack stack) {
        if (stack.b()) {
            return ItemStack.b;
        }
        ItemStack itemstack1 = stack.p();
        this.d(itemstack1);
        if (itemstack1.b()) {
            return ItemStack.b;
        }
        this.c(itemstack1);
        return itemstack1.b() ? ItemStack.b : itemstack1;
    }

    public boolean b(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemstack1 : this.d) {
            if (!itemstack1.b() && (!ItemStack.c(itemstack1, stack) || itemstack1.L() >= itemstack1.g())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack b(int slot) {
        ItemStack itemstack = this.d.get(slot);
        if (itemstack.b()) {
            return ItemStack.b;
        }
        this.d.set(slot, ItemStack.b);
        return itemstack;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.d.set(slot, stack);
        if (!stack.b() && stack.L() > this.ac_()) {
            stack.f(this.ac_());
        }
        this.e();
    }

    @Override
    public int b() {
        return this.c;
    }

    @Override
    public boolean ab_() {
        ItemStack itemstack;
        Iterator iterator = this.d.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public void e() {
        if (this.e != null) {
            for (IInventoryListener iinventorylistener : this.e) {
                iinventorylistener.a(this);
            }
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    public void a() {
        this.d.clear();
        this.e();
    }

    @Override
    public void a(AutoRecipeStackManager finder) {
        for (ItemStack itemstack : this.d) {
            finder.b(itemstack);
        }
    }

    public String toString() {
        return this.d.stream().filter(itemstack -> !itemstack.b()).collect(Collectors.toList()).toString();
    }

    private void c(ItemStack stack) {
        for (int i2 = 0; i2 < this.c; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!itemstack1.b()) continue;
            this.a(i2, stack.c());
            return;
        }
    }

    private void d(ItemStack stack) {
        for (int i2 = 0; i2 < this.c; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!ItemStack.c(itemstack1, stack)) continue;
            this.a(stack, itemstack1);
            if (!stack.b()) continue;
            return;
        }
    }

    private void a(ItemStack source, ItemStack target) {
        int i2 = Math.min(this.ac_(), target.g());
        int j2 = Math.min(source.L(), i2 - target.L());
        if (j2 > 0) {
            target.g(j2);
            source.h(j2);
            this.e();
        }
    }

    public void a(NBTTagList nbtList) {
        this.a();
        for (int i2 = 0; i2 < nbtList.size(); ++i2) {
            ItemStack itemstack = ItemStack.a(nbtList.a(i2));
            if (itemstack.b()) continue;
            this.a(itemstack);
        }
    }

    public NBTTagList g() {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.b(); ++i2) {
            ItemStack itemstack = this.a(i2);
            if (itemstack.b()) continue;
            nbttaglist.add(itemstack.b(new NBTTagCompound()));
        }
        return nbttaglist;
    }
}

