/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class MobEffectList {
    private final Map<AttributeBase, AttributeModifier> a = Maps.newHashMap();
    private final MobEffectInfo b;
    private final int c;
    @Nullable
    private String d;
    private Supplier<MobEffect.a> e = () -> null;

    @Nullable
    public static MobEffectList a(int rawId) {
        return (MobEffectList)BuiltInRegistries.e.a(rawId);
    }

    public static int a(MobEffectList type) {
        return BuiltInRegistries.e.a(type);
    }

    public static int b(@Nullable MobEffectList type) {
        return BuiltInRegistries.e.a(type);
    }

    protected MobEffectList(MobEffectInfo category, int color) {
        this.b = category;
        this.c = color;
    }

    public Optional<MobEffect.a> b() {
        return Optional.ofNullable(this.e.get());
    }

    public void a(EntityLiving entity, int amplifier) {
        if (this == MobEffects.j) {
            if (entity.er() < entity.eI()) {
                entity.heal(1.0f, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN);
            }
        } else if (this == MobEffects.s) {
            if (entity.er() > 1.0f) {
                entity.a(entity.dJ().poison, 1.0f);
            }
        } else if (this == MobEffects.t) {
            entity.a(entity.dJ().p(), 1.0f);
        } else if (this == MobEffects.q && entity instanceof EntityHuman) {
            ((EntityHuman)entity).causeFoodExhaustion(0.005f * (float)(amplifier + 1), EntityExhaustionEvent.ExhaustionReason.HUNGER_EFFECT);
        } else if (this == MobEffects.w && entity instanceof EntityHuman) {
            if (!entity.dI().B) {
                EntityHuman entityhuman = (EntityHuman)entity;
                int oldFoodLevel = entityhuman.fX().a;
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityhuman, amplifier + 1 + oldFoodLevel);
                if (!event.isCancelled()) {
                    entityhuman.fX().a(event.getFoodLevel() - oldFoodLevel, 1.0f);
                }
                ((CraftPlayer)entityhuman.getBukkitEntity()).sendHealthUpdate();
            }
        } else if (!(this == MobEffects.f && !entity.eq() || this == MobEffects.g && entity.eq())) {
            if (this == MobEffects.g && !entity.eq() || this == MobEffects.f && entity.eq()) {
                entity.a(entity.dJ().o(), (float)(6 << amplifier));
            }
        } else {
            entity.heal(Math.max(4 << amplifier, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public void a(@Nullable Entity source, @Nullable Entity attacker, EntityLiving target, int amplifier, double proximity) {
        if (!(this == MobEffects.f && !target.eq() || this == MobEffects.g && target.eq())) {
            if (!(this == MobEffects.g && !target.eq() || this == MobEffects.f && target.eq())) {
                this.a(target, amplifier);
            } else {
                int j2 = (int)(proximity * (double)(6 << amplifier) + 0.5);
                if (source == null) {
                    target.a(target.dJ().o(), (float)j2);
                } else {
                    target.a(target.dJ().c(source, attacker), (float)j2);
                }
            }
        } else {
            int j3 = (int)(proximity * (double)(4 << amplifier) + 0.5);
            target.heal(j3, EntityRegainHealthEvent.RegainReason.MAGIC);
        }
    }

    public boolean a(int duration, int amplifier) {
        if (this == MobEffects.j) {
            int k2 = 50 >> amplifier;
            return k2 > 0 ? duration % k2 == 0 : true;
        }
        if (this == MobEffects.s) {
            int k3 = 25 >> amplifier;
            return k3 > 0 ? duration % k3 == 0 : true;
        }
        if (this == MobEffects.t) {
            int k4 = 40 >> amplifier;
            return k4 > 0 ? duration % k4 == 0 : true;
        }
        return this == MobEffects.q;
    }

    public boolean a() {
        return false;
    }

    protected String c() {
        if (this.d == null) {
            this.d = SystemUtils.a("effect", BuiltInRegistries.e.b(this));
        }
        return this.d;
    }

    public String d() {
        return this.c();
    }

    public IChatBaseComponent e() {
        return IChatBaseComponent.c(this.d());
    }

    public MobEffectInfo f() {
        return this.b;
    }

    public int g() {
        return this.c;
    }

    public MobEffectList a(AttributeBase attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this::d, amount, operation);
        this.a.put(attribute, attributemodifier);
        return this;
    }

    public MobEffectList a(Supplier<MobEffect.a> factorCalculationDataSupplier) {
        this.e = factorCalculationDataSupplier;
        return this;
    }

    public Map<AttributeBase, AttributeModifier> h() {
        return this.a;
    }

    public void a(EntityLiving entity, AttributeMapBase attributes, int amplifier) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributes.a(entry.getKey());
            if (attributemodifiable == null) continue;
            attributemodifiable.d(entry.getValue());
        }
    }

    public void b(EntityLiving entity, AttributeMapBase attributes, int amplifier) {
        for (Map.Entry<AttributeBase, AttributeModifier> entry : this.a.entrySet()) {
            AttributeModifiable attributemodifiable = attributes.a(entry.getKey());
            if (attributemodifiable == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            attributemodifiable.d(attributemodifier);
            attributemodifiable.c(new AttributeModifier(attributemodifier.a(), this.d() + " " + amplifier, this.a(amplifier, attributemodifier), attributemodifier.c()));
        }
    }

    public double a(int amplifier, AttributeModifier modifier) {
        return modifier.d() * (double)(amplifier + 1);
    }

    public boolean i() {
        return this.b == MobEffectInfo.a;
    }
}

