/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    public static final int b = -1;
    private static final DataWatcherObject<Integer> p = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> r = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Vector3f> s = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Quaternionf> t = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Quaternionf> u = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Byte> aD = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aE = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aF = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aG = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aH = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aI = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aJ = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aK = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aL = IntSet.of((int[])new int[]{r.a(), s.a(), t.a(), u.a(), aD.a(), aE.a(), aG.a(), aH.a()});
    private static final float aM = 0.0f;
    private static final float aN = 1.0f;
    private static final int aO = -1;
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private final Quaternionf aP = new Quaternionf();
    private long aQ = Integer.MIN_VALUE;
    private int aR;
    private float aS;
    private AxisAlignedBB aT;
    protected boolean n;
    private boolean aU;
    private boolean aV;
    @Nullable
    private j aW;

    public Display(EntityTypes<?> type, World world) {
        super(type, world);
        this.ae = true;
        this.as = true;
        this.aT = this.cE();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (aJ.equals(data) || aI.equals(data)) {
            this.A();
        }
        if (p.equals(data)) {
            this.aU = true;
        }
        if (q.equals(data)) {
            this.aV = true;
        }
        if (aL.contains(data.a())) {
            this.n = true;
        }
    }

    public static Transformation a(DataWatcher dataTracker) {
        Vector3f vector3f = dataTracker.b(r);
        Quaternionf quaternionf = dataTracker.b(t);
        Vector3f vector3f1 = dataTracker.b(s);
        Quaternionf quaternionf1 = dataTracker.b(u);
        return new Transformation(vector3f, quaternionf, vector3f1, quaternionf1);
    }

    @Override
    public void l() {
        Entity entity = this.cW();
        if (entity != null && entity.dD()) {
            this.Y();
        }
        if (this.dI().B) {
            if (this.aU) {
                this.aU = false;
                int i2 = this.p();
                this.aQ = this.ag + i2;
            }
            if (this.aV) {
                this.aV = false;
                this.aR = this.o();
            }
            if (this.n) {
                this.n = false;
                boolean flag = this.aR != 0;
                this.aW = flag && this.aW != null ? this.a(this.aW, this.aS) : this.D();
                this.a(flag, this.aS);
            }
        }
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a_() {
        this.am.a(p, 0);
        this.am.a(q, 0);
        this.am.a(r, new Vector3f());
        this.am.a(s, new Vector3f(1.0f, 1.0f, 1.0f));
        this.am.a(u, new Quaternionf());
        this.am.a(t, new Quaternionf());
        this.am.a(aD, BillboardConstraints.a.a());
        this.am.a(aE, -1);
        this.am.a(aF, Float.valueOf(1.0f));
        this.am.a(aG, Float.valueOf(0.0f));
        this.am.a(aH, Float.valueOf(1.0f));
        this.am.a(aI, Float.valueOf(0.0f));
        this.am.a(aJ, Float.valueOf(0.0f));
        this.am.a(aK, -1);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        DataResult dataresult;
        Logger logger;
        if (nbt.e(e)) {
            DataResult dataresult2 = Transformation.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(e));
            logger = o;
            Objects.requireNonNull(logger);
            dataresult2.resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> this.a((Transformation)pair.getFirst()));
        }
        if (nbt.b(c, 99)) {
            int i2 = nbt.h(c);
            this.b(i2);
        }
        if (nbt.b(d, 99)) {
            int i3 = nbt.h(d);
            this.c(i3);
        }
        if (nbt.b(f, 8)) {
            dataresult = BillboardConstraints.e.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(f));
            logger = o;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> this.a((BillboardConstraints)pair.getFirst()));
        }
        if (nbt.b(h, 99)) {
            this.s(nbt.j(h));
        }
        if (nbt.b(i, 99)) {
            this.t(nbt.j(i));
        }
        if (nbt.b(j, 99)) {
            this.u(nbt.j(j));
        }
        if (nbt.b(k, 99)) {
            this.v(nbt.j(k));
        }
        if (nbt.b(l, 99)) {
            this.w(nbt.j(l));
        }
        if (nbt.b(m, 99)) {
            this.d(nbt.h(m));
        }
        if (nbt.b(g, 10)) {
            dataresult = Brightness.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(g));
            logger = o;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> this.a((Brightness)pair.getFirst()));
        } else {
            this.a((Brightness)null);
        }
    }

    public void a(Transformation transformation) {
        this.am.b(r, transformation.d());
        this.am.b(t, transformation.e());
        this.am.b(s, transformation.f());
        this.am.b(u, transformation.g());
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        Transformation.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)Display.a(this.am)).result().ifPresent(nbtbase -> nbt.a(e, (NBTBase)nbtbase));
        BillboardConstraints.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.q()).result().ifPresent(nbtbase -> nbt.a(f, (NBTBase)nbtbase));
        nbt.a(c, this.o());
        nbt.a(h, this.t());
        nbt.a(i, this.v());
        nbt.a(j, this.w());
        nbt.a(k, this.x());
        nbt.a(l, this.z());
        nbt.a(m, this.y());
        Brightness brightness = this.r();
        if (brightness != null) {
            Brightness.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)brightness).result().ifPresent(nbtbase -> nbt.a(g, (NBTBase)nbtbase));
        }
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public AxisAlignedBB j_() {
        return this.aT;
    }

    @Override
    public EnumPistonReaction l_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean c_() {
        return true;
    }

    public Quaternionf j() {
        return this.aP;
    }

    @Nullable
    public j k() {
        return this.aW;
    }

    public void b(int interpolationDuration) {
        this.am.b(q, interpolationDuration);
    }

    public int o() {
        return this.am.b(q);
    }

    public void c(int startInterpolation) {
        this.am.a(p, startInterpolation, true);
    }

    public int p() {
        return this.am.b(p);
    }

    public void a(BillboardConstraints billboardMode) {
        this.am.b(aD, billboardMode.a());
    }

    public BillboardConstraints q() {
        return BillboardConstraints.f.apply(this.am.b(aD).byteValue());
    }

    public void a(@Nullable Brightness brightness) {
        this.am.b(aE, brightness != null ? brightness.a() : -1);
    }

    @Nullable
    public Brightness r() {
        int i2 = this.am.b(aE);
        return i2 != -1 ? Brightness.a(i2) : null;
    }

    private int s() {
        return this.am.b(aE);
    }

    public void s(float viewRange) {
        this.am.b(aF, Float.valueOf(viewRange));
    }

    public float t() {
        return this.am.b(aF).floatValue();
    }

    public void t(float shadowRadius) {
        this.am.b(aG, Float.valueOf(shadowRadius));
    }

    public float v() {
        return this.am.b(aG).floatValue();
    }

    public void u(float shadowStrength) {
        this.am.b(aH, Float.valueOf(shadowStrength));
    }

    public float w() {
        return this.am.b(aH).floatValue();
    }

    public void v(float width) {
        this.am.b(aI, Float.valueOf(width));
    }

    public float x() {
        return this.am.b(aI).floatValue();
    }

    public void w(float height) {
        this.am.b(aJ, Float.valueOf(height));
    }

    public int y() {
        return this.am.b(aK);
    }

    public void d(int glowColorOverride) {
        this.am.b(aK, glowColorOverride);
    }

    public float a(float delta) {
        float f3;
        int i2 = this.aR;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f1 = (long)this.ag - this.aQ;
        float f2 = f1 + delta;
        this.aS = f3 = MathHelper.a(MathHelper.g(f2, 0.0f, i2), 0.0f, 1.0f);
        return f3;
    }

    public float z() {
        return this.am.b(aJ).floatValue();
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.A();
    }

    private void A() {
        float f2 = this.x();
        float f1 = this.z();
        if (f2 != 0.0f && f1 != 0.0f) {
            this.as = false;
            float f22 = f2 / 2.0f;
            double d0 = this.dn();
            double d1 = this.dp();
            double d2 = this.dt();
            this.aT = new AxisAlignedBB(d0 - (double)f22, d1, d2 - (double)f22, d0 + (double)f22, d1 + (double)f1, d2 + (double)f22);
        } else {
            this.as = true;
        }
    }

    @Override
    public void b_(float pitch) {
        super.b_(pitch);
        this.C();
    }

    @Override
    public void a_(float yaw) {
        super.a_(yaw);
        this.C();
    }

    private void C() {
        this.aP.rotationYXZ((float)(-Math.PI) / 180 * this.dy(), (float)Math.PI / 180 * this.dA(), 0.0f);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.t() * 64.0 * Display.cx());
    }

    @Override
    public int k_() {
        int i2 = this.y();
        return i2 != -1 ? i2 : super.k_();
    }

    private j D() {
        return new j(GenericInterpolator.constant(Display.a(this.am)), this.q(), this.s(), FloatInterpolator.constant(this.v()), FloatInterpolator.constant(this.w()), this.y());
    }

    private j a(j state, float lerpProgress) {
        Transformation transformation = state.a.get(lerpProgress);
        float f1 = state.d.get(lerpProgress);
        float f2 = state.e.get(lerpProgress);
        return new j(new l(transformation, Display.a(this.am)), this.q(), this.s(), new h(f1, this.v()), new h(f2, this.w()), this.y());
    }

    public record j(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    public static enum BillboardConstraints implements INamable
    {
        a(0, "fixed"),
        b(1, "vertical"),
        c(2, "horizontal"),
        d(3, "center");

        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;

        private BillboardConstraints(byte b0, String s2) {
            this.h = s2;
            this.g = b0;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        static {
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return f2 -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return f1 -> value;
        }

        public float get(float var1);
    }

    private record l(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float delta) {
            return (double)delta >= 1.0 ? this.b : this.a.a(this.b, delta);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    private record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float delta) {
            return MathHelper.i(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = new SlotAccess(){

            @Override
            public ItemStack a() {
                return this.p();
            }

            @Override
            public boolean a(ItemStack stack) {
                this.a(stack);
                return true;
            }
        };
        @Nullable
        private a t;

        public ItemDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(q, ItemStack.b);
            this.am.a(r, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (q.equals(data) || r.equals(data)) {
                this.n = true;
            }
        }

        public ItemStack p() {
            return this.am.b(q);
        }

        public void a(ItemStack stack) {
            this.am.b(q, stack);
        }

        public void a(ItemDisplayContext transformationMode) {
            this.am.b(r, transformationMode.a());
        }

        public ItemDisplayContext q() {
            return ItemDisplayContext.k.apply(this.am.b(r).byteValue());
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.a(ItemStack.a(nbt.p(o)));
            if (nbt.b(p, 8)) {
                DataResult dataresult = ItemDisplayContext.j.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(p));
                Logger logger = o;
                Objects.requireNonNull(logger);
                dataresult.resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> this.a((ItemDisplayContext)pair.getFirst()));
            }
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, this.p().b(new NBTTagCompound()));
            ItemDisplayContext.j.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.q()).result().ifPresent(nbtbase -> nbt.a(p, (NBTBase)nbtbase));
        }

        @Override
        public SlotAccess a_(int mappedIndex) {
            return mappedIndex == 0 ? this.s : SlotAccess.b;
        }

        @Nullable
        public a o() {
            return this.t;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.t = new a(this.p(), this.q());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        @Nullable
        private a q;

        public BlockDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(p, Blocks.a.n());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (data.equals(p)) {
                this.n = true;
            }
        }

        public IBlockData p() {
            return this.am.b(p);
        }

        public void c(IBlockData state) {
            this.am.b(p, state);
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.c(GameProfileSerializer.a(this.dI().a(Registries.e), nbt.p(o)));
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, GameProfileSerializer.a(this.p()));
        }

        @Nullable
        public a o() {
            return this.q;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.q = new a(this.p());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String aD = "line_width";
        private static final String aE = "text_opacity";
        private static final String aF = "background";
        private static final String aG = "shadow";
        private static final String aH = "see_through";
        private static final String aI = "default_background";
        private static final String aJ = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aK = -1;
        public static final int u = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> aL = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aM = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aN = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aO = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aP = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet aQ = IntSet.of((int[])new int[]{aL.a(), aM.a(), aN.a(), aO.a(), aP.a()});
        @Nullable
        private CachedInfo aR;
        @Nullable
        private e aS;

        public TextDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(aL, IChatBaseComponent.h());
            this.am.a(aM, 200);
            this.am.a(aN, 0x40000000);
            this.am.a(aO, (byte)-1);
            this.am.a(aP, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (aQ.contains(data.a())) {
                this.n = true;
            }
        }

        public IChatBaseComponent p() {
            return this.am.b(aL);
        }

        public void c(IChatBaseComponent text) {
            this.am.b(aL, text);
        }

        public int q() {
            return this.am.b(aM);
        }

        @Override
        private void b(int lineWidth) {
            this.am.b(aM, lineWidth);
        }

        public byte r() {
            return this.am.b(aO);
        }

        public void c(byte textOpacity) {
            this.am.b(aO, textOpacity);
        }

        @Override
        public int s() {
            return this.am.b(aN);
        }

        @Override
        private void c(int background) {
            this.am.b(aN, background);
        }

        public byte t() {
            return this.am.b(aP);
        }

        public void d(byte flags) {
            this.am.b(aP, flags);
        }

        private static byte a(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            return nbt.q(nbtKey) ? (byte)(flags | flag) : flags;
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            if (nbt.b(aD, 99)) {
                this.b(nbt.h(aD));
            }
            if (nbt.b(aE, 99)) {
                this.c(nbt.f(aE));
            }
            if (nbt.b(aF, 99)) {
                this.c(nbt.h(aF));
            }
            byte b0 = TextDisplay.a((byte)0, nbt, aG, (byte)1);
            b0 = TextDisplay.a(b0, nbt, aH, (byte)2);
            b0 = TextDisplay.a(b0, nbt, aI, (byte)4);
            DataResult dataresult = Align.d.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(aJ));
            Logger logger = o;
            Objects.requireNonNull(logger);
            Optional<Align> optional = dataresult.result().map(Pair::getFirst);
            if (optional.isPresent()) {
                b0 = switch (optional.get()) {
                    case Align.a -> b0;
                    case Align.b -> (byte)(b0 | 8);
                    case Align.c -> (byte)(b0 | 0x10);
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            this.d(b0);
            if (nbt.b(o, 8)) {
                String s2 = nbt.l(o);
                try {
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(s2);
                    if (ichatmutablecomponent != null) {
                        CommandListenerWrapper commandlistenerwrapper = this.da().a(2);
                        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(commandlistenerwrapper, ichatmutablecomponent, (Entity)this, 0);
                        this.c(ichatmutablecomponent1);
                    } else {
                        this.c(IChatBaseComponent.h());
                    }
                }
                catch (Exception exception) {
                    o.warn("Failed to parse display entity text {}", (Object)s2, (Object)exception);
                }
            }
        }

        private static void b(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            nbt.a(nbtKey, (flags & flag) != 0);
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, IChatBaseComponent.ChatSerializer.a(this.p()));
            nbt.a(aD, this.q());
            nbt.a(aF, this.s());
            nbt.a(aE, this.r());
            byte b0 = this.t();
            TextDisplay.b(b0, nbt, aG, (byte)1);
            TextDisplay.b(b0, nbt, aH, (byte)2);
            TextDisplay.b(b0, nbt, aI, (byte)4);
            Align.d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)TextDisplay.a(b0)).result().ifPresent(nbtbase -> nbt.a(aJ, (NBTBase)nbtbase));
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.aS = shouldLerp && this.aS != null ? this.a(this.aS, lerpProgress) : this.v();
            this.aR = null;
        }

        @Nullable
        public e o() {
            return this.aS;
        }

        private e v() {
            return new e(this.p(), this.q(), IntInterpolator.constant(this.r()), IntInterpolator.constant(this.s()), this.t());
        }

        private e a(e data, float lerpProgress) {
            int i2 = data.d.get(lerpProgress);
            int j2 = data.c.get(lerpProgress);
            return new e(this.p(), this.q(), new i(j2, this.r()), new ColorInterpolator(i2, this.s()), this.t());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aR == null) {
                this.aR = this.aS != null ? splitter.split(this.aS.a(), this.aS.b()) : new CachedInfo(List.of(), 0);
            }
            return this.aR;
        }

        public static Align a(byte flags) {
            return (flags & 8) != 0 ? Align.b : ((flags & 0x10) != 0 ? Align.c : Align.a);
        }

        public static enum Align implements INamable
        {
            a("center"),
            b("left"),
            c("right");

            public static final Codec<Align> d;
            private final String e;

            private Align(String s2) {
                this.e = s2;
            }

            @Override
            public String c() {
                return this.e;
            }

            static {
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return f2 -> value;
        }

        public int get(float var1);
    }

    private record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return MathHelper.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    private record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return ColorUtil.b.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }
}

