/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftVector;
import org.bukkit.craftbukkit.v1_20_R1.util.UnsafeList;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.TrackingRange;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ElytraAeronauticsHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener {
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public PaperLootableInventoryData lootableData;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    @Nullable
    public PlayerChunkMap.EntityTracker tracker;
    @javax.annotation.Nullable
    public Throwable addedToWorldStack;
    private static final Logger c = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final AtomicInteger d = new AtomicInteger();
    private static final List<ItemStack> e = Collections.emptyList();
    public static final int x = 60;
    public static final int y = 300;
    public static final int z = 1024;
    public static final float A = 0.2f;
    public static final double B = 0.500001;
    public static final double C = 0.999999;
    public static final float D = 0.11111111f;
    public static final int E = 140;
    public static final int F = 40;
    private static final AxisAlignedBB k = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double l = 0.014;
    private static final double m = 0.007;
    private static final double n = 0.0023333333333333335;
    public static final String G = "UUID";
    private static double o = 1.0;
    private final EntityTypes<?> p;
    private int q;
    public boolean H;
    public ImmutableList<Entity> r;
    protected int I;
    @javax.annotation.Nullable
    private Entity s;
    private net.minecraft.world.level.World t;
    public double J;
    public double K;
    public double L;
    private Vec3D u;
    public BlockPosition aD;
    private ChunkCoordIntPair aE;
    private Vec3D aF;
    private float aG;
    private float aH;
    public float M;
    public float N;
    private AxisAlignedBB aI;
    private boolean boundingBoxChanged = false;
    public boolean aJ;
    public boolean O;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    protected Vec3D T;
    @javax.annotation.Nullable
    private RemovalReason aK;
    public static final float U = 0.6f;
    public static final float V = 1.8f;
    public float W;
    public float X;
    public float Y;
    public float Z;
    public float aa;
    private float aL = 1.0f;
    public double ab;
    public double ac;
    public double ad;
    private float aM;
    public boolean ae;
    protected final RandomSource af;
    public int ag;
    private int aN;
    public boolean ah;
    protected Object2DoubleMap<TagKey<FluidType>> ai;
    protected boolean aj;
    private final Set<TagKey<FluidType>> aO;
    public int ak;
    protected boolean al = true;
    protected final DataWatcher am;
    protected static final DataWatcherObject<Byte> an = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int ao = 0;
    private static final int aP = 1;
    private static final int aQ = 3;
    private static final int aR = 4;
    private static final int aS = 5;
    protected static final int ap = 6;
    protected static final int aq = 7;
    private static final DataWatcherObject<Integer> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aW = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aX = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> ar = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    private static final DataWatcherObject<Integer> aY = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aZ;
    private final VecDeltaCodec ba;
    public boolean as;
    public boolean at;
    public int bb;
    public boolean au;
    protected int av;
    protected BlockPosition aw;
    private boolean bc;
    protected UUID ax;
    protected String ay;
    private boolean bd;
    private final Set<String> be;
    private final double[] bf;
    private long bg;
    private EntitySize bh;
    private float bi;
    public boolean az;
    public boolean aA;
    public boolean aB;
    public Optional<BlockPosition> aC;
    private boolean bj = false;
    private float bk;
    private int bl;
    public boolean bm;
    @javax.annotation.Nullable
    private IBlockData bn = null;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @javax.annotation.Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive = false;
    public boolean fromNetherPortal;
    protected int numCollisions = 0;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean collidingWithWorldBorder;
    private NBTTagCompound leavesData = new NBTTagCompound();
    public boolean fixedPose = false;
    private final boolean hardCollides = this instanceof EntityBoat || this instanceof EntityShulker || this instanceof EntityMinecartAbstract || this.shouldHardCollide();
    private static final Map<Class<? extends Entity>, Boolean> cachedOverrides = Collections.synchronizedMap(new WeakHashMap());
    public FullChunkStatus chunkStatus;
    public int sectionX = Integer.MIN_VALUE;
    public int sectionY = Integer.MIN_VALUE;
    public int sectionZ = Integer.MIN_VALUE;
    public boolean updatingSectionStatus = false;
    final TrackingRange.TrackingRangeType trackingRangeType = TrackingRange.getTrackingRangeType(this);
    public boolean isLegacyTrackingEntity = false;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.t.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.aG;
    }

    public boolean isChunkLoaded() {
        return this.t.b((int)Math.floor(this.dn()) >> 4, (int)Math.floor(this.dt()) >> 4);
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.bh.a(x2, y2, z2);
    }

    protected boolean shouldHardCollide() {
        return false;
    }

    public final boolean hardCollides() {
        return this.hardCollides;
    }

    public final void setLegacyTrackingEntity(boolean isLegacyTrackingEntity) {
        this.isLegacyTrackingEntity = isLegacyTrackingEntity;
    }

    private TrackingRange.TrackingRangeType getFurthestEntity(Entity entity, PlayerChunkMap chunkMap, TrackingRange.TrackingRangeType type, int range) {
        List<Entity> passengers = entity.cN();
        int size = passengers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Entity passenger = passengers.get(i2);
            TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
            int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
            if (passengerRange > range) {
                type = passengerType;
                range = passengerRange;
            }
            type = this.getFurthestEntity(passenger, chunkMap, type, range);
        }
        return type;
    }

    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInTrackRange() {
        if (this.r.isEmpty()) {
            return ((WorldServer)this.t).k().a.playerEntityTrackerTrackMaps[this.trackingRangeType.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
        }
        PlayerChunkMap chunkMap = ((WorldServer)this.t).k().a;
        TrackingRange.TrackingRangeType type = this.trackingRangeType;
        int range = chunkMap.getEntityTrackerRange(type.ordinal());
        if (LeavesConfig.removeGetNearPlayerStreams) {
            type = this.getFurthestEntity(this, chunkMap, type, range);
        } else {
            Iterable<Entity> passengers = this.cR();
            for (Entity passenger : passengers) {
                TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
                int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
                if (passengerRange <= range) continue;
                type = passengerType;
                range = passengerRange;
            }
        }
        return chunkMap.playerEntityTrackerTrackMaps[type.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World world) {
        this.q = d.incrementAndGet();
        this.r = ImmutableList.of();
        this.aF = Vec3D.b;
        this.aI = k;
        this.T = Vec3D.b;
        this.af = LeavesConfig.useVanillaRandom ? RandomSource.a() : SHARED_RANDOM;
        this.aN = -this.cZ();
        this.ai = new Object2DoubleArrayMap(2);
        this.aO = new HashSet<TagKey<FluidType>>();
        this.aZ = EntityInLevelCallback.a;
        this.ba = new VecDeltaCodec();
        this.ax = MathHelper.a(this.af);
        this.ay = this.ax.toString();
        this.be = Sets.newHashSet();
        this.bf = new double[]{0.0, 0.0, 0.0};
        this.aC = Optional.empty();
        this.p = type;
        this.t = world;
        this.bh = type.n();
        this.u = Vec3D.b;
        this.aD = BlockPosition.b;
        this.aE = ChunkCoordIntPair.b;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        this.am = new DataWatcher(this);
        this.am.a(an, (byte)0);
        this.am.a(aT, this.ce());
        this.am.a(aV, false);
        this.am.a(aU, Optional.empty());
        this.am.a(aW, false);
        this.am.a(aX, false);
        this.am.a(ar, EntityPose.a);
        this.am.a(aY, 0);
        this.a_();
        this.aj().registrationLocked = true;
        this.e(0.0, 0.0, 0.0);
        this.bi = this.a(EntityPose.a, this.bh);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape = state.b((IBlockAccess)this.dI(), pos, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a((double)pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cE()), OperatorBoolean.i);
    }

    public int k_() {
        ScoreboardTeamBase scoreboardteambase = this.cd();
        return scoreboardteambase != null && scoreboardteambase.n().f() != null ? scoreboardteambase.n().f() : 0xFFFFFF;
    }

    public boolean G_() {
        return false;
    }

    public final void ac() {
        if (this.bN()) {
            this.bz();
        }
        if (this.bM()) {
            this.Y();
        }
    }

    public void f(double x2, double y2, double z2) {
        this.ba.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec ad() {
        return this.ba;
    }

    public EntityTypes<?> ae() {
        return this.p;
    }

    @Override
    public int af() {
        return this.q;
    }

    public void e(int id) {
        this.q = id;
    }

    public Set<String> ag() {
        return this.be;
    }

    public boolean a(String tag) {
        return this.be.size() >= 1024 ? false : this.be.add(tag);
    }

    public boolean b(String tag) {
        return this.be.remove(tag);
    }

    public void ah() {
        this.a(RemovalReason.a);
        this.a(GameEvent.p);
    }

    public final void ai() {
        this.a(RemovalReason.b);
    }

    protected abstract void a_();

    public DataWatcher aj() {
        return this.am;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).q == this.q : false;
    }

    public int hashCode() {
        return this.q;
    }

    public void a(RemovalReason reason) {
        this.b(reason);
    }

    public void ak() {
    }

    public void b(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.al()) {
            return;
        }
        this.t.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        this.am.b(ar, pose);
    }

    public EntityPose al() {
        return this.am.b(ar);
    }

    public boolean c(EntityPose pose) {
        return this.al() == pose;
    }

    public boolean a(Entity entity, double radius) {
        return this.dg().a((IPosition)entity.dg(), radius);
    }

    public boolean a(Entity entity, double horizontalRadius, double verticalRadius) {
        double d2 = entity.dn() - this.dn();
        double d3 = entity.dp() - this.dp();
        double d4 = entity.dt() - this.dt();
        return MathHelper.e(d2, d4) < MathHelper.k(horizontalRadius) && MathHelper.k(d3) < MathHelper.k(verticalRadius);
    }

    public void a(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(this.cv() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(this.cv() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.a_(yaw % 360.0f);
        this.b_(pitch % 360.0f);
    }

    public final void a(Vec3D pos) {
        this.e(pos.a(), pos.b(), pos.c());
    }

    public void e(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected AxisAlignedBB am() {
        return this.bh.a(this.u);
    }

    protected void an() {
        this.e(this.u.c, this.u.d, this.u.e);
    }

    public void b(double cursorDeltaX, double cursorDeltaY) {
        float f2 = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.b_(this.dA() + f2);
        this.a_(this.dy() + f1);
        this.b_(MathHelper.a(this.dA(), -90.0f, 90.0f));
        this.N += f2;
        this.M += f1;
        this.N = MathHelper.a(this.N, -90.0f, 90.0f);
        if (this.s != null) {
            this.s.j(this);
        }
    }

    public void l() {
        this.ao();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bs()) {
            this.bG();
        }
    }

    public void ao() {
        Entity entity;
        this.dI().ad().a("entityBaseTick");
        if (this.al && (entity = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)((Object)entity);
            neutralMob.tickInitialPersistentAnger(this.t);
        }
        this.bn = null;
        if (this.bM() && this.cW().dD()) {
            this.Y();
        }
        if (this.I > 0) {
            --this.I;
        }
        this.W = this.X;
        this.N = this.dA();
        this.M = this.dy();
        if (this instanceof EntityPlayer) {
            this.bG();
        }
        if (this.bg()) {
            this.bh();
        }
        this.aA = this.az;
        this.az = false;
        this.bb();
        this.q();
        this.ba();
        if (this.dI().B) {
            this.aw();
        } else if (this.aN > 0) {
            if (this.aU()) {
                this.h(this.aN - 4);
                if (this.aN < 0) {
                    this.aw();
                }
            } else {
                if (this.aN % 20 == 0 && !this.bi()) {
                    this.a(this.dJ().c(), 1.0f);
                }
                this.h(this.aN - 1);
            }
            if (this.cg() > 0 && !this.freezeLocked) {
                this.k(0);
                this.dI().a((EntityHuman)null, 1009, this.aD, 1);
            }
        }
        if (this.bi()) {
            this.au();
            this.aa *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.ap();
        if (!this.dI().B) {
            this.a_(this.aN > 0);
        }
        this.al = false;
        this.dI().ad().c();
    }

    public void a_(boolean onFire) {
        this.b(0, onFire || this.bm);
    }

    public void ap() {
        block3: {
            block2: {
                if (this.dp() < (double)(this.t.C_() - 64)) break block2;
                if (this.t.getWorld().getEnvironment() != World.Environment.NETHER || !this.t.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dp() >= (double)v2)) break block3;
                Entity entity = this;
                if (!(entity instanceof EntityHuman)) break block2;
                EntityHuman player = (EntityHuman)entity;
                if (player.fO().a) break block3;
            }
            this.ax();
        }
    }

    public void aq() {
        this.bb = this.bH();
    }

    public void f(int portalCooldown) {
        this.bb = portalCooldown;
    }

    public int ar() {
        return this.bb;
    }

    public boolean as() {
        return this.bb > 0;
    }

    protected void H() {
        if (this.as()) {
            --this.bb;
        }
    }

    public int at() {
        return 0;
    }

    public void au() {
        if (!this.aU()) {
            if (this instanceof EntityLiving && this.aN <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.t, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.t.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.setSecondsOnFire(combustEvent.getDuration(), false);
                }
            } else {
                this.setSecondsOnFire(15, false);
            }
            CraftBlock craftBlock = CraftEventFactory.blockDamage = this.lastLavaContact == null ? null : CraftBlock.at(this.t, this.lastLavaContact);
            if (this.a(this.dJ().d(), 4.0f)) {
                this.a(SoundEffects.iT, 0.4f, 2.0f + this.af.i() * 0.4f);
            }
            CraftEventFactory.blockDamage = null;
        }
    }

    public void g(int seconds) {
        this.setSecondsOnFire(seconds, true);
    }

    public void setSecondsOnFire(int i2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDuration();
        }
        int j2 = i2 * 20;
        if (this instanceof EntityLiving) {
            j2 = EnchantmentProtection.a((EntityLiving)this, j2);
        }
        if (this.aN < j2) {
            this.h(j2);
        }
    }

    public void h(int fireTicks) {
        this.aN = fireTicks;
    }

    public int av() {
        return this.aN;
    }

    public void aw() {
        this.h(0);
    }

    protected void ax() {
        this.ai();
    }

    public boolean g(double offsetX, double offsetY, double offsetZ) {
        return this.b(this.cE().d(offsetX, offsetY, offsetZ));
    }

    private boolean b(AxisAlignedBB box) {
        return this.dI().a(this, box) && !this.dI().d(box);
    }

    public void c(boolean onGround) {
        this.aJ = onGround;
        this.b(onGround, (Vec3D)null);
    }

    public void a(boolean onGround, Vec3D movement) {
        this.aJ = onGround;
        this.b(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.aC.isPresent() && this.aC.get().equals(pos);
    }

    protected void b(boolean onGround, @javax.annotation.Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB axisalignedbb = this.cE();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.t.f(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bj) {
                if (movement != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-movement.c, 0.0, -movement.e);
                    optional = this.t.f(this, axisalignedbb2);
                    this.aC = optional;
                }
            } else {
                this.aC = optional;
            }
            this.bj = optional.isEmpty();
        } else {
            this.bj = false;
            if (this.aC.isPresent()) {
                this.aC = Optional.empty();
            }
        }
    }

    public boolean ay() {
        return this.aJ;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (LeavesConfig.skipEntityMoveIfMovementIsZero && !this.boundingBoxChanged && movement.equals(Vec3D.b)) {
            return;
        }
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dn();
            this.moveStartY = this.dp();
            this.moveStartZ = this.dt();
            this.moveVector = movement;
        }
        try {
            if (this.ae) {
                this.e(this.dn() + movement.c, this.dp() + movement.d, this.dt() + movement.e);
            } else {
                Entity entity;
                this.aB = this.bL();
                if (movementType == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.c(movement)).equals(Vec3D.b)) {
                        return;
                    }
                }
                if (LeavesConfig.elytraAeronauticsNoChunk && (entity = this) instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    if (movementType == EnumMoveType.b && player.fr()) {
                        ElytraAeronauticsHelper.flightBehaviour(player, movement);
                    }
                }
                this.dI().ad().a("move");
                if (this.T.g() > 1.0E-7) {
                    movement = movement.h(this.T);
                    this.T = Vec3D.b;
                    this.f(Vec3D.b);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && !(this instanceof EntityMinecartAbstract) && movement == this.dl() && movementType == EnumMoveType.a) {
                    this.f(Vec3D.b);
                    this.t.ad().c();
                    return;
                }
                Vec3D vec3d1 = this.h(movement = this.a(movement, movementType));
                double d0 = vec3d1.g();
                if (d0 > 1.0E-7) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    if (this.aa != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.dI().a(new RayTrace(this.dg(), this.dg().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.n();
                    }
                    this.e(this.dn() + vec3d1.c, this.dp() + vec3d1.d, this.dt() + vec3d1.e);
                }
                this.dI().ad().c();
                this.dI().ad().a("rest");
                boolean flag = !MathHelper.b(movement.c, vec3d1.c);
                boolean flag1 = !MathHelper.b(movement.e, vec3d1.e);
                this.O = flag || flag1;
                this.P = movement.d != vec3d1.d;
                this.Q = this.P && movement.d < 0.0;
                this.R = this.O ? this.b(vec3d1) : false;
                this.a(this.Q, vec3d1);
                BlockPosition blockposition = this.aD();
                IBlockData iblockdata = this.dI().a_(blockposition);
                this.a(vec3d1.d, this.ay(), iblockdata, blockposition);
                if (this.dD()) {
                    this.dI().ad().c();
                } else {
                    MovementEmission entity_movementemission;
                    if (this.O) {
                        Vec3D vec3d2 = this.dl();
                        this.o(flag ? 0.0 : vec3d2.c, vec3d2.d, flag1 ? 0.0 : vec3d2.e);
                    }
                    Block block = iblockdata.b();
                    if (movement.d != vec3d1.d) {
                        block.a(this.dI(), this);
                    }
                    if (this.O && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.t.getWorld().getBlockAt(MathHelper.a(this.dn()), MathHelper.a(this.dp()), MathHelper.a(this.dt()));
                        if (movement.c > vec3d1.c) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.c < vec3d1.c) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.e > vec3d1.e) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.e < vec3d1.e) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl, CraftVector.toBukkit(this.moveVector));
                            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if (this.ay()) {
                        block.a(this.dI(), blockposition, iblockdata, this);
                    }
                    if ((entity_movementemission = this.aS()).a() && !this.bM()) {
                        double d1 = vec3d1.c;
                        double d2 = vec3d1.d;
                        double d3 = vec3d1.e;
                        this.Z += (float)(vec3d1.f() * 0.6);
                        BlockPosition blockposition1 = this.aF();
                        IBlockData iblockdata1 = this.dI().a_(blockposition1);
                        boolean flag2 = this.c(iblockdata1);
                        if (!flag2) {
                            d2 = 0.0;
                        }
                        this.X += (float)vec3d1.h() * 0.6f;
                        this.Y += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                        if (this.Y > this.aL && !iblockdata1.i()) {
                            boolean flag3 = blockposition1.equals(blockposition);
                            boolean flag4 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag3, movement);
                            if (!flag3) {
                                flag4 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), movement);
                            }
                            if (flag4) {
                                this.aL = this.aI();
                            } else if (this.aV()) {
                                this.aL = this.aI();
                                if (entity_movementemission.c()) {
                                    this.aN();
                                }
                                if (entity_movementemission.b()) {
                                    this.a(GameEvent.R);
                                }
                            }
                        } else if (iblockdata1.i()) {
                            this.aC();
                        }
                    }
                    this.az();
                    Vec3D oldDeltaMovement = this.dl();
                    if (!LeavesConfig.skipNegligiblePlanarMovementMultiplication || oldDeltaMovement.c < -1.0E-6 || oldDeltaMovement.c > 1.0E-6 || oldDeltaMovement.e < -1.0E-6 || oldDeltaMovement.e > 1.0E-6) {
                        float f2 = this.aH();
                        if (!LeavesConfig.skipNegligiblePlanarMovementMultiplication || (double)f2 < 0.999999 || (double)f2 > 1.000001) {
                            this.f(this.dl().d(f2, 1.0, f2));
                        }
                    }
                    boolean noneMatch = true;
                    AxisAlignedBB fireSearchBox = this.cE().h(1.0E-6);
                    int minX = MathHelper.a(fireSearchBox.a);
                    int minY = MathHelper.a(fireSearchBox.b);
                    int minZ = MathHelper.a(fireSearchBox.c);
                    int maxX = MathHelper.a(fireSearchBox.d);
                    int maxY = MathHelper.a(fireSearchBox.e);
                    int maxZ = MathHelper.a(fireSearchBox.f);
                    block20: for (int fz = minZ; fz <= maxZ; ++fz) {
                        for (int fx = minX; fx <= maxX; ++fx) {
                            for (int fy = minY; fy <= maxY; ++fy) {
                                IBlockData type;
                                Chunk chunk = (Chunk)this.t.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                                if (chunk == null) {
                                    noneMatch = true;
                                    break block20;
                                }
                                if (!noneMatch || !(type = chunk.getBlockStateFinal(fx, fy, fz)).a(TagsBlock.aI) && !type.a(Blocks.H)) continue;
                                noneMatch = false;
                            }
                        }
                    }
                    if (noneMatch) {
                        if (this.aN <= 0) {
                            this.h(-this.cZ());
                        }
                        if (this.aB && (this.az || this.aX())) {
                            this.aA();
                        }
                    }
                    if (this.bL() && (this.az || this.aX())) {
                        this.h(-this.cZ());
                    }
                    this.dI().ad().c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.aN) || state.a(Blocks.qC);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playSound, boolean emitEvent, Vec3D movement) {
        if (state.i()) {
            return false;
        }
        boolean flag2 = this.c(state);
        if ((this.ay() || flag2 || this.bU() && movement.d == 0.0 || this.cc()) && !this.bW()) {
            if (playSound) {
                this.c(pos, state);
            }
            if (emitEvent) {
                this.dI().a(GameEvent.Q, this.dg(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean b(Vec3D adjustedMovement) {
        return false;
    }

    protected void az() {
        try {
            this.aM();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void aA() {
        this.a(SoundEffects.iY, 0.7f, 1.6f + (this.af.i() - this.af.i()) * 0.4f);
    }

    public void aB() {
        if (!this.dI().B && this.aB) {
            this.aA();
        }
        this.aw();
    }

    protected void aC() {
        if (this.aP()) {
            this.aO();
            if (this.aS().b()) {
                this.a(GameEvent.y);
            }
        }
    }

    @Deprecated
    public BlockPosition aD() {
        return this.d(0.2f);
    }

    protected BlockPosition aE() {
        return this.d(0.500001f);
    }

    public BlockPosition aF() {
        return this.d(1.0E-5f);
    }

    protected BlockPosition d(float offset) {
        if (this.aC.isPresent() && this.dI().getChunkIfLoadedImmediately(this.aC.get()) != null) {
            BlockPosition blockposition = this.aC.get();
            if (offset <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dI().a_(blockposition);
            return ((double)offset > 0.5 || !iblockdata.a(TagsBlock.S)) && !iblockdata.a(TagsBlock.L) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.u.d - (double)offset)) : blockposition;
        }
        int i2 = MathHelper.a(this.u.c);
        int j2 = MathHelper.a(this.u.d - (double)offset);
        int k2 = MathHelper.a(this.u.e);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aG() {
        float f2 = this.dI().a_(this.di()).b().j();
        float f1 = this.dI().a_(this.aE()).b().j();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aH() {
        IBlockData iblockdata = this.dI().a_(this.di());
        float f2 = iblockdata.b().i();
        return !iblockdata.a(Blocks.G) && !iblockdata.a(Blocks.nd) ? ((double)f2 == 1.0 ? this.dI().a_(this.aE()).b().i() : f2) : f2;
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D c(Vec3D movement) {
        if (movement.g() <= 1.0E-7) {
            return movement;
        }
        long i2 = this.dI().V();
        if (i2 != this.bg) {
            Arrays.fill(this.bf, 0.0);
            this.bg = i2;
        }
        if (movement.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, movement.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(d0, 0.0, 0.0);
        }
        if (movement.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, movement.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, d0, 0.0);
        }
        if (movement.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, movement.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.b;
    }

    private double a(EnumDirection.EnumAxis axis, double offsetFactor) {
        int i2 = axis.ordinal();
        double d1 = MathHelper.a(offsetFactor + this.bf[i2], -0.51, 0.51);
        offsetFactor = d1 - this.bf[i2];
        this.bf[i2] = d1;
        return offsetFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vec3D h(Vec3D movement) {
        if (movement.c == 0.0 && movement.d == 0.0 && movement.e == 0.0) {
            return movement;
        }
        net.minecraft.world.level.World world = this.t;
        AxisAlignedBB currBoundingBox = this.cE();
        if (CollisionUtil.isEmpty(currBoundingBox)) {
            return movement;
        }
        UnsafeList<AxisAlignedBB> potentialCollisions = CachedLists.getTempCollisionList();
        try {
            double stepHeight = this.dC();
            AxisAlignedBB collisionBox = movement.c == 0.0 && movement.e == 0.0 && movement.d != 0.0 ? (movement.d > 0.0 ? CollisionUtil.cutUpwards(currBoundingBox, movement.d) : CollisionUtil.cutDownwards(currBoundingBox, movement.d)) : (stepHeight > 0.0 && (this.aJ || movement.d < 0.0) && (movement.c != 0.0 || movement.e != 0.0) ? (movement.d <= 0.0 ? CollisionUtil.expandUpwards(currBoundingBox.b(movement.c, movement.d, movement.e), stepHeight) : currBoundingBox.b(movement.c, Math.max(stepHeight, movement.d), movement.e)) : currBoundingBox.b(movement.c, movement.d, movement.e));
            CollisionUtil.getCollisions(world, this, collisionBox, potentialCollisions, false, this.t.paperConfig().chunks.preventMovingIntoUnloadedChunks, false, false, null, null);
            this.collidingWithWorldBorder = CollisionUtil.isCollidingWithBorderEdge(world.w_(), collisionBox);
            if (this.collidingWithWorldBorder) {
                CollisionUtil.addBoxesToIfIntersects(world.w_().c(), collisionBox, potentialCollisions);
            }
            Vec3D limitedMoveVector = CollisionUtil.performCollisions(movement, currBoundingBox, potentialCollisions);
            if (stepHeight > 0.0 && (this.aJ || limitedMoveVector.d != movement.d && movement.d < 0.0) && (limitedMoveVector.c != movement.c || limitedMoveVector.e != movement.e)) {
                Vec3D vec3D;
                Vec3D vec3d4;
                Vec3D vec3d2 = CollisionUtil.performCollisions(new Vec3D(movement.c, stepHeight, movement.e), currBoundingBox, potentialCollisions);
                Vec3D vec3d3 = CollisionUtil.performCollisions(new Vec3D(0.0, stepHeight, 0.0), currBoundingBox.b(movement.c, 0.0, movement.e), potentialCollisions);
                if (vec3d3.d < stepHeight && (vec3d4 = CollisionUtil.performCollisions(new Vec3D(movement.c, 0.0, movement.e), currBoundingBox.c(vec3d3), potentialCollisions).e(vec3d3)).i() > vec3d2.i()) {
                    vec3d2 = vec3d4;
                }
                if (vec3d2.i() > limitedMoveVector.i()) {
                    vec3D = vec3d2.e(CollisionUtil.performCollisions(new Vec3D(0.0, -vec3d2.d + movement.d, 0.0), currBoundingBox.c(vec3d2), potentialCollisions));
                    return vec3D;
                }
                vec3D = limitedMoveVector;
                return vec3D;
            }
            Vec3D vec3D = limitedMoveVector;
            return vec3D;
        }
        finally {
            CachedLists.returnTempCollisionList(potentialCollisions);
        }
    }

    public static Vec3D a(@javax.annotation.Nullable Entity entity, Vec3D movement, AxisAlignedBB entityBoundingBox, net.minecraft.world.level.World world, List<VoxelShape> collisions) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldborder = world.w_();
        boolean bl = flag = entity != null && worldborder.a(entity, entityBoundingBox.b(movement));
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.d(entity, entityBoundingBox.b(movement)));
        return Entity.a(movement, entityBoundingBox, (List<VoxelShape>)builder.build());
    }

    private static Vec3D a(Vec3D movement, AxisAlignedBB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.c;
        double d1 = movement.d;
        double d2 = movement.e;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aI() {
        return (int)this.Y + 1;
    }

    protected SoundEffect aJ() {
        return SoundEffects.jc;
    }

    protected SoundEffect aK() {
        return SoundEffects.jb;
    }

    protected SoundEffect aL() {
        return SoundEffects.jb;
    }

    public SoundEffect getSwimSound0() {
        return this.aJ();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aK();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aL();
    }

    protected void aM() {
        AxisAlignedBB axisalignedbb = this.cE();
        BlockPosition blockposition = BlockPosition.a(axisalignedbb.a + 1.0E-7, axisalignedbb.b + 1.0E-7, axisalignedbb.c + 1.0E-7);
        BlockPosition blockposition1 = BlockPosition.a(axisalignedbb.d - 1.0E-7, axisalignedbb.e - 1.0E-7, axisalignedbb.f - 1.0E-7);
        if (this.dI().a(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.u(); i2 <= blockposition1.u(); ++i2) {
                for (int j2 = blockposition.v(); j2 <= blockposition1.v(); ++j2) {
                    for (int k2 = blockposition.w(); k2 <= blockposition1.w(); ++k2) {
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.dI().a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.dI(), (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.dI(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void a(IBlockData state) {
    }

    public void a(GameEvent event, @javax.annotation.Nullable Entity entity) {
        this.dI().a(entity, event, this.u);
    }

    public void a(GameEvent event) {
        this.a(event, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.k();
        }
    }

    protected void aN() {
        Entity object = this.bN() && this.cL() != null ? this.cL() : this;
        float f2 = object == this ? 0.35f : 0.4f;
        Vec3D vec3d = object.dl();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        this.e(f1);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata = this.dI().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bl) && !iblockdata.a(TagsBlock.bm) ? pos : blockposition1;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundeffecttype = primaryState.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundeffecttype = state.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundeffecttype = state.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.bk) && this.ag >= this.bl + 20;
    }

    private void k() {
        this.bk *= (float)Math.pow(0.997, this.ag - this.bl);
        this.bk = Math.min(1.0f, this.bk + 0.07f);
        float f2 = 0.5f + this.bk * this.af.i() * 1.2f;
        float f1 = 0.1f + this.bk * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bl = this.ag;
    }

    protected void e(float volume) {
        this.a(this.aJ(), volume, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
    }

    protected void aO() {
    }

    protected boolean aP() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.aQ()) {
            this.dI().a((EntityHuman)null, this.dn(), this.dp(), this.dt(), sound, this.cY(), volume, pitch);
        }
    }

    public void a(SoundEffect event) {
        if (!this.aQ()) {
            this.a(event, 1.0f, 1.0f);
        }
    }

    public boolean aQ() {
        return this.am.b(aW);
    }

    public void d(boolean silent) {
        this.am.b(aW, silent);
    }

    public boolean aR() {
        return this.am.b(aX);
    }

    public void e(boolean noGravity) {
        this.am.b(aX, noGravity);
    }

    protected MovementEmission aS() {
        return MovementEmission.d;
    }

    public boolean aT() {
        return false;
    }

    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (onGround) {
            if (this.aa > 0.0f) {
                state.b().a(this.dI(), state, landedPosition, this, this.aa);
                this.dI().a(GameEvent.B, this.u, GameEvent.a.a(this, this.aC.map(blockposition1 -> this.dI().a_((BlockPosition)blockposition1)).orElse(state)));
            }
            this.n();
        } else if (heightDifference < 0.0) {
            this.aa -= (float)heightDifference;
        }
    }

    public boolean aU() {
        return this.ae().d();
    }

    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.p.a(TagsEntity.l)) {
            return false;
        }
        if (this.bN()) {
            for (Entity entity : this.cN()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean aV() {
        return this.ah;
    }

    public boolean o() {
        BlockPosition blockposition = this.di();
        return this.dI().q(blockposition) || this.dI().q(BlockPosition.a((double)blockposition.u(), this.cE().e, (double)blockposition.w()));
    }

    public boolean p() {
        return this.dI().a_(this.di()).a(Blocks.nd);
    }

    public boolean aW() {
        return this.aV() || this.o();
    }

    public boolean aX() {
        return this.aV() || this.o() || this.p();
    }

    public boolean aY() {
        return this.aV() || this.p();
    }

    public boolean aZ() {
        return this.aj && this.aV();
    }

    public void ba() {
        if (this.bW()) {
            this.h(this.bV() && this.aV() && !this.bM());
        } else {
            this.h(this.bV() && this.aZ() && !this.bM() && this.dI().b_(this.aD).a(TagsFluid.a));
        }
    }

    protected boolean bb() {
        this.ai.clear();
        this.bc();
        double d0 = this.dI().x_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.aV() || flag;
    }

    void bc() {
        EntityBoat entityboat;
        Entity entity = this.cW();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aZ()) {
            this.ah = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ah && !this.al) {
                this.bd();
            }
            this.n();
            this.ah = true;
            this.aw();
        } else {
            this.ah = false;
        }
    }

    private void q() {
        EntityBoat entityboat;
        this.aj = this.a(TagsFluid.a);
        this.aO.clear();
        double d0 = this.dr() - 0.1111111119389534;
        Entity entity = this.cW();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aZ() && entityboat.cE().e >= d0 && entityboat.cE().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dn(), d0, this.dt());
        Fluid fluid = this.dI().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.dI(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aO;
            Objects.requireNonNull(this.aO);
            stream.forEach(set::add);
        }
    }

    protected void bd() {
        double d1;
        double d0;
        Entity object = this.bN() && this.cL() != null ? this.cL() : this;
        float f2 = object == this ? 0.2f : 0.9f;
        Vec3D vec3d = object.dl();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aK(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        } else {
            this.a(this.aL(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dp());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dI().a(Particles.e, this.dn() + d0, (double)(f22 + 1.0f), this.dt() + d1, vec3d.c, vec3d.d - this.af.j() * (double)0.2f, vec3d.e);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dI().a(Particles.ag, this.dn() + d0, (double)(f22 + 1.0f), this.dt() + d1, vec3d.c, vec3d.d, vec3d.e);
            ++i2;
        }
        this.a(GameEvent.P);
    }

    @Deprecated
    protected IBlockData be() {
        return this.dI().a_(this.aD());
    }

    public IBlockData bf() {
        return this.dI().a_(this.aF());
    }

    public boolean bg() {
        return this.bV() && !this.aV() && !this.G_() && !this.bU() && !this.bi() && this.bs();
    }

    protected void bh() {
        BlockPosition blockposition = this.aD();
        IBlockData iblockdata = this.dI().a_(blockposition);
        if (iblockdata.l() != EnumRenderType.a) {
            Vec3D vec3d = this.dl();
            BlockPosition blockposition1 = this.di();
            double d0 = this.dn() + (this.af.j() - 0.5) * (double)this.bh.a;
            double d1 = this.dt() + (this.af.j() - 0.5) * (double)this.bh.a;
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dI().a(new ParticleParamBlock(Particles.c, iblockdata), d0, this.dp() + 0.1, d1, vec3d.c * -4.0, 1.5, vec3d.e * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aO.contains(fluidTag);
    }

    public boolean bi() {
        return !this.al && this.ai.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float speed, Vec3D movementInput) {
        Vec3D vec3d1 = Entity.a(movementInput, speed, this.dy());
        this.f(this.dl().e(vec3d1));
    }

    private static Vec3D a(Vec3D movementInput, float speed, float yaw) {
        double d0 = movementInput.g();
        if (d0 < 1.0E-7) {
            return Vec3D.b;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? movementInput.d() : movementInput).a((double)speed);
        float f2 = MathHelper.a(yaw * ((float)Math.PI / 180));
        float f3 = MathHelper.b(yaw * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.c * (double)f3 - vec3d1.e * (double)f2, vec3d1.d, vec3d1.e * (double)f3 + vec3d1.c * (double)f2);
    }

    @Deprecated
    public float bj() {
        if (!LeavesConfig.optimizeSunBurnTick) {
            return this.dI().f(this.dm(), this.ds()) ? this.dI().w(BlockPosition.a(this.dn(), this.dr(), this.dt())) : 0.0f;
        }
        return this.getLightLevelDependentMagicValue(BlockPosition.a(this.dn(), this.dr(), this.dt()));
    }

    @Deprecated
    public float getLightLevelDependentMagicValue(BlockPosition pos) {
        return this.dI().f(this.dm(), this.ds()) ? this.t.w(pos) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.h(x2, y2, z2);
        this.a_(yaw % 360.0f);
        this.b_(MathHelper.a(pitch, -90.0f, 90.0f) % 360.0f);
        this.M = this.dy();
        this.N = this.dA();
        this.n(yaw);
    }

    public void h(double x2, double y2, double z2) {
        double d3 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.J = d3;
        this.K = y2;
        this.L = d4;
        this.e(d3, y2, d4);
        Entity entity = this;
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (player.elytraAeronauticsNoChunk) {
                return;
            }
        }
        if (this.valid) {
            this.t.d((int)Math.floor(this.dn()) >> 4, (int)Math.floor(this.dt()) >> 4);
        }
    }

    public void d(Vec3D pos) {
        this.d(pos.c, pos.d, pos.e);
    }

    public void d(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dy(), this.dA());
    }

    public void a(BlockPosition pos, float yaw, float pitch) {
        this.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, yaw, pitch);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.aF = Vec3D.b;
        } else {
            this.preserveMotion = false;
        }
        this.p(x2, y2, z2);
        this.a_(yaw);
        this.b_(pitch);
        this.bk();
        this.an();
        this.n(yaw);
    }

    public final void bk() {
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        this.J = d0;
        this.K = d1;
        this.L = d2;
        this.ab = d0;
        this.ac = d1;
        this.ad = d2;
        this.M = this.dy();
        this.N = this.dA();
    }

    public float e(Entity entity) {
        float f2 = (float)(this.dn() - entity.dn());
        float f1 = (float)(this.dp() - entity.dp());
        float f22 = (float)(this.dt() - entity.dt());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double x2, double y2, double z2) {
        double d3 = this.dn() - x2;
        double d4 = this.dp() - y2;
        double d5 = this.dt() - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double f(Entity entity) {
        return this.e(entity.dg());
    }

    public double e(Vec3D vector) {
        double d0 = this.dn() - vector.c;
        double d1 = this.dp() - vector.d;
        double d2 = this.dt() - vector.e;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b_(EntityHuman player) {
    }

    public void g(Entity entity) {
        if (!(this.v(entity) || entity.ae || this.ae)) {
            double d1;
            if (this.t.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d0 = entity.dn() - this.dn();
            double d2 = MathHelper.a(d0, d1 = entity.dt() - this.dt());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.bN() && this.bp()) {
                    this.j(-d0, 0.0, -d1);
                }
                if (!entity.bN() && entity.bp()) {
                    entity.j(d0, 0.0, d1);
                }
            }
        }
    }

    public void j(double deltaX, double deltaY, double deltaZ) {
        this.push(deltaX, deltaY, deltaZ, null);
    }

    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(deltaX, deltaY, deltaZ);
        if (pushingEntity == null || new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta).callEvent()) {
            this.f(this.dl().b(delta.getX(), delta.getY(), delta.getZ()));
            this.at = true;
        }
    }

    protected void bl() {
        this.S = true;
    }

    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bl();
        return false;
    }

    public final Vec3D f(float tickDelta) {
        return this.b(this.g(tickDelta), this.h(tickDelta));
    }

    public float g(float tickDelta) {
        return tickDelta == 1.0f ? this.dA() : MathHelper.i(tickDelta, this.N, this.dA());
    }

    public float h(float tickDelta) {
        return tickDelta == 1.0f ? this.dy() : MathHelper.i(tickDelta, this.M, this.dy());
    }

    protected final Vec3D b(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f2);
        float f7 = MathHelper.a(f2);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D i(float tickDelta) {
        return this.c(this.g(tickDelta), this.h(tickDelta));
    }

    protected final Vec3D c(float pitch, float yaw) {
        return this.b(pitch - 90.0f, yaw);
    }

    public final Vec3D bm() {
        return new Vec3D(this.dn(), this.dr(), this.dt());
    }

    public final Vec3D j(float tickDelta) {
        double d0 = MathHelper.d((double)tickDelta, this.J, this.dn());
        double d1 = MathHelper.d((double)tickDelta, this.K, this.dp()) + (double)this.cF();
        double d2 = MathHelper.d((double)tickDelta, this.L, this.dt());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D k(float tickDelta) {
        return this.j(tickDelta);
    }

    public final Vec3D l(float delta) {
        double d0 = MathHelper.d((double)delta, this.J, this.dn());
        double d1 = MathHelper.d((double)delta, this.K, this.dp());
        double d2 = MathHelper.d((double)delta, this.L, this.dt());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3D vec3d = this.j(tickDelta);
        Vec3D vec3d1 = this.f(tickDelta);
        Vec3D vec3d2 = vec3d.b(vec3d1.c * maxDistance, vec3d1.d * maxDistance, vec3d1.e * maxDistance);
        return this.dI().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bn() {
        return this.bs() && this.bo();
    }

    public boolean bo() {
        return false;
    }

    public boolean bp() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bp();
    }

    public void a(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof EntityPlayer) {
            CriterionTriggers.c.a((EntityPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean k(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.dn() - cameraX;
        double d4 = this.dp() - cameraY;
        double d5 = this.dt() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double distance) {
        double d1 = this.cE().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * o) * d1;
    }

    public boolean d(NBTTagCompound nbt) {
        if (this.aK != null && !this.aK.b()) {
            return false;
        }
        String s2 = this.br();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbt.a(v, s2);
        this.f(nbt);
        return true;
    }

    public boolean serializeEntity(NBTTagCompound compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.cN());
        this.r = ImmutableList.of();
        boolean result = this.e(compound);
        this.r = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean e(NBTTagCompound nbt) {
        return this.bM() ? false : this.d(nbt);
    }

    public NBTTagCompound f(NBTTagCompound nbt) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (this.s != null) {
                nbt.a("Pos", this.a(new double[]{this.s.dn(), this.dp(), this.s.dt()}));
            } else {
                nbt.a("Pos", this.a(new double[]{this.dn(), this.dp(), this.dt()}));
            }
            Vec3D vec3d = this.dl();
            nbt.a("Motion", this.a(new double[]{vec3d.c, vec3d.d, vec3d.e}));
            if (Float.isNaN(this.aG)) {
                this.aG = 0.0f;
            }
            if (Float.isNaN(this.aH)) {
                this.aH = 0.0f;
            }
            nbt.a("Rotation", this.a(new float[]{this.dy(), this.dA()}));
            nbt.a("FallDistance", this.aa);
            nbt.a("Fire", (short)this.aN);
            nbt.a("Air", (short)this.cf());
            nbt.a("OnGround", this.ay());
            nbt.a("Invulnerable", this.bc);
            nbt.a("PortalCooldown", this.bb);
            nbt.a(G, this.ct());
            nbt.a("WorldUUIDLeast", ((WorldServer)this.t).getWorld().getUID().getLeastSignificantBits());
            nbt.a("WorldUUIDMost", ((WorldServer)this.t).getWorld().getUID().getMostSignificantBits());
            nbt.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbt.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbt.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbt.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbt.a("Bukkit.MaxAirSupply", this.ce());
            }
            nbt.a("Spigot.ticksLived", this.ag);
            IChatBaseComponent ichatbasecomponent = this.ab();
            if (ichatbasecomponent != null) {
                nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
            }
            if (this.cy()) {
                nbt.a("CustomNameVisible", this.cy());
            }
            if (this.aQ()) {
                nbt.a("Silent", this.aQ());
            }
            if (this.aR()) {
                nbt.a("NoGravity", this.aR());
            }
            if (this.bd) {
                nbt.a("Glowing", true);
            }
            if ((i2 = this.cg()) > 0) {
                nbt.a("TicksFrozen", this.cg());
            }
            if (this.bm) {
                nbt.a("HasVisualFire", this.bm);
            }
            if (!this.be.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.be) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbt.a("Tags", nbttaglist);
            }
            this.b(nbt);
            if (this.bN()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cN()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.d(nbttagcompound1 = new NBTTagCompound())) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbt.a(w, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbt);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.t != null ? this.t.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbt.a("Paper.OriginWorld", originWorld);
                }
                nbt.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                nbt.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbt.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbt.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbt.a("Paper.FreezeLock", true);
            }
            nbt.a("Leaves.Data", this.leavesData);
            return nbt;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbt) {
        try {
            NBTTagList originTag;
            NBTTagList nbttaglist = nbt.c("Pos", 6);
            NBTTagList nbttaglist1 = nbt.c("Motion", 6);
            NBTTagList nbttaglist2 = nbt.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.o(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.p(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.a_(nbttaglist2.i(0));
            this.b_(nbttaglist2.i(1));
            this.bk();
            this.n(this.dy());
            this.o(this.dy());
            this.aa = nbt.j("FallDistance");
            this.aN = nbt.g("Fire");
            if (nbt.e("Air")) {
                this.j(nbt.g("Air"));
            }
            this.aJ = nbt.q("OnGround");
            this.bc = nbt.q("Invulnerable");
            this.bb = nbt.h("PortalCooldown");
            if (nbt.b(G)) {
                this.ax = nbt.a(G);
                this.ay = this.ax.toString();
            }
            if (!Double.isFinite(this.dn()) || !Double.isFinite(this.dp()) || !Double.isFinite(this.dt())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dy()) || !Double.isFinite(this.dA())) throw new IllegalStateException("Entity has invalid rotation");
            this.an();
            this.a(this.dy(), this.dA());
            if (nbt.b("CustomName", 8)) {
                String s2 = nbt.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2));
                }
                catch (Exception exception) {
                    c.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.n(nbt.q("CustomNameVisible"));
            this.d(nbt.q("Silent"));
            this.e(nbt.q("NoGravity"));
            this.i(nbt.q("Glowing"));
            this.k(nbt.h("TicksFrozen"));
            this.bm = nbt.q("HasVisualFire");
            if (nbt.b("Tags", 9)) {
                this.be.clear();
                NBTTagList nbttaglist3 = nbt.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.be.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbt);
            if (this.bq()) {
                this.an();
            }
            if (this instanceof EntityLiving) {
                this.ag = nbt.h("Spigot.ticksLived");
            }
            this.persist = !nbt.e("Bukkit.persist") || nbt.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbt.e("Bukkit.visibleByDefault") || nbt.q("Bukkit.visibleByDefault");
            if (nbt.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.h("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbt.l("world");
                if (nbt.e("WorldUUIDMost") && nbt.e("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbt.i("WorldUUIDMost"), nbt.i("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                ((EntityPlayer)this).a((net.minecraft.world.level.World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.e("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.q("Bukkit.invisible");
                this.j(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.e("Paper.OriginWorld")) {
                    originWorld = nbt.a("Paper.OriginWorld");
                } else if (this.t != null) {
                    originWorld = this.t.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = nbt.q("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.q("Paper.FromNetherPortal");
            if (nbt.e("Paper.SpawnReason")) {
                String spawnReasonName = nbt.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    c.error("Unknown SpawnReason " + spawnReasonName + " for " + this);
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !nbt.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (nbt.e("Paper.FreezeLock")) {
                this.freezeLocked = nbt.q("Paper.FreezeLock");
            }
            if (!nbt.e("Leaves.Data")) return;
            this.leavesData = nbt.p("Leaves.Data");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bq() {
        return true;
    }

    @javax.annotation.Nullable
    public final String br() {
        EntityTypes<?> entitytypes = this.ae();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item) {
        return this.a(item, 0);
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item, int yOffset) {
        return this.a(new ItemStack(item), (float)yOffset);
    }

    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, 0.0f);
    }

    @javax.annotation.Nullable
    public EntityItem a(ItemStack stack, float yOffset) {
        if (stack.b()) {
            return null;
        }
        if (this.dI().B) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asCraftMirror(stack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.dI(), this.dn(), this.dp() + (double)yOffset, this.dt(), stack.p());
        stack.f(0);
        entityitem.o();
        return this.spawnAtLocation(entityitem);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(EntityItem entityitem) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.dI().b(entityitem);
        return entityitem;
    }

    public boolean bs() {
        return !this.dD();
    }

    public boolean bt() {
        if (this.ae) {
            return false;
        }
        float f2 = this.bh.a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bm(), f2, 1.0E-6, f2);
        BlockPosition.MutableBlockPosition blockposition = new BlockPosition.MutableBlockPosition();
        int minX = MathHelper.a(axisalignedbb.a);
        int minY = MathHelper.a(axisalignedbb.b);
        int minZ = MathHelper.a(axisalignedbb.c);
        int maxX = MathHelper.a(axisalignedbb.d);
        int maxY = MathHelper.a(axisalignedbb.e);
        int maxZ = MathHelper.a(axisalignedbb.f);
        for (int fz = minZ; fz <= maxZ; ++fz) {
            for (int fx = minX; fx <= maxX; ++fx) {
                for (int fy = minY; fy <= maxY; ++fy) {
                    Chunk chunk = (Chunk)this.t.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                    if (chunk == null) continue;
                    IBlockData iblockdata = chunk.getBlockStateFinal(fx, fy, fz);
                    blockposition.d(fx, fy, fz);
                    if (iblockdata.i() || !iblockdata.o(this.t, blockposition) || !VoxelShapes.c(iblockdata.k(this.t, blockposition).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()), VoxelShapes.a(axisalignedbb), OperatorBoolean.i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean h(Entity other) {
        return other.bu() && !this.v(other);
    }

    public boolean bu() {
        return false;
    }

    public void bv() {
        this.f(Vec3D.b);
        this.l();
        if (this.bM()) {
            this.cW().i(this);
        }
    }

    public final void i(Entity passenger) {
        this.a(passenger, Entity::e);
    }

    protected void a(Entity passenger, MoveFunction positionUpdater) {
        if (this.u(passenger)) {
            double d0 = this.dp() + this.bx() + passenger.bw();
            positionUpdater.accept(passenger, this.dn(), d0, this.dt());
        }
    }

    public void j(Entity passenger) {
    }

    public double bw() {
        return 0.0;
    }

    public double bx() {
        return (double)this.bh.b * 0.75;
    }

    public boolean k(Entity entity) {
        return this.a(entity, false);
    }

    public boolean by() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force) {
        EntityMountEvent event;
        if (entity == this.s || entity.t != this.t) {
            return false;
        }
        if (!entity.bB()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.s != null) {
            if (entity1.s == this) {
                return false;
            }
            entity1 = entity1.s;
        }
        if (!(force || this.l(entity) && entity.o(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.bM()) {
            this.Y();
        }
        this.b(EntityPose.a);
        this.s = entity;
        this.s.m(this);
        entity.t().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.R.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean l(Entity entity) {
        return !this.bP() && this.I <= 0;
    }

    protected boolean d(EntityPose pose) {
        return this.dI().a(this, this.e(pose).h(1.0E-7));
    }

    public void bz() {
        for (int i2 = this.r.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.r.get(i2)).Y();
        }
    }

    public void bA() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        if (this.s != null) {
            Entity entity = this.s;
            this.s = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.s = entity;
            }
        }
    }

    public void Y() {
        this.bA();
    }

    protected void m(Entity passenger) {
        if (passenger.cW() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.r.isEmpty()) {
            this.r = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.r);
            if (!this.dI().B && passenger instanceof EntityHuman && !(this.cO() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.r = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, passenger);
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.cW() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.r = this.r.size() == 1 && this.r.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.r.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.I = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean o(Entity passenger) {
        return this.r.isEmpty();
    }

    protected boolean bB() {
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    public void a(float yaw, int interpolationSteps) {
        this.n(yaw);
    }

    public float bC() {
        return 0.0f;
    }

    public Vec3D bD() {
        return this.b(this.dA(), this.dy());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        if (!(this instanceof EntityHuman)) {
            return Vec3D.b;
        }
        EntityHuman entityhuman = (EntityHuman)this;
        boolean flag = entityhuman.eP().a(item) && !entityhuman.eO().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fh().d() : entityhuman.fh();
        return this.b(0.0f, this.dy() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bE() {
        return new Vec2F(this.dA(), this.dy());
    }

    public Vec3D bF() {
        return Vec3D.a(this.bE());
    }

    public void f(BlockPosition pos) {
        if (this.as()) {
            this.aq();
        } else {
            if (!this.dI().B && !pos.equals(this.aw)) {
                this.aw = pos.i();
            }
            this.au = true;
        }
    }

    protected void bG() {
        if (this.dI() instanceof WorldServer) {
            int i2 = this.at();
            WorldServer worldserver = (WorldServer)this.dI();
            if (this.au) {
                MinecraftServer minecraftserver = worldserver.n();
                ResourceKey<net.minecraft.world.level.World> resourcekey = this.dI().getTypeKey() == WorldDimension.c ? net.minecraft.world.level.World.h : net.minecraft.world.level.World.i;
                WorldServer worldserver1 = minecraftserver.a(resourcekey);
                if (!this.bM() && this.av++ >= i2) {
                    this.dI().ad().a("portal");
                    this.av = i2;
                    EntityPortalReadyEvent event = new EntityPortalReadyEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (World)(worldserver1 == null ? null : worldserver1.getWorld()), PortalType.NETHER);
                    if (!event.callEvent()) {
                        this.av = 0;
                    } else {
                        worldserver1 = event.getTargetWorld() == null ? null : ((CraftWorld)event.getTargetWorld()).getHandle();
                        this.aq();
                        if (this instanceof EntityPlayer) {
                            ((EntityPlayer)this).changeDimension(worldserver1, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                        } else {
                            this.b(worldserver1);
                        }
                    }
                    this.dI().ad().c();
                }
                this.au = false;
            } else {
                if (this.av > 0) {
                    this.av -= 4;
                }
                if (this.av < 0) {
                    this.av = 0;
                }
            }
            this.H();
        }
    }

    public int bH() {
        return 300;
    }

    public void l(double x2, double y2, double z2) {
        this.o(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte status) {
        switch (status) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void m(float yaw) {
    }

    public Iterable<ItemStack> bI() {
        return e;
    }

    public Iterable<ItemStack> bJ() {
        return e;
    }

    public Iterable<ItemStack> bK() {
        return Iterables.concat(this.bI(), this.bJ());
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
    }

    public boolean bL() {
        boolean flag = this.dI() != null && this.dI().B;
        return !this.aU() && (this.aN > 0 || flag && this.i(0));
    }

    public boolean bM() {
        return this.cW() != null;
    }

    public boolean bN() {
        return !this.r.isEmpty();
    }

    public boolean bO() {
        return this.ae().a(TagsEntity.m);
    }

    public void f(boolean sneaking) {
        this.b(1, sneaking);
    }

    public boolean bP() {
        return this.i(1);
    }

    public boolean bQ() {
        return this.bP();
    }

    public boolean bR() {
        return this.bP();
    }

    public boolean bS() {
        return this.bP();
    }

    public boolean bT() {
        return this.bP();
    }

    public boolean bU() {
        return this.c(EntityPose.f);
    }

    public boolean bV() {
        return this.i(3);
    }

    public void g(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean bW() {
        return this.i(4);
    }

    public boolean bX() {
        return this.c(EntityPose.d);
    }

    public boolean bY() {
        return this.bX() && !this.aV();
    }

    public void h(boolean swimming) {
        if (this.valid && this.bW() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean bZ() {
        return this.bd;
    }

    public final void i(boolean glowing) {
        this.bd = glowing;
        this.b(6, this.ca());
    }

    public boolean ca() {
        return this.dI().r_() ? this.i(6) : this.bd;
    }

    public boolean cb() {
        return this.i(5);
    }

    public boolean d(EntityHuman player) {
        if (player.G_()) {
            return false;
        }
        ScoreboardTeamBase scoreboardteambase = this.cd();
        return scoreboardteambase != null && player != null && player.cd() == scoreboardteambase && scoreboardteambase.i() ? false : this.cb();
    }

    public boolean cc() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
    }

    @javax.annotation.Nullable
    public ScoreboardTeamBase cd() {
        if (!this.dI().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.dI().I().i(this.cv());
    }

    public boolean p(Entity other) {
        return this.a(other.cd());
    }

    public boolean a(ScoreboardTeamBase team) {
        return this.cd() != null ? this.cd().a(team) : false;
    }

    public void j(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int index) {
        return (this.am.b(an) & 1 << index) != 0;
    }

    public void b(int index, boolean value) {
        byte b0 = this.am.b(an);
        if (value) {
            this.am.b(an, (byte)(b0 | 1 << index));
        } else {
            this.am.b(an, (byte)(b0 & ~(1 << index)));
        }
    }

    public int ce() {
        return this.maxAirTicks;
    }

    public int cf() {
        return this.am.b(aT);
    }

    public void j(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cf() != air) {
            this.am.markDirty(aT);
            return;
        }
        this.am.b(aT, event.getAmount());
    }

    public int cg() {
        return this.am.b(aY);
    }

    public void k(int frozenTicks) {
        this.am.b(aY, frozenTicks);
    }

    public float ch() {
        int i2 = this.cj();
        return (float)Math.min(this.cg(), i2) / (float)i2;
    }

    public boolean ci() {
        return this.cg() >= this.cj();
    }

    public int cj() {
        return 140;
    }

    public void a(WorldServer world, EntityLightning lightning) {
        this.h(this.aN + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aN == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.setSecondsOnFire(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.aN - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.aU()) {
            return;
        }
        CraftEventFactory.entityDamage = lightning;
        if (!this.a(this.dJ().b(), 5.0f)) {
            CraftEventFactory.entityDamage = null;
            return;
        }
    }

    public void k(boolean drag) {
        Vec3D vec3d = this.dl();
        double d0 = drag ? Math.max(-0.9, vec3d.d - 0.03) : Math.min(1.8, vec3d.d + 0.1);
        this.o(vec3d.c, d0, vec3d.e);
    }

    public void l(boolean drag) {
        Vec3D vec3d = this.dl();
        double d0 = drag ? Math.max(-0.3, vec3d.d - 0.03) : Math.min(0.7, vec3d.d + 0.06);
        this.o(vec3d.c, d0, vec3d.e);
        this.n();
    }

    public boolean a(WorldServer world, EntityLiving other) {
        return true;
    }

    public void ck() {
        if (this.dl().b() > -0.5 && this.aa > 1.0f) {
            this.aa = 1.0f;
        }
    }

    public void n() {
        this.aa = 0.0f;
    }

    protected void m(double x2, double y2, double z2) {
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        Vec3D vec3d = new Vec3D(x2 - (double)blockposition.u(), y2 - (double)blockposition.v(), z2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.dI().a_(blockposition_mutableblockposition).r(this.dI(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d2 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.af.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dl().a(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.o(f1 * f2, vec3d1.d, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.o(vec3d1.c, f1 * f2, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.o(vec3d1.c, vec3d1.d, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D multiplier) {
        this.n();
        this.T = multiplier;
    }

    private static IChatBaseComponent c(IChatBaseComponent textComponent) {
        IChatMutableComponent ichatmutablecomponent = textComponent.d().b(textComponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : textComponent.c()) {
            ichatmutablecomponent.b(Entity.c(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? Entity.c(ichatbasecomponent) : this.cl();
    }

    protected IChatBaseComponent cl() {
        return this.p.h();
    }

    public boolean q(Entity entity) {
        return this == entity;
    }

    public float cm() {
        return 0.0f;
    }

    public void n(float headYaw) {
    }

    public void o(float bodyYaw) {
    }

    public boolean cn() {
        return true;
    }

    public boolean r(Entity attacker) {
        return false;
    }

    public String toString() {
        String s2 = this.dI() == null ? "~NULL~" : this.dI().toString();
        return this.aK != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.Z().getString(), this.q, this.ax, s2, this.dn(), this.dp(), this.dt(), this.dk(), this.ag, this.valid, this.aK}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.Z().getString(), this.q, this.ax, s2, this.dn(), this.dp(), this.dt(), this.dk(), this.ag, this.valid);
    }

    public boolean b(DamageSource damageSource) {
        return this.dD() || this.bc && !damageSource.a(DamageTypeTags.d) && !damageSource.g() || damageSource.a(DamageTypeTags.i) && this.aU() || damageSource.a(DamageTypeTags.m) && this.ae().a(TagsEntity.l);
    }

    public boolean co() {
        return this.bc;
    }

    public void m(boolean invulnerable) {
        this.bc = invulnerable;
    }

    public void s(Entity entity) {
        this.b(entity.dn(), entity.dp(), entity.dt(), entity.dy(), entity.dA());
    }

    public void t(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound nbttagcompound = original.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.bb = original.bb;
        this.aw = original.aw;
    }

    @javax.annotation.Nullable
    public Entity b(WorldServer destination) {
        return this.teleportTo(destination, null);
    }

    @javax.annotation.Nullable
    public Entity teleportTo(WorldServer worldserver, Position location) {
        if (!this.bs() || !this.valid) {
            c.warn("Illegal Entity Teleport " + this + " to " + worldserver + ":" + location, new Throwable());
            return null;
        }
        if (this.dI() instanceof WorldServer && !this.dD()) {
            Object entity;
            ShapeDetectorShape shapedetectorshape;
            this.dI().ad().a("changeDimension");
            if (worldserver == null) {
                return null;
            }
            this.dI().ad().a("reposition");
            ShapeDetectorShape shapeDetectorShape = shapedetectorshape = location == null ? this.a(worldserver) : new ShapeDetectorShape(new Vec3D(location.a(), location.b(), location.c()), Vec3D.b, this.aG, this.aH, worldserver, null);
            if (shapedetectorshape == null) {
                return null;
            }
            worldserver = shapedetectorshape.world;
            CraftEntity bukkitEntity = this.getBukkitEntity();
            Vec3D position = shapedetectorshape.a;
            float yaw = shapedetectorshape.c;
            float pitch = bukkitEntity.getLocation().getPitch();
            Vec3D velocity = shapedetectorshape.b;
            EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), new Location((World)worldserver.getWorld(), position.c, position.d, position.e, yaw, pitch), bukkitEntity.getVelocity(), CraftVector.toBukkit(shapedetectorshape.b));
            event.callEvent();
            if (this.dD()) {
                return null;
            }
            if (!event.isCancelled() && event.getTo() != null) {
                worldserver = ((CraftWorld)event.getTo().getWorld()).getHandle();
                position = new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
                yaw = event.getTo().getYaw();
                pitch = event.getTo().getPitch();
                velocity = CraftVector.toNMS(event.getAfter());
            }
            if (worldserver == this.t) {
                this.b(shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.a.e, shapedetectorshape.c, shapedetectorshape.d);
                this.f(shapedetectorshape.b);
                return this;
            }
            this.ac();
            this.dI().ad().b("reloading");
            if (this instanceof EntityInsentient) {
                ((EntityInsentient)this).a(true, true);
            }
            if ((entity = this.ae().a(worldserver)) != null) {
                ((Entity)entity).t(this);
                ((Entity)entity).b(position.c, position.d, position.e, yaw, pitch);
                ((Entity)entity).f(velocity);
                worldserver.d((Entity)entity);
                if (worldserver.getTypeKey() == WorldDimension.d) {
                    WorldServer.makeObsidianPlatform(worldserver, this);
                }
            }
            this.cp();
            this.dI().ad().c();
            ((WorldServer)this.dI()).g();
            worldserver.g();
            this.dI().ad().c();
            return entity;
        }
        return null;
    }

    protected void cp() {
        this.b(RemovalReason.e);
    }

    @javax.annotation.Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        BlockPosition blockposition1;
        boolean flag1;
        if (destination == null) {
            return null;
        }
        boolean flag = this.dI().getTypeKey() == WorldDimension.d && destination.getTypeKey() == WorldDimension.b;
        boolean bl = flag1 = destination.getTypeKey() == WorldDimension.d;
        if (!flag && !flag1) {
            CraftPortalEvent event;
            boolean flag2;
            boolean bl2 = flag2 = destination.getTypeKey() == WorldDimension.c;
            if (this.dI().getTypeKey() != WorldDimension.c && !flag2) {
                return null;
            }
            WorldBorder worldborder = destination.w_();
            double d0 = DimensionManager.a(this.dI().x_(), destination.x_());
            BlockPosition blockposition = worldborder.b(this.dn() * d0, this.dp(), this.dt() * d0);
            int portalSearchRadius = destination.paperConfig().environment.portalSearchRadius;
            if (this.t.paperConfig().environment.portalSearchVanillaDimensionScaling && flag2) {
                portalSearchRadius = (int)((double)portalSearchRadius / destination.x_().k());
            }
            if ((event = this.callPortalEvent(this, destination, new Position(blockposition.u(), blockposition.v(), blockposition.w()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, destination.paperConfig().environment.portalCreateRadius)) == null) {
                return null;
            }
            WorldServer worldserverFinal = destination = ((CraftWorld)event.getTo().getWorld()).getHandle();
            worldborder = worldserverFinal.w_();
            blockposition = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            return this.getExitPortal(destination, blockposition, flag2, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius()).map(blockutil_rectangle -> {
                Vec3D vec3d;
                EnumDirection.EnumAxis enumdirection_enumaxis;
                IBlockData iblockdata = this.dI().a_(this.aw);
                if (iblockdata.b(BlockProperties.H)) {
                    enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
                    BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(this.aw, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, blockposition1 -> this.dI().a_((BlockPosition)blockposition1) == iblockdata);
                    vec3d = this.a(enumdirection_enumaxis, blockutil_rectangle1);
                } else {
                    enumdirection_enumaxis = EnumDirection.EnumAxis.a;
                    vec3d = new Vec3D(0.5, 0.0, 0.0);
                }
                return BlockPortalShape.createPortalInfo(worldserverFinal, blockutil_rectangle, enumdirection_enumaxis, vec3d, this, this.dl(), this.dy(), this.dA(), event);
            }).orElse(null);
        }
        if (flag1) {
            blockposition1 = WorldServer.a;
        } else {
            destination.l(destination.R());
            blockposition1 = destination.a(HeightMap.Type.f, destination.R());
        }
        CraftPortalEvent event = this.callPortalEvent(this, destination, new Position((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        return new ShapeDetectorShape(new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ()), this.dl(), this.dy(), this.dA(), ((CraftWorld)event.getTo().getWorld()).getHandle(), event);
    }

    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return BlockPortalShape.a(portalRect, portalAxis, this.dg(), this.a(this.al()));
    }

    protected CraftPortalEvent callPortalEvent(Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld());
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bs()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        return worldserver.o().findPortalAround(blockposition, worldborder, searchRadius);
    }

    public boolean cq() {
        return !this.bM() && !this.bN() && this.bs() && this.valid;
    }

    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return max;
    }

    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cr() {
        return 3;
    }

    public boolean c_() {
        return false;
    }

    public void a(CrashReportSystemDetails section) {
        section.a("Entity Type", () -> {
            MinecraftKey minecraftkey = EntityTypes.a(this.ae());
            return minecraftkey + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.a("Entity ID", this.q);
        section.a("Entity Name", () -> this.Z().getString());
        section.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dn(), this.dp(), this.dt()));
        section.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dI(), MathHelper.a(this.dn()), MathHelper.a(this.dp()), MathHelper.a(this.dt())));
        Vec3D vec3d = this.dl();
        section.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.c, vec3d.d, vec3d.e));
        section.a("Entity's Passengers", () -> this.cN().toString());
        section.a("Entity's Vehicle", () -> String.valueOf(this.cW()));
    }

    public boolean cs() {
        return this.bL() && !this.G_();
    }

    public void a_(UUID uuid) {
        this.ax = uuid;
        this.ay = this.ax.toString();
    }

    @Override
    public UUID ct() {
        return this.ax;
    }

    public String cu() {
        return this.ay;
    }

    public String cv() {
        return this.ay;
    }

    public boolean cw() {
        return true;
    }

    public static double cx() {
        return o;
    }

    public static void b(double value) {
        o = value;
    }

    @Override
    public IChatBaseComponent H_() {
        return ScoreboardTeam.a(this.cd(), this.Z()).a(chatmodifier -> chatmodifier.a(this.cD()).a(this.cu()));
    }

    public void b(@javax.annotation.Nullable IChatBaseComponent name) {
        this.am.b(aU, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public IChatBaseComponent ab() {
        return this.am.b(aU).orElse(null);
    }

    @Override
    public boolean aa() {
        return this.am.b(aU).isPresent();
    }

    public void n(boolean visible) {
        this.am.b(aV, visible);
    }

    public boolean cy() {
        return this.am.b(aV);
    }

    public final void n(double destX, double destY, double destZ) {
        if (this.dI() instanceof WorldServer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(destX, destY, destZ));
            ((WorldServer)this.dI()).k().a(TicketType.g, chunkcoordintpair, 0, this.af());
            this.dI().d(chunkcoordintpair.e, chunkcoordintpair.f);
            this.b(destX, destY, destZ);
        }
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        float f2 = MathHelper.a(pitch, -90.0f, 90.0f);
        if (world == this.dI()) {
            this.b(destX, destY, destZ, yaw, f2);
            this.s();
            this.n(yaw);
        } else {
            this.ac();
            Object entity = this.ae().a(world);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).t(this);
            ((Entity)entity).b(destX, destY, destZ, yaw, f2);
            ((Entity)entity).n(yaw);
            this.b(RemovalReason.e);
            world.d((Entity)entity);
        }
        return true;
    }

    public void a(double destX, double destY, double destZ) {
        this.b(destX, destY, destZ);
    }

    public void b(double destX, double destY, double destZ) {
        if (this.dI() instanceof WorldServer) {
            this.b(destX, destY, destZ, this.dy(), this.dA());
            this.s();
        }
    }

    private void s() {
        this.cP().forEach(entity -> {
            for (Entity entity1 : entity.r) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double offsetX, double offsetY, double offsetZ) {
        this.b(this.dn() + offsetX, this.dp() + offsetY, this.dt() + offsetZ);
    }

    public boolean cz() {
        return this.cy();
    }

    public void a(List<DataWatcher.b<?>> dataEntries) {
    }

    public void a(DataWatcherObject<?> data) {
        if (ar.equals(data)) {
            this.d_();
        }
    }

    @Deprecated
    protected void cA() {
        EntitySize entitysize;
        EntityPose entitypose = this.al();
        this.bh = entitysize = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize);
    }

    public void d_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bh;
        EntityPose entitypose = this.al();
        this.bh = entitysize1 = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize1);
        this.an();
        boolean bl = flag = (double)entitysize1.a <= 4.0 && (double)entitysize1.b <= 4.0;
        if (!(this.dI().B || this.al || this.ae || !flag || !(entitysize1.a > entitysize.a) && !(entitysize1.b > entitysize.b) || this instanceof EntityHuman)) {
            Vec3D vec3d = this.dg().b(0.0, (double)entitysize.b / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitysize1.a - entitysize.a) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitysize1.b - entitysize.b) + 1.0E-6;
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, d1, d0));
            this.dI().a(this, voxelshape, vec3d, (double)entitysize1.a, (double)entitysize1.b, (double)entitysize1.a).ifPresent(vec3d1 -> this.a(vec3d1.b(0.0, (double)(-entitysize1.b) / 2.0, 0.0)));
        }
    }

    public EnumDirection cB() {
        return EnumDirection.a(this.dy());
    }

    public EnumDirection cC() {
        return this.cB();
    }

    protected ChatHoverable cD() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.ae(), this.ct(), this.Z()));
    }

    public boolean a(EntityPlayer spectator) {
        return true;
    }

    @Override
    public final AxisAlignedBB cE() {
        return this.aI;
    }

    public AxisAlignedBB j_() {
        return this.cE();
    }

    protected AxisAlignedBB e(EntityPose pos) {
        EntitySize entitysize = this.a(pos);
        float f2 = entitysize.a / 2.0f;
        Vec3D vec3d = new Vec3D(this.dn() - (double)f2, this.dp(), this.dt() - (double)f2);
        Vec3D vec3d1 = new Vec3D(this.dn() + (double)f2, this.dp() + (double)entitysize.b, this.dt() + (double)f2);
        return new AxisAlignedBB(vec3d, vec3d1);
    }

    public final void a(AxisAlignedBB boundingBox) {
        if (!this.aI.equals(boundingBox)) {
            this.boundingBoxChanged = true;
        }
        double minX = boundingBox.a;
        double minY = boundingBox.b;
        double minZ = boundingBox.c;
        double maxX = boundingBox.d;
        double maxY = boundingBox.e;
        double maxZ = boundingBox.f;
        double len = boundingBox.d - boundingBox.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.e - boundingBox.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.f - boundingBox.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aI = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.85f;
    }

    public float f(EntityPose pose) {
        return this.a(pose, this.a(pose));
    }

    public final float cF() {
        return this.bi;
    }

    public Vec3D p(float tickDelta) {
        return this.cG();
    }

    protected Vec3D cG() {
        return new Vec3D(0.0, this.cF(), this.dd() * 0.4f);
    }

    public SlotAccess a_(int mappedIndex) {
        return SlotAccess.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
    }

    public net.minecraft.world.level.World cH() {
        return this.dI();
    }

    @javax.annotation.Nullable
    public MinecraftServer cI() {
        return this.dI().n();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean cJ() {
        return false;
    }

    public void a(EntityLiving attacker, Entity target) {
        if (target instanceof EntityLiving) {
            EnchantmentManager.a((EntityLiving)target, (Entity)attacker);
        }
        EnchantmentManager.b(attacker, target);
    }

    public void c(EntityPlayer player) {
    }

    public void d(EntityPlayer player) {
    }

    public float a(EnumBlockRotation rotation) {
        float f2 = MathHelper.g(this.dy());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror mirror) {
        float f2 = MathHelper.g(this.dy());
        switch (mirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cK() {
        return false;
    }

    @javax.annotation.Nullable
    public EntityLiving cL() {
        return null;
    }

    public final boolean cM() {
        return this.cL() != null;
    }

    public final List<Entity> cN() {
        return this.r;
    }

    @javax.annotation.Nullable
    public Entity cO() {
        return this.r.isEmpty() ? null : (Entity)this.r.get(0);
    }

    public boolean u(Entity passenger) {
        return this.r.contains((Object)passenger);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.r.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> t() {
        if (this.r.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.r.stream().flatMap(Entity::cP);
    }

    public Stream<Entity> cP() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.t());
    }

    public Stream<Entity> cQ() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.r.stream().flatMap(Entity::cQ), Stream.of(this));
    }

    public Iterable<Entity> cR() {
        if (this.r.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder indirectPassengers = ImmutableList.builder();
        for (Entity passenger : this.r) {
            indirectPassengers.add((Object)passenger);
            indirectPassengers.addAll(passenger.cR());
        }
        return indirectPassengers.build();
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.t().iterator();
    }

    public boolean hasAnyPlayerPassengers() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.t().anyMatch(entity -> entity instanceof EntityHuman);
    }

    public boolean cS() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.t().filter(entity -> entity instanceof EntityHuman).count() == 1L;
    }

    public Entity cT() {
        Entity entity = this;
        while (entity.bM()) {
            entity = entity.cW();
        }
        return entity;
    }

    public boolean v(Entity entity) {
        return this.cT() == entity.cT();
    }

    public boolean w(Entity passenger) {
        if (!passenger.bM()) {
            return false;
        }
        Entity entity1 = passenger.cW();
        return entity1 == this ? true : this.w(entity1);
    }

    public boolean cU() {
        EntityLiving entityliving = this.cL();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.g();
        }
        return this.cV();
    }

    public boolean cV() {
        return !this.dI().B;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(passengerYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.b(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dn(), this.cE().e, this.dt());
    }

    @javax.annotation.Nullable
    public Entity cW() {
        return this.s;
    }

    @javax.annotation.Nullable
    public Entity cX() {
        return this.s != null && this.s.cL() == this ? this.s : null;
    }

    public EnumPistonReaction l_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory cY() {
        return SoundCategory.g;
    }

    public int cZ() {
        return 1;
    }

    public CommandListenerWrapper da() {
        return new CommandListenerWrapper(this, this.dg(), this.bE(), this.dI() instanceof WorldServer ? (WorldServer)this.dI() : null, this.B(), this.Z().getString(), this.H_(), this.dI().n(), this);
    }

    protected int B() {
        return 0;
    }

    public boolean l(int permissionLevel) {
        return this.B() >= permissionLevel;
    }

    @Override
    public boolean e_() {
        return this.dI().X().b(GameRules.o);
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public boolean N_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        Vec3D vec3d1 = anchorPoint.a(this);
        double d0 = target.c - vec3d1.c;
        double d1 = target.d - vec3d1.d;
        double d2 = target.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.b_(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.a_(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.n(this.dy());
        this.N = this.dA();
        this.M = this.dy();
    }

    public boolean a(TagKey<FluidType> tag, double speed) {
        if (!LeavesConfig.reduceEntityFluidLookup && this.db()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cE().h(0.001);
        int minBlockX = MathHelper.a(axisalignedbb.a);
        int maxBlockX = MathHelper.c(axisalignedbb.d);
        int minBlockY = MathHelper.a(axisalignedbb.b);
        int maxBlockY = MathHelper.c(axisalignedbb.e);
        int minBlockZ = MathHelper.a(axisalignedbb.c);
        int maxBlockZ = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cw();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.b;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        if (LeavesConfig.reduceEntityFluidLookup) {
            int minSection = WorldUtil.getMinSection(this.t);
            int maxSection = WorldUtil.getMaxSection(this.t);
            int minBlock = minSection << 4;
            int maxBlock = maxSection << 4 | 0xF;
            if (minBlockY > maxBlock || maxBlockY < minBlock) {
                return false;
            }
            int minYIterate = Math.max(minBlock, minBlockY);
            int maxYIterate = Math.min(maxBlock, maxBlockY);
            int minChunkX = minBlockX >> 4;
            int maxChunkX = maxBlockX >> 4;
            int minChunkZ = minBlockZ >> 4;
            int maxChunkZ = maxBlockZ >> 4;
            for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
                int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 16;
                for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                    int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 16;
                    IChunkAccess chunk = this.t.getChunkIfLoadedImmediately(currChunkX, currChunkZ);
                    if (chunk == null) {
                        return false;
                    }
                    ChunkSection[] sections = chunk.d();
                    for (int currY = minYIterate; currY < maxYIterate; ++currY) {
                        ChunkSection section = sections[(currY >> 4) - minSection];
                        if (section == null || section.c() || section.fluidStateCount == 0) {
                            currY = (currY & 0xFFFFFFF0) + 15;
                            continue;
                        }
                        DataPaletteBlock<IBlockData> blocks = section.h;
                        for (int currZ = minZ; currZ < maxZ; ++currZ) {
                            for (int currX = minX; currX < maxX; ++currX) {
                                Fluid fluid = blocks.a(currX & 0xF, currY & 0xF, currZ & 0xF).u();
                                if (!fluid.a(tag)) continue;
                                blockposition_mutableblockposition.d((currChunkX << 4) + currX, currY, (currChunkZ << 4) + currZ);
                                double d2 = (float)currY + fluid.a((IBlockAccess)this.t, (BlockPosition)blockposition_mutableblockposition);
                                if (!(d2 >= axisalignedbb.b)) continue;
                                flag1 = true;
                                d1 = Math.max(d2 - axisalignedbb.b, d1);
                                if (flag) {
                                    Vec3D vec3d1 = fluid.c(this.t, blockposition_mutableblockposition);
                                    if (d1 < 0.4) {
                                        vec3d1 = vec3d1.a(d1);
                                    }
                                    vec3d = vec3d.e(vec3d1);
                                    ++k1;
                                }
                                if (tag != TagsFluid.b) continue;
                                this.lastLavaContact = blockposition_mutableblockposition.i();
                            }
                        }
                    }
                }
            }
        } else {
            for (int l1 = minBlockX; l1 < maxBlockX; ++l1) {
                for (int i2 = minBlockY; i2 < maxBlockY; ++i2) {
                    for (int j2 = minBlockZ; j2 < maxBlockZ; ++j2) {
                        double d2;
                        blockposition_mutableblockposition.d(l1, i2, j2);
                        Fluid fluid = this.dI().b_(blockposition_mutableblockposition);
                        if (!fluid.a(tag) || !((d2 = (double)((float)i2 + fluid.a((IBlockAccess)this.dI(), (BlockPosition)blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                        flag1 = true;
                        d1 = Math.max(d2 - axisalignedbb.b, d1);
                        if (flag) {
                            Vec3D vec3d1 = fluid.c(this.dI(), blockposition_mutableblockposition);
                            if (d1 < 0.4) {
                                vec3d1 = vec3d1.a(d1);
                            }
                            vec3d = vec3d.e(vec3d1);
                            ++k1;
                        }
                        if (tag != TagsFluid.b) continue;
                        this.lastLavaContact = blockposition_mutableblockposition.i();
                    }
                }
            }
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dl();
            vec3d = vec3d.a(speed * 1.0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.c) < 0.003 && Math.abs(vec3d2.e) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.f(this.dl().e(vec3d));
        }
        this.ai.put(tag, d1);
        return flag1;
    }

    public boolean db() {
        AxisAlignedBB axisalignedbb = this.cE().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dI().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> fluid) {
        return this.ai.getDouble(fluid);
    }

    public double dc() {
        return (double)this.cF() < 0.4 ? 0.0 : 0.4;
    }

    public final float dd() {
        return this.bh.a;
    }

    public final float de() {
        return this.bh.b;
    }

    public float df() {
        return this.de() + 0.5f;
    }

    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntitySize a(EntityPose pose) {
        return this.p.n();
    }

    public Vec3D dg() {
        return this.u;
    }

    public Vec3D dh() {
        return this.dg();
    }

    @Override
    public BlockPosition di() {
        return this.aD;
    }

    public IBlockData dj() {
        if (this.bn == null) {
            this.bn = this.dI().a_(this.di());
        }
        return this.bn;
    }

    public ChunkCoordIntPair dk() {
        return this.aE;
    }

    public Vec3D dl() {
        return this.aF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void f(Vec3D velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.aF = velocity;
        }
    }

    public void g(Vec3D velocity) {
        this.f(this.dl().e(velocity));
    }

    public void o(double x2, double y2, double z2) {
        this.f(new Vec3D(x2, y2, z2));
    }

    public final int dm() {
        return this.aD.u();
    }

    public final double dn() {
        return this.u.c;
    }

    public double c(double widthScale) {
        return this.u.c + (double)this.dd() * widthScale;
    }

    public double d(double widthScale) {
        return this.c((2.0 * this.af.j() - 1.0) * widthScale);
    }

    public final int do() {
        return this.aD.v();
    }

    public final double dp() {
        return this.u.d;
    }

    public double e(double heightScale) {
        return this.u.d + (double)this.de() * heightScale;
    }

    public double dq() {
        return this.e(this.af.j());
    }

    public double dr() {
        return this.u.d + (double)this.bi;
    }

    public final int ds() {
        return this.aD.w();
    }

    public final double dt() {
        return this.u.e;
    }

    public double f(double widthScale) {
        return this.u.e + (double)this.dd() * widthScale;
    }

    public double g(double widthScale) {
        return this.f((2.0 * this.af.j() - 1.0) * widthScale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        String entityInfo = null;
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        c.error("New entity position is invalid! Tried to set invalid position (" + newX + "," + newY + "," + newZ + ") for entity " + entity.getClass().getName() + " located at " + entity.u + ", entity info: " + entityInfo, new Throwable());
        return false;
    }

    public final void p(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this.updatingSectionStatus) {
            c.error("Refusing to update position for entity " + this + " to position " + new Vec3D(x2, y2, z2) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.u.c != x2 || this.u.d != y2 || this.u.e != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.u = new Vec3D(x2, y2, z2);
            }
            int i2 = MathHelper.a(x2);
            int j2 = MathHelper.a(y2);
            int k2 = MathHelper.a(z2);
            if (i2 != this.aD.u() || j2 != this.aD.v() || k2 != this.aD.w()) {
                this.aD = new BlockPosition(i2, j2, k2);
                this.bn = null;
                if (SectionPosition.a(i2) != this.aE.e || SectionPosition.a(k2) != this.aE.f) {
                    this.aE = new ChunkCoordIntPair(this.aD);
                }
            }
            this.aZ.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.u.c != x2 || this.u.d != y2 || this.u.e != z2)) {
            this.a(this.am());
        }
    }

    public void du() {
    }

    public Vec3D q(float delta) {
        return this.l(delta).b(0.0, (double)this.bi * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int i2 = packet.a();
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        this.f(d0, d1, d2);
        this.d(d0, d1, d2);
        this.b_(packet.k());
        this.a_(packet.l());
        this.e(i2);
        this.a_(packet.c());
    }

    @javax.annotation.Nullable
    public ItemStack dv() {
        return null;
    }

    public void o(boolean inPowderSnow) {
        this.az = inPowderSnow;
    }

    public boolean dw() {
        return !this.ae().a(TagsEntity.i);
    }

    public boolean dx() {
        return (this.az || this.aA) && this.dw();
    }

    public float dy() {
        return this.aG;
    }

    public float dz() {
        return this.dy();
    }

    public void a_(float yaw) {
        if (!Float.isFinite(yaw)) {
            SystemUtils.a("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.aG = yaw;
        }
    }

    public float dA() {
        return this.aH;
    }

    public void b_(float pitch) {
        if (!Float.isFinite(pitch)) {
            SystemUtils.a("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.aH = pitch;
        }
    }

    public boolean dB() {
        return false;
    }

    public float dC() {
        return this.aM;
    }

    public void r(float stepHeight) {
        this.aM = stepHeight;
    }

    public final boolean dD() {
        return this.aK != null;
    }

    @javax.annotation.Nullable
    public RemovalReason dE() {
        return this.aK;
    }

    @Override
    public final void b(RemovalReason reason) {
        boolean alreadyRemoved;
        TickThread.ensureTickThread(this, "Cannot remove entity off-main");
        if (!((WorldServer)this.t).getEntityLookup().canRemoveEntity(this)) {
            c.warn("Entity " + this + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        boolean bl = alreadyRemoved = this.aK != null;
        if (this.aK == null) {
            this.aK = reason;
        }
        if (this.aK.a()) {
            this.Y();
        }
        if (reason != RemovalReason.c) {
            this.cN().forEach(Entity::Y);
        }
        this.aZ.a(reason);
        if (!(this instanceof EntityPlayer) && reason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void dF() {
        this.aK = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void a(EntityInLevelCallback changeListener) {
        this.aZ = changeListener;
    }

    @Override
    public boolean dG() {
        return this.aK != null && !this.aK.b() ? false : (this.bM() ? false : !this.bN() || !this.hasAnyPlayerPassengers());
    }

    @Override
    public boolean dH() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World dI() {
        return this.t;
    }

    public void a(net.minecraft.world.level.World world) {
        this.t = world;
    }

    public DamageSources dJ() {
        return this.dI().ag();
    }

    public static int nextEntityId() {
        return d.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ChunkProviderServer)this.t.J()).isPositionTicking(this);
    }

    public NBTTagCompound getLeavesData() {
        return this.leavesData;
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends Random
    implements BitRandomSource {
        private boolean locked = false;

        private RandomRandomSource() {
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                c.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }

        @Override
        public RandomSource d() {
            return new LegacyRandomSource(this.g());
        }

        @Override
        public PositionalRandomFactory e() {
            return new LegacyRandomSource.a(this.g());
        }

        @Override
        public int c(int bits) {
            return super.next(bits);
        }

        @Override
        public int b(int origin, int bound) {
            return BitRandomSource.super.b(origin, bound);
        }

        @Override
        public long g() {
            return BitRandomSource.super.g();
        }

        @Override
        public int f() {
            return BitRandomSource.super.f();
        }

        @Override
        public int a(int bound) {
            return BitRandomSource.super.a(bound);
        }

        @Override
        public boolean h() {
            return BitRandomSource.super.h();
        }

        @Override
        public float i() {
            return BitRandomSource.super.i();
        }

        @Override
        public double j() {
            return BitRandomSource.super.j();
        }

        @Override
        public double k() {
            return super.nextGaussian();
        }
    }
}

