/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int b = 6000;
    private static final int c = 20;
    private static final int d = 8;
    private static final int e = 40;
    private static final double f = 0.5;
    private int g;
    private int h = 5;
    public int i;
    private int j = 1;
    private EntityHuman k;
    @Nullable
    public UUID sourceEntityId;
    @Nullable
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.b("Paper.ExpData", 10)) {
            return;
        }
        NBTTagCompound comp = nbttagcompound.p("Paper.ExpData");
        if (comp.b("source")) {
            this.sourceEntityId = comp.a("source");
        }
        if (comp.b("trigger")) {
            this.triggerEntityId = comp.a("trigger");
        }
        if (comp.e("reason")) {
            String reason = comp.l("reason");
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.dI().getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        }
    }

    private void savePaperNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.sourceEntityId != null) {
            comp.a("source", this.sourceEntityId);
        }
        if (this.triggerEntityId != null) {
            comp.a("trigger", this.triggerEntityId);
        }
        if (this.spawnReason != null && this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            comp.a("reason", this.spawnReason.name());
        }
        nbttagcompound.a("Paper.ExpData", comp);
    }

    @DoNotUse
    @Deprecated
    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount) {
        this(world, x2, y2, z2, amount, null, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        this(world, d0, d1, d2, i2, reason, triggerId, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.J, world);
        this.sourceEntityId = sourceId != null ? sourceId.ct() : null;
        this.triggerEntityId = triggerId != null ? triggerId.ct() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.e(d0, d1, d2);
        this.a_((float)(this.af.j() * 360.0));
        this.o((this.af.j() * (double)0.2f - (double)0.1f) * 2.0, this.af.j() * 0.2 * 2.0, (this.af.j() * (double)0.2f - (double)0.1f) * 2.0);
        this.i = i2;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> type, World world) {
        super(type, world);
    }

    @Override
    protected Entity.MovementEmission aS() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
    }

    @Override
    public void l() {
        Vec3D vec3d;
        double d0;
        super.l();
        EntityHuman prevTarget = this.k;
        this.J = this.dn();
        this.K = this.dp();
        this.L = this.dt();
        if (this.a(TagsFluid.a)) {
            this.p();
        } else if (!this.aR()) {
            this.f(this.dl().b(0.0, -0.03, 0.0));
        }
        if (this.dI().b_(this.di()).a(TagsFluid.b)) {
            this.o((this.af.i() - this.af.i()) * 0.2f, 0.2f, (this.af.i() - this.af.i()) * 0.2f);
        }
        if (!this.dI().b(this.cE())) {
            this.m(this.dn(), (this.cE().b + this.cE().e) / 2.0, this.dt());
        }
        if (this.ag % 20 == 1) {
            this.o();
        }
        if (this.k != null && (this.k.G_() || this.k.es())) {
            this.k = null;
        }
        boolean cancelled = false;
        if (this.k != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.k, this.k != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.k = prevTarget;
            } else {
                EntityHuman entityHuman = this.k = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.k != null && !cancelled && (d0 = (vec3d = new Vec3D(this.k.dn() - this.dn(), this.k.dp() + (double)this.k.cF() / 2.0 - this.dp(), this.k.dt() - this.dt())).g()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.f(this.dl().e(vec3d.d().a(d1 * d1 * 0.1)));
        }
        this.a(EnumMoveType.a, this.dl());
        float f2 = 0.98f;
        if (this.ay()) {
            f2 = this.dI().a_(this.aE()).b().h() * 0.98f;
        }
        this.f(this.dl().d(f2, 0.98, f2));
        if (this.ay()) {
            this.f(this.dl().d(1.0, -0.9, 1.0));
        }
        ++this.g;
        if (this.g >= 6000) {
            this.ai();
        }
    }

    @Override
    protected BlockPosition aE() {
        return this.d(0.999999f);
    }

    private void o() {
        if (this.k == null || this.k.f(this) > 64.0) {
            this.k = this.dI().a((Entity)this, 8.0);
        }
        if (this.dI() instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.dI().a(EntityTypeTest.a(EntityExperienceOrb.class), this.cE().g(0.5), this::a);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.b(entityexperienceorb);
            }
        }
    }

    public static void a(WorldServer world, Vec3D pos, int amount) {
        EntityExperienceOrb.award(world, pos, amount, null, null, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        EntityExperienceOrb.award(world, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        while (amount > 0) {
            int j2 = EntityExperienceOrb.b(amount);
            amount -= j2;
            if (EntityExperienceOrb.b(world, pos, j2)) continue;
            world.b(new EntityExperienceOrb(world, pos.a(), pos.b(), pos.c(), j2, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer world, Vec3D pos, int amount) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int j2 = world.y_().a(40);
        List<EntityExperienceOrb> list = world.a(EntityTypeTest.a(EntityExperienceOrb.class), axisalignedbb, (? super T entityexperienceorb) -> EntityExperienceOrb.a(entityexperienceorb, j2, amount));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.j;
            entityexperienceorb2.g = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb other) {
        return other != this && EntityExperienceOrb.a(other, this.af(), this.i);
    }

    private static boolean a(EntityExperienceOrb orb, int seed, int amount) {
        return !orb.dD() && (orb.af() - seed) % 40 == 0 && orb.i == amount;
    }

    private void b(EntityExperienceOrb other) {
        this.j += other.j;
        this.g = Math.min(this.g, other.g);
        other.ai();
    }

    private void p() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c * (double)0.99f, Math.min(vec3d.d + (double)5.0E-4f, (double)0.06f), vec3d.e * (double)0.99f);
    }

    @Override
    protected void bd() {
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (this.dI().B) {
            return true;
        }
        this.bl();
        this.h = (int)((float)this.h - amount);
        if (this.h <= 0) {
            this.ai();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", (short)this.h);
        nbt.a("Age", (short)this.g);
        nbt.a("Value", this.i);
        nbt.a("Count", this.j);
        this.savePaperNBT(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.h = nbt.g("Health");
        this.g = nbt.g("Age");
        this.i = nbt.h("Value");
        this.j = Math.max(nbt.h("Count"), 1);
        this.loadPaperNBT(nbt);
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dI().B && player.bW == 0 && new PlayerPickupExperienceEvent((Player)((EntityPlayer)player).getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
            player.bW = CraftEventFactory.callPlayerXpCooldownEvent(player, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
            player.a((Entity)this, 1);
            int i2 = this.a(player, this.i);
            if (i2 > 0) {
                player.d(CraftEventFactory.callPlayerExpChangeEvent(player, this).getAmount());
            }
            --this.j;
            if (this.j == 0) {
                this.ai();
            }
        }
    }

    private int a(EntityHuman player, int amount) {
        Map.Entry<EnumItemSlot, ItemStack> entry = EnchantmentManager.a(Enchantments.L, player, ItemStack::j);
        if (entry != null) {
            int k2;
            ItemStack itemstack = entry.getValue();
            int j2 = Math.min(this.d(this.i), itemstack.k());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemstack, entry.getKey(), j2, this::c);
            j2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return amount;
            }
            itemstack.b(itemstack.k() - j2);
            this.i = k2 = amount - event.getDurabilityToXpOperation().applyAsInt(j2);
            if (j2 == 0 && amount == k2) {
                return k2;
            }
            return k2 > 0 ? this.a(player, k2) : 0;
        }
        return amount;
    }

    public int c(int repairAmount) {
        return repairAmount / 2;
    }

    public int d(int experienceAmount) {
        return experienceAmount * 2;
    }

    public int j() {
        return this.i;
    }

    public int k() {
        return this.i >= 2477 ? 10 : (this.i >= 1237 ? 9 : (this.i >= 617 ? 8 : (this.i >= 307 ? 7 : (this.i >= 149 ? 6 : (this.i >= 73 ? 5 : (this.i >= 37 ? 4 : (this.i >= 17 ? 3 : (this.i >= 7 ? 2 : (this.i >= 3 ? 1 : 0)))))))));
    }

    public static int b(int value) {
        if (value > 162670129) {
            return value - 100000;
        }
        if (value > 81335063) {
            return 81335063;
        }
        if (value > 40667527) {
            return 40667527;
        }
        if (value > 20333759) {
            return 20333759;
        }
        if (value > 10166857) {
            return 10166857;
        }
        if (value > 5083423) {
            return 5083423;
        }
        if (value > 2541701) {
            return 2541701;
        }
        if (value > 1270849) {
            return 1270849;
        }
        if (value > 635413) {
            return 635413;
        }
        if (value > 317701) {
            return 317701;
        }
        if (value > 158849) {
            return 158849;
        }
        if (value > 79423) {
            return 79423;
        }
        if (value > 39709) {
            return 39709;
        }
        if (value > 19853) {
            return 19853;
        }
        if (value > 9923) {
            return 9923;
        }
        if (value > 4957) {
            return 4957;
        }
        return value >= 2477 ? 2477 : (value >= 1237 ? 1237 : (value >= 617 ? 617 : (value >= 307 ? 307 : (value >= 149 ? 149 : (value >= 73 ? 73 : (value >= 37 ? 37 : (value >= 17 ? 17 : (value >= 7 ? 7 : (value >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean cn() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntityExperienceOrb(this);
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.i;
    }
}

