/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;

public class EntityLightning
extends Entity {
    private static final int c = 2;
    private static final double d = 3.0;
    private static final double e = 15.0;
    public int f;
    public long b;
    public int g;
    public boolean h;
    @Nullable
    private EntityPlayer i;
    private final Set<Entity> j = Sets.newHashSet();
    private int k;
    public boolean isSilent = false;

    public EntityLightning(EntityTypes<? extends EntityLightning> type, World world) {
        super(type, world);
        this.as = true;
        this.f = 2;
        this.b = this.af.g();
        this.g = this.af.a(3) + 1;
    }

    public void a(boolean cosmetic) {
        this.h = cosmetic;
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.d;
    }

    @Nullable
    public EntityPlayer j() {
        return this.i;
    }

    public void b(@Nullable EntityPlayer channeler) {
        this.i = channeler;
    }

    private void p() {
        BlockPosition blockposition = this.q();
        IBlockData iblockdata = this.dI().a_(blockposition);
        if (iblockdata.a(Blocks.rr)) {
            ((LightningRodBlock)iblockdata.b()).d(iblockdata, this.dI(), blockposition);
        }
    }

    @Override
    public void l() {
        List<Entity> list;
        super.l();
        if (!this.isSilent && this.f == 2) {
            if (this.dI().r_()) {
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.mu, SoundCategory.d, 10000.0f, 0.8f + this.af.i() * 0.2f, false);
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.mt, SoundCategory.d, 2.0f, 0.5f + this.af.i() * 0.2f, false);
            } else {
                EnumDifficulty enumdifficulty = this.dI().ai();
                if (enumdifficulty == EnumDifficulty.c || enumdifficulty == EnumDifficulty.d) {
                    this.b(4);
                }
                this.p();
                EntityLightning.clearCopperOnLightningStrike(this.dI(), this.q(), this);
                this.a(GameEvent.H);
            }
        }
        --this.f;
        if (this.f < 0) {
            if (this.g == 0) {
                if (this.dI() instanceof WorldServer) {
                    list = this.dI().a((Entity)this, new AxisAlignedBB(this.dn() - 15.0, this.dp() - 15.0, this.dt() - 15.0, this.dn() + 15.0, this.dp() + 6.0 + 15.0, this.dt() + 15.0), (? super Entity entity) -> entity.bs() && !this.j.contains(entity));
                    for (EntityPlayer entityplayer2 : ((WorldServer)this.dI()).a((? super EntityPlayer entityplayer) -> entityplayer.e(this) < 256.0f)) {
                        CriterionTriggers.S.a(entityplayer2, this, list);
                    }
                }
                this.ai();
            } else if (this.f < -this.af.a(10)) {
                --this.g;
                this.f = 1;
                this.b = this.af.g();
                this.b(0);
            }
        }
        if (this.f >= 0 && !this.h) {
            if (!(this.dI() instanceof WorldServer)) {
                this.dI().c(2);
            } else if (!this.h) {
                list = this.dI().a((Entity)this, new AxisAlignedBB(this.dn() - 3.0, this.dp() - 3.0, this.dt() - 3.0, this.dn() + 3.0, this.dp() + 6.0 + 3.0, this.dt() + 3.0), Entity::bs);
                for (Entity entity2 : list) {
                    entity2.a((WorldServer)this.dI(), this);
                }
                this.j.addAll(list);
                if (this.i != null) {
                    CriterionTriggers.E.a(this.i, list);
                }
            }
        }
    }

    private BlockPosition q() {
        Vec3D vec3d = this.dg();
        return BlockPosition.a(vec3d.c, vec3d.d - 1.0E-6, vec3d.e);
    }

    private void b(int spreadAttempts) {
        if (!this.h && !this.dI().B && this.dI().X().b(GameRules.b)) {
            BlockPosition blockposition = this.di();
            IBlockData iblockdata = BlockFireAbstract.a(this.dI(), blockposition);
            if (this.dI().a_(blockposition).i() && iblockdata.a((IWorldReader)this.dI(), blockposition) && !this.h && !CraftEventFactory.callBlockIgniteEvent(this.dI(), blockposition, this).isCancelled()) {
                this.dI().b(blockposition, iblockdata);
                ++this.k;
            }
            for (int j2 = 0; j2 < spreadAttempts; ++j2) {
                BlockPosition blockposition1 = blockposition.b(this.af.a(3) - 1, this.af.a(3) - 1, this.af.a(3) - 1);
                iblockdata = BlockFireAbstract.a(this.dI(), blockposition1);
                if (!this.dI().a_(blockposition1).i() || !iblockdata.a((IWorldReader)this.dI(), blockposition1) || this.h || CraftEventFactory.callBlockIgniteEvent(this.dI(), blockposition1, this).isCancelled()) continue;
                this.dI().b(blockposition1, iblockdata);
                ++this.k;
            }
        }
    }

    private static void clearCopperOnLightningStrike(World world, BlockPosition pos, Entity lightning) {
        IBlockData iblockdata1;
        BlockPosition blockposition1;
        IBlockData iblockdata = world.a_(pos);
        if (iblockdata.a(Blocks.rr)) {
            blockposition1 = pos.a(iblockdata.c(BlockDirectional.a).g());
            iblockdata1 = world.a_(blockposition1);
        } else {
            blockposition1 = pos;
            iblockdata1 = iblockdata;
        }
        if (iblockdata1.b() instanceof WeatheringCopper) {
            IBlockData newBlock = WeatheringCopper.c(world.a_(blockposition1));
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1, newBlock)) {
                world.b(blockposition1, newBlock);
            }
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
            int i2 = world.z.a(3) + 3;
            for (int j2 = 0; j2 < i2; ++j2) {
                int k2 = world.z.a(8) + 1;
                EntityLightning.randomWalkCleaningCopper(world, blockposition1, blockposition_mutableblockposition, k2, lightning);
            }
        }
    }

    private static void randomWalkCleaningCopper(World world, BlockPosition pos, BlockPosition.MutableBlockPosition mutablePos, int count, Entity lightning) {
        Optional<BlockPosition> optional;
        mutablePos.g(pos);
        for (int j2 = 0; j2 < count && (optional = EntityLightning.randomStepCleaningCopper(world, mutablePos, lightning)).isPresent(); ++j2) {
            mutablePos.g(optional.get());
        }
    }

    private static Optional<BlockPosition> randomStepCleaningCopper(World world, BlockPosition pos, Entity lightning) {
        BlockPosition blockposition1;
        IBlockData iblockdata;
        Iterator<BlockPosition> iterator = BlockPosition.a(world.z, 10, pos, 1).iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!((iblockdata = world.a_(blockposition1 = iterator.next())).b() instanceof WeatheringCopper));
        BlockPosition blockposition1Final = blockposition1;
        WeatheringCopper.b(iblockdata).ifPresent(iblockdata1 -> {
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1Final, iblockdata1)) {
                world.b(blockposition1Final, (IBlockData)iblockdata1);
            }
        });
        world.c(3002, blockposition1, -1);
        return Optional.of(blockposition1);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0 * EntityLightning.cx();
        return distance < d1 * d1;
    }

    @Override
    protected void a_() {
    }

    @Override
    protected void a(NBTTagCompound nbt) {
    }

    @Override
    protected void b(NBTTagCompound nbt) {
    }

    public int k() {
        return this.k;
    }

    public Stream<Entity> o() {
        return this.j.stream().filter(Entity::bs);
    }
}

