/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.entity.Tameable;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    protected static final DataWatcherObject<Byte> bT = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> bU = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.q);
    private boolean bW;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.r();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bT, (byte)0);
        this.am.a(bU, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.U_() != null) {
            nbt.a("Owner", this.U_());
        }
        nbt.a("Sitting", this.bW);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        UUID uUID;
        super.a(nbt);
        if (nbt.b("Owner")) {
            uUID = nbt.a("Owner");
        } else {
            String string = nbt.l("Owner");
            uUID = NameReferencingFileConverter.a(this.cI(), string);
        }
        if (uUID != null) {
            try {
                this.b(uUID);
                this.x(true);
            }
            catch (Throwable var4) {
                this.x(false);
            }
        }
        this.bW = nbt.q("Sitting");
        this.setInSittingPose(this.bW, false);
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fO();
    }

    protected void w(boolean positive) {
        ParticleType particleOptions = Particles.M;
        if (!positive) {
            particleOptions = Particles.Z;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.af.k() * 0.02;
            double e2 = this.af.k() * 0.02;
            double f2 = this.af.k() * 0.02;
            this.dI().a(particleOptions, this.d(1.0), this.dq() + 0.5, this.g(1.0), d2, e2, f2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.w(true);
        } else if (status == 6) {
            this.w(false);
        } else {
            super.b(status);
        }
    }

    public boolean q() {
        return (this.am.b(bT) & 4) != 0;
    }

    public void x(boolean tamed) {
        byte b2 = this.am.b(bT);
        if (tamed) {
            this.am.b(bT, (byte)(b2 | 4));
        } else {
            this.am.b(bT, (byte)(b2 & 0xFFFFFFFB));
        }
        this.r();
    }

    protected void r() {
    }

    public boolean w() {
        return (this.am.b(bT) & 1) != 0;
    }

    public void y(boolean inSittingPose) {
        this.setInSittingPose(inSittingPose, true);
    }

    public void setInSittingPose(boolean inSittingPose, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), inSittingPose).callEvent()) {
            return;
        }
        byte b2 = this.am.b(bT);
        if (inSittingPose) {
            this.am.b(bT, (byte)(b2 | 1));
        } else {
            this.am.b(bT, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID U_() {
        return this.am.b(bU).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.am.b(bU, Optional.ofNullable(uuid));
    }

    public void f(EntityHuman player) {
        this.x(true);
        this.b(player.ct());
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return this.l(target) ? false : super.c(target);
    }

    public boolean l(EntityLiving entity) {
        return entity == this.I_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeamBase cd() {
        EntityLiving livingEntity;
        if (this.q() && (livingEntity = this.I_()) != null) {
            return livingEntity.cd();
        }
        return super.cd();
    }

    @Override
    public boolean p(Entity other) {
        if (this.q()) {
            EntityLiving livingEntity = this.I_();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.p(other);
            }
        }
        return super.p(other);
    }

    @Override
    public void a(DamageSource damageSource) {
        TameableDeathMessageEvent event;
        if (!this.dI().B && this.dI().X().b(GameRules.m) && this.I_() instanceof EntityPlayer && (event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eG().a()))).callEvent()) {
            this.I_().a(PaperAdventure.asVanilla(event.deathMessage()));
        }
        super.a(damageSource);
    }

    public boolean fY() {
        return this.bW;
    }

    public void z(boolean sitting) {
        this.bW = sitting;
    }
}

