/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger bw = LogUtils.getLogger();
    public static final String a = "EntityTag";
    private final Holder.c<EntityTypes<?>> bx = BuiltInRegistries.h.f(this);
    private static final float by = 1.3964844f;
    private static final int bz = 10;
    public static final EntityTypes<Allay> b = EntityTypes.a("allay", Builder.a(Allay::new, EnumCreatureType.b).a(0.35f, 0.6f).a(8).b(2));
    public static final EntityTypes<EntityAreaEffectCloud> c = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<EntityArmorStand> d = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).a(10));
    public static final EntityTypes<EntityTippedArrow> e = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<Axolotl> f = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).a(10));
    public static final EntityTypes<EntityBat> g = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).a(5));
    public static final EntityTypes<EntityBee> h = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).a(8));
    public static final EntityTypes<EntityBlaze> i = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<Display.BlockDisplay> j = EntityTypes.a("block_display", Builder.a(Display.BlockDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityBoat> k = EntityTypes.a("boat", Builder.a(EntityBoat::new, EnumCreatureType.h).a(1.375f, 0.5625f).a(10));
    public static final EntityTypes<Camel> l = EntityTypes.a("camel", Builder.a(Camel::new, EnumCreatureType.b).a(1.7f, 2.375f).a(10));
    public static final EntityTypes<EntityCat> m = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).a(8));
    public static final EntityTypes<EntityCaveSpider> n = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).a(8));
    public static final EntityTypes<ChestBoat> o = EntityTypes.a("chest_boat", Builder.a(ChestBoat::new, EnumCreatureType.h).a(1.375f, 0.5625f).a(10));
    public static final EntityTypes<EntityMinecartChest> p = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityChicken> q = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).a(10));
    public static final EntityTypes<EntityCod> r = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).a(4));
    public static final EntityTypes<EntityMinecartCommandBlock> s = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityCow> t = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).a(10));
    public static final EntityTypes<EntityCreeper> u = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityDolphin> v = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f));
    public static final EntityTypes<EntityHorseDonkey> w = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).a(10));
    public static final EntityTypes<EntityDragonFireball> x = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> y = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityEgg> z = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityGuardianElder> A = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).a(10));
    public static final EntityTypes<EntityEnderCrystal> B = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEnderDragon> C = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(10));
    public static final EntityTypes<EntityEnderPearl> D = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderman> E = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).a(8));
    public static final EntityTypes<EntityEndermite> F = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).a(8));
    public static final EntityTypes<EntityEvoker> G = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityEvokerFangs> H = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityThrownExpBottle> I = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityExperienceOrb> J = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> K = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> L = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityFireworks> M = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> N = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).a(8).a(Blocks.oi));
    public static final EntityTypes<Frog> O = EntityTypes.a("frog", Builder.a(Frog::new, EnumCreatureType.b).a(0.5f, 0.5f).a(10));
    public static final EntityTypes<EntityMinecartFurnace> P = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityGhast> Q = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).a(10));
    public static final EntityTypes<EntityGiantZombie> R = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).a(10));
    public static final EntityTypes<GlowItemFrame> S = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> T = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).a(10));
    public static final EntityTypes<Goat> U = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(10));
    public static final EntityTypes<EntityGuardian> V = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).a(8));
    public static final EntityTypes<EntityHoglin> W = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(8));
    public static final EntityTypes<EntityMinecartHopper> X = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityHorse> Y = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntityZombieHusk> Z = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> aa = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<Interaction> ab = EntityTypes.a("interaction", Builder.a(Interaction::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10));
    public static final EntityTypes<EntityIronGolem> ac = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> ad = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).a(0.25f, 0.25f).a(6).b(20));
    public static final EntityTypes<Display.ItemDisplay> ae = EntityTypes.a("item_display", Builder.a(Display.ItemDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityItemFrame> af = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLargeFireball> ag = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityLeash> ah = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).b().a(0.375f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> ai = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> aj = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).a(10));
    public static final EntityTypes<EntityLlamaSpit> ak = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> al = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(2.04f, 2.04f).a(8));
    public static final EntityTypes<Marker> am = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> an = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityMushroomCow> ao = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).a(10));
    public static final EntityTypes<EntityHorseMule> ap = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(8));
    public static final EntityTypes<EntityOcelot> aq = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(10));
    public static final EntityTypes<EntityPainting> ar = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityPanda> as = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> at = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).a(8));
    public static final EntityTypes<EntityPhantom> au = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).a(8));
    public static final EntityTypes<EntityPig> av = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(10));
    public static final EntityTypes<EntityPiglin> aw = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPiglinBrute> ax = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPillager> ay = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPolarBear> az = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.qC).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<EntityPotion> aA = EntityTypes.a("potion", Builder.a(EntityPotion::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPufferFish> aB = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).a(4));
    public static final EntityTypes<EntityRabbit> aC = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> aD = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(10));
    public static final EntityTypes<EntitySalmon> aE = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).a(4));
    public static final EntityTypes<EntitySheep> aF = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).a(10));
    public static final EntityTypes<EntityShulker> aG = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).a(10));
    public static final EntityTypes<EntityShulkerBullet> aH = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> aI = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).a(8));
    public static final EntityTypes<EntitySkeleton> aJ = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> aK = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntitySlime> aL = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(2.04f, 2.04f).a(10));
    public static final EntityTypes<EntitySmallFireball> aM = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<Sniffer> aN = EntityTypes.a("sniffer", Builder.a(Sniffer::new, EnumCreatureType.b).a(1.9f, 1.75f).a(10));
    public static final EntityTypes<EntitySnowman> aO = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.qC).a(0.7f, 1.9f).a(8));
    public static final EntityTypes<EntitySnowball> aP = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMinecartMobSpawner> aQ = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntitySpectralArrow> aR = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<EntitySpider> aS = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).a(8));
    public static final EntityTypes<EntitySquid> aT = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).a(8));
    public static final EntityTypes<EntitySkeletonStray> aU = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).a(Blocks.qC).a(8));
    public static final EntityTypes<EntityStrider> aV = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<Tadpole> aW = EntityTypes.a("tadpole", Builder.a(Tadpole::new, EnumCreatureType.b).a(Tadpole.c, Tadpole.d).a(10));
    public static final EntityTypes<Display.TextDisplay> aX = EntityTypes.a("text_display", Builder.a(Display.TextDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityTNTPrimed> aY = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).c().a(0.98f, 0.98f).a(10).b(10));
    public static final EntityTypes<EntityMinecartTNT> aZ = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).a(0.98f, 0.7f).a(8));
    public static final EntityTypes<EntityLlamaTrader> ba = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).a(10));
    public static final EntityTypes<EntityThrownTrident> bb = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).a(0.5f, 0.5f).a(4).b(20));
    public static final EntityTypes<EntityTropicalFish> bc = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).a(4));
    public static final EntityTypes<EntityTurtle> bd = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(10));
    public static final EntityTypes<EntityVex> be = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).a(8));
    public static final EntityTypes<EntityVillager> bf = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).a(10));
    public static final EntityTypes<EntityVindicator> bg = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityVillagerTrader> bh = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).a(10));
    public static final EntityTypes<Warden> bi = EntityTypes.a("warden", Builder.a(Warden::new, EnumCreatureType.a).a(0.9f, 2.9f).a(16).c());
    public static final EntityTypes<EntityWitch> bj = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityWither> bk = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.cd).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> bl = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.cd).a(0.7f, 2.4f).a(8));
    public static final EntityTypes<EntityWitherSkull> bm = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bn = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).a(10));
    public static final EntityTypes<EntityZoglin> bo = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(8));
    public static final EntityTypes<EntityZombie> bp = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityHorseZombie> bq = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).a(10));
    public static final EntityTypes<EntityZombieVillager> br = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityPigZombie> bs = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).a(8));
    public static final EntityTypes<EntityHuman> bt = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bu = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).b().a().a(0.25f, 0.25f).a(4).b(5));
    private final b<T> bA;
    private final EnumCreatureType bB;
    private final ImmutableSet<Block> bC;
    private final boolean bD;
    private final boolean bE;
    private final boolean bF;
    private final boolean bG;
    private final int bH;
    private final int bI;
    @Nullable
    private String bJ;
    @Nullable
    private IChatBaseComponent bK;
    @Nullable
    private MinecraftKey bL;
    private final EntitySize bM;
    private final FeatureFlagSet bN;

    private static <T extends Entity> EntityTypes<T> a(String id, Builder type) {
        return IRegistry.a(BuiltInRegistries.h, id, type.a(id));
    }

    public static MinecraftKey a(EntityTypes<?> type) {
        return BuiltInRegistries.h.b(type);
    }

    public static Optional<EntityTypes<?>> a(String id) {
        return BuiltInRegistries.h.b(MinecraftKey.a(id));
    }

    public EntityTypes(b<T> factory, EnumCreatureType spawnGroup, boolean saveable, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, ImmutableSet<Block> canSpawnInside, EntitySize dimensions, int maxTrackDistance, int trackTickInterval, FeatureFlagSet requiredFeatures) {
        this(factory, spawnGroup, saveable, summonable, fireImmune, spawnableFarFromPlayer, canSpawnInside, dimensions, maxTrackDistance, trackTickInterval, requiredFeatures, "custom");
    }

    public EntityTypes(b<T> factory, EnumCreatureType spawnGroup, boolean saveable, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, ImmutableSet<Block> canSpawnInside, EntitySize dimensions, int maxTrackDistance, int trackTickInterval, FeatureFlagSet requiredFeatures, String id) {
        this.bA = factory;
        this.bB = spawnGroup;
        this.bG = spawnableFarFromPlayer;
        this.bD = saveable;
        this.bE = summonable;
        this.bF = fireImmune;
        this.bC = canSpawnInside;
        this.bM = dimensions;
        this.bH = maxTrackDistance;
        this.bI = trackTickInterval;
        this.bN = requiredFeatures;
    }

    @Nullable
    public T a(WorldServer world, @Nullable ItemStack stack, @Nullable EntityHuman player, BlockPosition pos, EnumMobSpawn spawnReason, boolean alignPosition, boolean invertY) {
        return this.spawn(world, stack, player, pos, spawnReason, alignPosition, invertY, spawnReason == EnumMobSpawn.o ? CreatureSpawnEvent.SpawnReason.DISPENSE_EGG : CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        Consumer<Entity> consumer;
        NBTTagCompound nbttagcompound;
        if (itemstack != null) {
            nbttagcompound = itemstack.v();
            consumer = EntityTypes.a(worldserver, itemstack, entityhuman);
        } else {
            consumer = entity -> {};
            nbttagcompound = null;
        }
        return (T)this.spawn(worldserver, nbttagcompound, consumer, blockposition, enummobspawn, flag, flag1, spawnReason);
    }

    public static <T extends Entity> Consumer<T> a(WorldServer world, ItemStack stack, @Nullable EntityHuman player) {
        return EntityTypes.a((T entity) -> {}, world, stack, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> chained, WorldServer world, ItemStack stack, @Nullable EntityHuman player) {
        return EntityTypes.b(EntityTypes.a(chained, stack), world, stack, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> chained, ItemStack stack) {
        return stack.A() ? chained.andThen(entity -> entity.b(stack.y())) : chained;
    }

    public static <T extends Entity> Consumer<T> b(Consumer<T> chained, WorldServer world, ItemStack stack, @Nullable EntityHuman player) {
        NBTTagCompound nbttagcompound = stack.v();
        return nbttagcompound != null ? chained.andThen(entity -> {
            try {
                EntityTypes.a(world, player, entity, nbttagcompound);
            }
            catch (Throwable t2) {
                bw.warn("Error loading spawn egg NBT", t2);
            }
        }) : chained;
    }

    @Nullable
    public T a(WorldServer world, BlockPosition pos, EnumMobSpawn reason) {
        return this.spawn(world, pos, reason, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, BlockPosition blockposition, EnumMobSpawn enummobspawn, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.spawn(worldserver, (NBTTagCompound)null, null, blockposition, enummobspawn, false, false, spawnReason);
    }

    @Nullable
    public T a(WorldServer world, @Nullable NBTTagCompound itemNbt, @Nullable Consumer<T> afterConsumer, BlockPosition pos, EnumMobSpawn reason, boolean alignPosition, boolean invertY) {
        return this.spawn(world, itemNbt, afterConsumer, pos, reason, alignPosition, invertY, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable NBTTagCompound nbttagcompound, @Nullable Consumer<T> consumer, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        PreCreatureSpawnEvent event;
        EntityType type = EntityType.fromName((String)EntityTypes.a(this).a());
        if (type != null && !(event = new PreCreatureSpawnEvent(MCUtil.toLocation(worldserver, blockposition), type, spawnReason)).callEvent()) {
            return null;
        }
        T t0 = this.b(worldserver, nbttagcompound, consumer, blockposition, enummobspawn, flag, flag1);
        if (t0 != null) {
            worldserver.addFreshEntityWithPassengers((Entity)t0, spawnReason);
            return (T)(!((Entity)t0).dD() ? t0 : null);
        }
        return t0;
    }

    @Nullable
    public T b(WorldServer world, @Nullable NBTTagCompound itemNbt, @Nullable Consumer<T> afterConsumer, BlockPosition pos, EnumMobSpawn reason, boolean alignPosition, boolean invertY) {
        double d0;
        T t0 = this.a(world);
        if (t0 == null) {
            return null;
        }
        if (alignPosition) {
            ((Entity)t0).e((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5);
            d0 = EntityTypes.a((IWorldReader)world, pos, invertY, ((Entity)t0).cE());
        } else {
            d0 = 0.0;
        }
        ((Entity)t0).b((double)pos.u() + 0.5, (double)pos.v() + d0, (double)pos.w() + 0.5, MathHelper.g(world.z.i() * 360.0f), 0.0f);
        if (t0 instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)t0;
            entityinsentient.aX = entityinsentient.dy();
            entityinsentient.aV = entityinsentient.dy();
            entityinsentient.a(world, world.d_(entityinsentient.di()), reason, (GroupDataEntity)null, itemNbt);
            entityinsentient.N();
        }
        if (afterConsumer != null) {
            afterConsumer.accept(t0);
        }
        return t0;
    }

    protected static double a(IWorldReader world, BlockPosition pos, boolean invertY, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(pos);
        if (invertY) {
            axisalignedbb1 = axisalignedbb1.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> iterable = world.c((Entity)null, axisalignedbb1);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, boundingBox, iterable, invertY ? -2.0 : -1.0);
    }

    public static void a(World world, @Nullable EntityHuman player, @Nullable Entity entity, @Nullable NBTTagCompound itemNbt) {
        MinecraftServer minecraftserver;
        if (itemNbt != null && itemNbt.b(a, 10) && (minecraftserver = world.n()) != null && entity != null && (world.B || !entity.cK() || player != null && minecraftserver.ac().f(player.fM()))) {
            NBTTagCompound nbttagcompound1 = entity.f(new NBTTagCompound());
            UUID uuid = entity.ct();
            if (player == null || !player.getBukkitEntity().hasPermission("minecraft.nbt.place")) {
                for (ArgumentNBTKey.g tag : world.paperConfig().entities.spawning.filteredEntityTagNbtPaths) {
                    tag.c(itemNbt.p(a));
                }
            }
            nbttagcompound1.a(itemNbt.p(a));
            entity.a_(uuid);
            entity.g(nbttagcompound1);
        }
    }

    public boolean b() {
        return this.bD;
    }

    public boolean c() {
        return this.bE;
    }

    public boolean d() {
        return this.bF;
    }

    public boolean e() {
        return this.bG;
    }

    public EnumCreatureType f() {
        return this.bB;
    }

    public String g() {
        if (this.bJ == null) {
            this.bJ = SystemUtils.a("entity", BuiltInRegistries.h.b(this));
        }
        return this.bJ;
    }

    public IChatBaseComponent h() {
        if (this.bK == null) {
            this.bK = IChatBaseComponent.c(this.g());
        }
        return this.bK;
    }

    public String toString() {
        return this.g();
    }

    public String i() {
        int i2 = this.g().lastIndexOf(46);
        return i2 == -1 ? this.g() : this.g().substring(i2 + 1);
    }

    public MinecraftKey j() {
        if (this.bL == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.h.b(this);
            this.bL = minecraftkey.d("entities/");
        }
        return this.bL;
    }

    public float k() {
        return this.bM.a;
    }

    public float l() {
        return this.bM.b;
    }

    @Override
    public FeatureFlagSet m() {
        return this.bN;
    }

    @Override
    @Nullable
    public T a(World world) {
        return !this.a(world.G()) ? null : (T)this.bA.create(this, world);
    }

    public static Optional<Entity> a(NBTTagCompound nbt, World world) {
        return SystemUtils.a(EntityTypes.a(nbt).map(entitytypes -> entitytypes.a(world)), (T entity) -> entity.g(nbt), () -> bw.warn("Skipping Entity with id {}", (Object)nbt.l("id")));
    }

    public AxisAlignedBB a(double feetX, double feetY, double feetZ) {
        float f2 = this.k() / 2.0f;
        return new AxisAlignedBB(feetX - (double)f2, feetY, feetZ - (double)f2, feetX + (double)f2, feetY + (double)this.l(), feetZ + (double)f2);
    }

    @Override
    public boolean a(IBlockData state) {
        return this.bC.contains((Object)state.b()) ? false : (!this.bF && PathfinderNormal.a(state) ? true : state.a(Blocks.cd) || state.a(Blocks.oi) || state.a(Blocks.dQ) || state.a(Blocks.qC));
    }

    public EntitySize n() {
        return this.bM;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound nbt) {
        return BuiltInRegistries.h.b(new MinecraftKey(nbt.l("id")));
    }

    @Nullable
    public static Entity a(NBTTagCompound nbt, World world, Function<Entity, Entity> entityProcessor) {
        return EntityTypes.b(nbt, world).map(entityProcessor).map(entity -> {
            if (nbt.b("Passengers", 9)) {
                NBTTagList nbttaglist = nbt.c("Passengers", 10);
                for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                    Entity entity1 = EntityTypes.a(nbttaglist.a(i2), world, entityProcessor);
                    if (entity1 == null) continue;
                    entity1.a((Entity)entity, true);
                }
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(final List<? extends NBTBase> entityNbtList, final World world) {
        final Spliterator<? extends NBTBase> spliterator = entityNbtList.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){
            final Map<EntityTypes<?>, Integer> loadedEntityCounts = new HashMap();

            @Override
            public boolean tryAdvance(Consumer<? super Entity> consumer) {
                return spliterator.tryAdvance((? super T nbtbase) -> EntityTypes.a((NBTTagCompound)nbtbase, world, entity -> {
                    EntityTypes<?> entityType = entity.ae();
                    int saveLimit = world2.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                    if (saveLimit > -1) {
                        if (this.loadedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                            return null;
                        }
                        this.loadedEntityCounts.merge(entityType, 1, Integer::sum);
                    }
                    consumer.accept((Entity)entity);
                    return entity;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return entityNbtList.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> b(NBTTagCompound nbt, World world) {
        try {
            return EntityTypes.a(nbt, world);
        }
        catch (RuntimeException runtimeexception) {
            bw.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int o() {
        return this.bH;
    }

    public int p() {
        return this.bI;
    }

    public boolean q() {
        return this != bt && this != ak && this != bk && this != g && this != af && this != S && this != ah && this != ar && this != B && this != H;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tag) {
        return this.bx.a(tag);
    }

    @Override
    @Nullable
    public T a(Entity obj) {
        return (T)(obj.ae() == this ? obj : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> r() {
        return this.bx;
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);
        private FeatureFlagSet k = FeatureFlags.e;

        private Builder(b<T> factory, EnumCreatureType spawnGroup) {
            this.a = factory;
            this.b = spawnGroup;
            this.g = spawnGroup == EnumCreatureType.b || spawnGroup == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b factory, EnumCreatureType spawnGroup) {
            return new Builder<T>(factory, spawnGroup);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType spawnGroup) {
            return new Builder<Entity>((entitytypes, world) -> null, spawnGroup);
        }

        public Builder<T> a(float width, float height) {
            this.j = EntitySize.b(width, height);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... blocks) {
            this.c = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int maxTrackingRange) {
            this.h = maxTrackingRange;
            return this;
        }

        public Builder<T> b(int trackingTickInterval) {
            this.i = trackingTickInterval;
            return this;
        }

        public Builder<T> a(FeatureFlag ... features) {
            this.k = FeatureFlags.c.a(features);
            return this;
        }

        public EntityTypes<T> a(String id) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.p, id);
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j, this.h, this.i, this.k, id);
        }
    }

    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

