/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetForget {
    private static final int a = 200;

    public static <E extends EntityInsentient> BehaviorControl<E> a(BiConsumer<E, EntityLiving> forgetCallback) {
        return BehaviorAttackTargetForget.a(entityliving -> false, forgetCallback, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a(Predicate<EntityLiving> alternativeCondition) {
        return BehaviorAttackTargetForget.a(alternativeCondition, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a() {
        return BehaviorAttackTargetForget.a(entityliving -> false, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a(Predicate<EntityLiving> alternativeCondition, BiConsumer<E, EntityLiving> forgetCallback, boolean shouldForgetIfTargetUnreachable) {
        return BehaviorBuilder.a((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.b(MemoryModuleType.o), behaviorbuilder_b.a(MemoryModuleType.E)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i2) -> {
            EntityLiving entityliving = (EntityLiving)behaviorbuilder_b.b(memoryaccessor);
            if (!(!entityinsentient.c(entityliving) || shouldForgetIfTargetUnreachable && BehaviorAttackTargetForget.a(entityinsentient, behaviorbuilder_b.a(memoryaccessor1)) || !entityliving.bs() || entityliving.dI() != entityinsentient.dI() || alternativeCondition.test(entityliving))) {
                return true;
            }
            EntityTargetEvent.TargetReason reason = !entityinsentient.c(entityliving) ? EntityTargetEvent.TargetReason.TARGET_INVALID : (shouldForgetIfTargetUnreachable && BehaviorAttackTargetForget.a(entityinsentient, behaviorbuilder_b.a(memoryaccessor1)) ? EntityTargetEvent.TargetReason.FORGOT_TARGET : (!entityliving.bs() ? EntityTargetEvent.TargetReason.TARGET_DIED : (entityliving.dI() != entityinsentient.dI() ? EntityTargetEvent.TargetReason.TARGET_OTHER_LEVEL : EntityTargetEvent.TargetReason.TARGET_INVALID)));
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, null, reason);
            if (event.isCancelled()) {
                return false;
            }
            forgetCallback.accept(entityinsentient, entityliving);
            memoryaccessor.b();
            return true;
        }));
    }

    private static boolean a(EntityLiving entityliving, Optional<Long> optional) {
        return optional.isPresent() && entityliving.dI().V() - optional.get() > 200L;
    }
}

