/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.inventory.InventoryView;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bT = 40;
    private static final DataWatcherObject<Byte> bU = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, IMaterial> bW = SystemUtils.a(Maps.newEnumMap(EnumColor.class), (T enummap) -> {
        enummap.put(EnumColor.a, Blocks.bA);
        enummap.put(EnumColor.b, Blocks.bB);
        enummap.put(EnumColor.c, Blocks.bC);
        enummap.put(EnumColor.d, Blocks.bD);
        enummap.put(EnumColor.e, Blocks.bE);
        enummap.put(EnumColor.f, Blocks.bF);
        enummap.put(EnumColor.g, Blocks.bG);
        enummap.put(EnumColor.h, Blocks.bH);
        enummap.put(EnumColor.i, Blocks.bI);
        enummap.put(EnumColor.j, Blocks.bJ);
        enummap.put(EnumColor.k, Blocks.bK);
        enummap.put(EnumColor.l, Blocks.bL);
        enummap.put(EnumColor.m, Blocks.bM);
        enummap.put(EnumColor.n, Blocks.bN);
        enummap.put(EnumColor.o, Blocks.bO);
        enummap.put(EnumColor.p, Blocks.bP);
    });
    private static final Map<EnumColor, float[]> bX = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(enumcolor -> enumcolor, EntitySheep::c)));
    private int bY;
    private PathfinderGoalEatTile bZ;

    private static float[] c(EnumColor color) {
        if (color == EnumColor.a) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = color.d();
        float f2 = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] a(EnumColor dyeColor) {
        return bX.get(dyeColor);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void x() {
        this.bZ = new PathfinderGoalEatTile(this);
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.1, RecipeItemStack.a(Items.oI), false));
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bO.a(5, this.bZ);
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    protected void W() {
        this.bY = this.bZ.h();
        super.W();
    }

    @Override
    public void b_() {
        if (this.dI().B) {
            this.bY = Math.max(0, this.bY - 1);
        }
        super.b_();
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 8.0).a(GenericAttributes.d, 0.23f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bU, (byte)0);
    }

    @Override
    public MinecraftKey Q() {
        if (this.w()) {
            return this.ae().j();
        }
        return switch (this.r()) {
            case EnumColor.a -> LootTables.S;
            case EnumColor.b -> LootTables.T;
            case EnumColor.c -> LootTables.U;
            case EnumColor.d -> LootTables.V;
            case EnumColor.e -> LootTables.W;
            case EnumColor.f -> LootTables.X;
            case EnumColor.g -> LootTables.Y;
            case EnumColor.h -> LootTables.Z;
            case EnumColor.i -> LootTables.aa;
            case EnumColor.j -> LootTables.ab;
            case EnumColor.k -> LootTables.ac;
            case EnumColor.l -> LootTables.ad;
            case EnumColor.m -> LootTables.ae;
            case EnumColor.n -> LootTables.af;
            case EnumColor.o -> LootTables.ag;
            case EnumColor.p -> LootTables.ah;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public void b(byte status) {
        if (status == 10) {
            this.bY = 40;
        } else {
            super.b(status);
        }
    }

    public float D(float delta) {
        return this.bY <= 0 ? 0.0f : (this.bY >= 4 && this.bY <= 36 ? 1.0f : (this.bY < 4 ? ((float)this.bY - delta) / 4.0f : -((float)(this.bY - 40) - delta) / 4.0f));
    }

    public float E(float delta) {
        if (this.bY > 4 && this.bY <= 36) {
            float f1 = ((float)(this.bY - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f1 * 28.7f);
        }
        return this.bY > 0 ? 0.62831855f : this.dA() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rg)) {
            if (!this.dI().B && this.a()) {
                if (!CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand)) {
                    return EnumInteractionResult.d;
                }
                this.a(SoundCategory.h);
                this.a(GameEvent.N, (Entity)player);
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.dI().a((EntityHuman)null, this, SoundEffects.uO, shearedSoundCategory, 1.0f, 1.0f);
        this.w(true);
        int i2 = 1 + this.af.a(3);
        for (int j2 = 0; j2 < i2; ++j2) {
            this.forceDrops = true;
            EntityItem entityitem = this.a(bW.get(this.r()), 1);
            this.forceDrops = false;
            if (entityitem == null) continue;
            entityitem.f(entityitem.dl().b((this.af.i() - this.af.i()) * 0.1f, this.af.i() * 0.05f, (this.af.i() - this.af.i()) * 0.1f));
        }
    }

    @Override
    public boolean a() {
        return this.bs() && !this.w() && !this.h_();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Sheared", this.w());
        nbt.a("Color", (byte)this.r().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("Sheared"));
        this.b(EnumColor.a(nbt.f("Color")));
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.uL;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.uN;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.uM;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.uP, 0.15f, 1.0f);
    }

    public EnumColor r() {
        return EnumColor.a(this.am.b(bU) & 0xF);
    }

    public void b(EnumColor color) {
        byte b0 = this.am.b(bU);
        this.am.b(bU, (byte)(b0 & 0xF0 | color.a() & 0xF));
    }

    public boolean w() {
        return (this.am.b(bU) & 0x10) != 0;
    }

    public void w(boolean sheared) {
        byte b0 = this.am.b(bU);
        if (sheared) {
            this.am.b(bU, (byte)(b0 | 0x10));
        } else {
            this.am.b(bU, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(RandomSource random) {
        int i2 = random.a(100);
        return i2 < 5 ? EnumColor.p : (i2 < 10 ? EnumColor.h : (i2 < 15 ? EnumColor.i : (i2 < 18 ? EnumColor.m : (random.a(500) == 0 ? EnumColor.g : EnumColor.a))));
    }

    @Nullable
    public EntitySheep b(WorldServer world, EntityAgeable entity) {
        EntitySheep entitysheep = EntityTypes.aF.a(world);
        if (entitysheep != null) {
            entitysheep.b(this.a(this, (EntityAnimal)((EntitySheep)entity)));
        }
        return entitysheep;
    }

    @Override
    public void L() {
        SheepRegrowWoolEvent event = new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity());
        this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        super.L();
        this.w(false);
        if (this.h_()) {
            this.b_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.b(EntitySheep.a(world.y_()));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private EnumColor a(EntityAnimal firstParent, EntityAnimal secondParent) {
        EnumColor enumcolor = ((EntitySheep)firstParent).r();
        EnumColor enumcolor1 = ((EntitySheep)secondParent).r();
        InventoryCrafting inventorycrafting = EntitySheep.a(enumcolor, enumcolor1);
        Optional<Item> optional = this.dI().q().a(Recipes.a, inventorycrafting, this.dI()).map(recipecrafting -> recipecrafting.a(inventorycrafting, this.dI().B_())).map(ItemStack::d);
        Objects.requireNonNull(ItemDye.class);
        optional = optional.filter(ItemDye.class::isInstance);
        Objects.requireNonNull(ItemDye.class);
        return optional.map(ItemDye.class::cast).map(ItemDye::d).orElseGet(() -> this.dI().z.h() ? enumcolor : enumcolor1);
    }

    private static InventoryCrafting a(EnumColor firstColor, EnumColor secondColor) {
        TransientCraftingContainer transientcraftingcontainer = new TransientCraftingContainer(new Container((Containers)null, -1){

            @Override
            public ItemStack a(EntityHuman player, int slot) {
                return ItemStack.b;
            }

            @Override
            public boolean a(EntityHuman player) {
                return false;
            }

            @Override
            public InventoryView getBukkitView() {
                return null;
            }
        }, 2, 1);
        transientcraftingcontainer.a(0, new ItemStack(ItemDye.a(firstColor)));
        transientcraftingcontainer.a(1, new ItemStack(ItemDye.a(secondColor)));
        transientcraftingcontainer.resultInventory = new InventoryCraftResult();
        return transientcraftingcontainer;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.95f * dimensions.b;
    }
}

