/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.util.MCUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> bW = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.n);
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<BlockPosition> bZ = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.n);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    public static final RecipeItemStack bT = RecipeItemStack.a(Blocks.bw.k());
    int cc;
    public static final Predicate<EntityLiving> bU = entityliving -> entityliving.h_() && !entityliving.aV();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.bL = new e(this);
        this.r(1.0f);
    }

    public void i(BlockPosition pos) {
        this.am.b(bW, pos.i());
    }

    public BlockPosition fY() {
        return this.am.b(bW);
    }

    void j(BlockPosition pos) {
        this.am.b(bZ, pos);
    }

    BlockPosition ge() {
        return this.am.b(bZ);
    }

    public boolean q() {
        return this.am.b(bX);
    }

    public void w(boolean hasEgg) {
        this.am.b(bX, hasEgg);
    }

    public boolean r() {
        return this.am.b(bY);
    }

    void x(boolean diggingSand) {
        this.cc = diggingSand ? 1 : 0;
        this.am.b(bY, diggingSand);
    }

    public boolean gf() {
        return this.am.b(ca);
    }

    public void y(boolean landBound) {
        this.am.b(ca, landBound);
    }

    public boolean gg() {
        return this.am.b(cb);
    }

    public void z(boolean traveling) {
        this.am.b(cb, traveling);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bW, BlockPosition.b);
        this.am.a(bX, false);
        this.am.a(bZ, BlockPosition.b);
        this.am.a(ca, false);
        this.am.a(cb, false);
        this.am.a(bY, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("HomePosX", this.fY().u());
        nbt.a("HomePosY", this.fY().v());
        nbt.a("HomePosZ", this.fY().w());
        nbt.a("HasEgg", this.q());
        nbt.a("TravelPosX", this.ge().u());
        nbt.a("TravelPosY", this.ge().v());
        nbt.a("TravelPosZ", this.ge().w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2 = nbt.h("HomePosX");
        int j2 = nbt.h("HomePosY");
        int k2 = nbt.h("HomePosZ");
        this.i(new BlockPosition(i2, j2, k2));
        super.a(nbt);
        this.w(nbt.q("HasEgg"));
        int l2 = nbt.h("TravelPosX");
        int i1 = nbt.h("TravelPosY");
        int j1 = nbt.h("TravelPosZ");
        this.j(new BlockPosition(l2, i1, j1));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.i(this.di());
        this.j(BlockPosition.b);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean c(EntityTypes<EntityTurtle> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < world.t_() + 4 && BlockTurtleEgg.a(world, pos) && EntityTurtle.a(world, pos);
    }

    @Override
    protected void x() {
        this.bO.a(0, new f(this, 1.2));
        this.bO.a(1, new a(this, 1.0));
        this.bO.a(1, new d(this, 1.0));
        this.bO.a(2, new PathfinderGoalTempt(this, 1.1, bT, false));
        this.bO.a(3, new c(this, 1.0));
        this.bO.a(4, new b(this, 1.0));
        this.bO.a(7, new i(this, 1.0));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder w() {
        return EntityInsentient.y().a(GenericAttributes.a, 30.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public boolean cw() {
        return false;
    }

    @Override
    public boolean dN() {
        return true;
    }

    @Override
    public EnumMonsterType eN() {
        return EnumMonsterType.e;
    }

    @Override
    public int M() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return !this.aV() && this.ay() && !this.h_() ? SoundEffects.yc : super.s();
    }

    @Override
    protected void e(float volume) {
        super.e(volume * 1.5f);
    }

    @Override
    protected SoundEffect aJ() {
        return SoundEffects.yn;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return this.h_() ? SoundEffects.yj : SoundEffects.yi;
    }

    @Override
    @Nullable
    public SoundEffect g_() {
        return this.h_() ? SoundEffects.ye : SoundEffects.yd;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffect soundeffect = this.h_() ? SoundEffects.ym : SoundEffects.yl;
        this.a(soundeffect, 0.15f, 1.0f);
    }

    @Override
    public boolean fZ() {
        return super.fZ() && !this.q();
    }

    @Override
    protected float aI() {
        return this.Y + 0.15f;
    }

    @Override
    public float dV() {
        return this.h_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new g(this, world);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bd.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(Blocks.bw.k());
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return !this.gf() && world.b_(pos).a(TagsFluid.a) ? 10.0f : (BlockTurtleEgg.a(world, pos) ? 10.0f : world.v(pos));
    }

    @Override
    public void b_() {
        super.b_();
        if (this.bs() && this.r() && this.cc >= 1 && this.cc % 5 == 0) {
            BlockPosition blockposition = this.di();
            if (BlockTurtleEgg.a(this.dI(), blockposition)) {
                this.dI().c(2001, blockposition, Block.i(this.dI().a_(blockposition.d())));
            }
        }
    }

    @Override
    protected void m() {
        super.m();
        if (!this.h_() && this.dI().X().b(GameRules.f)) {
            this.forceDrops = true;
            this.a(Items.nD, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.cU() && this.aV()) {
            this.a(0.1f, movementInput);
            this.a(EnumMoveType.a, this.dl());
            this.f(this.dl().a(0.9));
            if (!(this.j() != null || this.gf() && this.fY().a(this.dg(), 20.0))) {
                this.f(this.dl().b(0.0, -0.005, 0.0));
            }
        } else {
            super.h(movementInput);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        CraftEventFactory.entityDamage = lightning;
        this.a(this.dJ().b(), Float.MAX_VALUE);
        CraftEventFactory.entityDamage = null;
    }

    private static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle turtle) {
            super(turtle);
            this.l = turtle;
        }

        private void g() {
            if (this.l.aV()) {
                this.l.f(this.l.dl().b(0.0, 0.005, 0.0));
                if (!this.l.fY().a(this.l.dg(), 16.0)) {
                    this.l.w(Math.max(this.l.fa() / 2.0f, 0.08f));
                }
                if (this.l.h_()) {
                    this.l.w(Math.max(this.l.fa() / 3.0f, 0.06f));
                }
            } else if (this.l.ay()) {
                this.l.w(Math.max(this.l.fa() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.J().l()) {
                double d2;
                double d1;
                double d0 = this.e - this.l.dn();
                double d3 = Math.sqrt(d0 * d0 + (d1 = this.f - this.l.dp()) * d1 + (d2 = this.g - this.l.dt()) * d2);
                if (d3 < (double)1.0E-5f) {
                    this.d.w(0.0f);
                } else {
                    d1 /= d3;
                    float f2 = (float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f;
                    this.l.a_(this.a(this.l.dy(), f2, 90.0f));
                    this.l.aV = this.l.dy();
                    float f1 = (float)(this.h * this.l.b(GenericAttributes.d));
                    this.l.w(MathHelper.i(0.125f, this.l.fa(), f1));
                    this.l.f(this.l.dl().b(0.0, (double)this.l.fa() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.w(0.0f);
            }
        }
    }

    private static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speed) {
            super(turtle, speed);
        }

        @Override
        public boolean a() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockposition = this.a(this.b.dI(), this.b, 7);
            if (blockposition != null) {
                this.d = blockposition.u();
                this.e = blockposition.v();
                this.f = blockposition.w();
                return true;
            }
            return this.i();
        }
    }

    private static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speed) {
            super(turtle, speed);
            this.d = turtle;
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.q();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer entityplayer = this.a.gb();
            if (entityplayer == null && this.c.gb() != null) {
                entityplayer = this.c.gb();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this.a, this.c, null);
            }
            this.d.w(true);
            this.a.c_(6000);
            this.c.c_(6000);
            this.a.gd();
            this.c.gd();
            RandomSource randomsource = this.a.ec();
            if (this.b.X().b(GameRules.f) && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dn(), this.a.dp(), this.a.dt(), event.getExperience(), ExperienceOrb.SpawnReason.BREED, entityplayer));
            }
        }
    }

    private static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speed) {
            super(turtle, speed, 16);
            this.g = turtle;
        }

        @Override
        public boolean a() {
            return this.g.q() && this.g.fY().a(this.g.dg(), 9.0) ? super.a() : false;
        }

        @Override
        public boolean b() {
            return super.b() && this.g.q() && this.g.fY().a(this.g.dg(), 9.0);
        }

        @Override
        public void e() {
            super.e();
            BlockPosition blockposition = this.g.di();
            if (!this.g.aV() && this.m()) {
                if (this.g.cc < 1) {
                    this.g.x(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dI(), this.getTargetPosition())).callEvent());
                } else if (this.g.cc > this.a(200)) {
                    World world = this.g.dI();
                    int eggCount = this.g.af.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dI(), this.e.c()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.c(), (IBlockData)Blocks.mf.n().a(BlockTurtleEgg.e, layEggEvent.getEggCount()))) {
                        world.a((EntityHuman)null, blockposition, SoundEffects.yk, SoundCategory.e, 0.3f, 0.9f + world.z.i() * 0.2f);
                        BlockPosition blockposition1 = this.e.c();
                        IBlockData iblockdata = (IBlockData)Blocks.mf.n().a(BlockTurtleEgg.e, layEggEvent.getEggCount());
                        world.a(blockposition1, iblockdata, 3);
                        world.a(GameEvent.i, blockposition1, GameEvent.a.a(this.g, iblockdata));
                    }
                    this.g.w(false);
                    this.g.x(false);
                    this.g.s(600);
                }
                if (this.g.r()) {
                    ++this.g.cc;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return !world.t(pos.c()) ? false : BlockTurtleEgg.b(world, pos);
        }
    }

    private static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speed) {
            super(turtle, turtle.h_() ? 2.0 : speed, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean b() {
            return !this.h.aV() && this.d <= 1200 && this.a(this.h.dI(), this.e);
        }

        @Override
        public boolean a() {
            return this.h.h_() && !this.h.aV() ? super.a() : (!this.h.gf() && !this.h.aV() && !this.h.q() ? super.a() : false);
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.G);
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return this.a.h_() ? false : (this.a.q() || this.a.ec().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.fY().a(this.a.dg(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.a.y(true);
            this.c = false;
            this.d = 0;
        }

        @Override
        public void d() {
            this.a.y(false);
        }

        @Override
        public boolean b() {
            return !this.a.fY().a(this.a.dg(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void e() {
            BlockPosition blockposition = this.a.fY();
            boolean flag = blockposition.a(this.a.dg(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.J().l()) {
                Vec3D vec3d = Vec3D.c(blockposition);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null && !flag && !this.a.dI().a_(BlockPosition.a(vec3d1)).a(Blocks.G)) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.J().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }
    }

    private static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return !this.a.gf() && !this.a.q() && this.a.aV();
        }

        @Override
        public void c() {
            boolean flag = true;
            boolean flag1 = true;
            RandomSource randomsource = this.a.af;
            int i2 = randomsource.a(1025) - 512;
            int j2 = randomsource.a(9) - 4;
            int k2 = randomsource.a(1025) - 512;
            if ((double)j2 + this.a.dp() > (double)(this.a.dI().t_() - 1)) {
                j2 = 0;
            }
            BlockPosition blockposition = BlockPosition.a((double)i2 + this.a.dn(), (double)j2 + this.a.dp(), (double)k2 + this.a.dt());
            this.a.j(blockposition);
            this.a.z(true);
            this.c = false;
        }

        @Override
        public void e() {
            if (this.a.J().l()) {
                Vec3D vec3d = Vec3D.c(this.a.ge());
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null) {
                    int i2 = MathHelper.a(vec3d1.c);
                    int j2 = MathHelper.a(vec3d1.e);
                    boolean flag = true;
                    if (!this.a.dI().b(i2 - 34, j2 - 34, i2 + 34, j2 + 34)) {
                        vec3d1 = null;
                    }
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.J().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }

        @Override
        public boolean b() {
            return !this.a.J().l() && !this.c && !this.a.gf() && !this.a.gc() && !this.a.q();
        }

        @Override
        public void d() {
            this.a.z(false);
            super.d();
        }
    }

    private static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speed, int chance) {
            super(turtle, speed, chance);
            this.i = turtle;
        }

        @Override
        public boolean a() {
            return !this.b.aV() && !this.i.gf() && !this.i.q() ? super.a() : false;
        }
    }

    private static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle owner, World world) {
            super(owner, world);
        }

        @Override
        public boolean a(BlockPosition pos) {
            EntityTurtle entityturtle;
            EntityInsentient entityinsentient = this.a;
            if (entityinsentient instanceof EntityTurtle && (entityturtle = (EntityTurtle)entityinsentient).gg()) {
                return this.b.a_(pos).a(Blocks.G);
            }
            return !this.b.a_(pos.d()).i();
        }
    }
}

