/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int bZ = 1700;
    private static final int ca = 6000;
    private static final int cb = 30;
    private static final int cc = 120;
    private static final int cd = 48000;
    private static final float ce = 0.4f;
    private static final EntitySize cf = EntitySize.b(EntityTypes.aN.k(), EntityTypes.aN.l() - 0.4f);
    private static final DataWatcherObject<State> cg = DataWatcher.a(Sniffer.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bT = new AnimationState();
    public final AnimationState bU = new AnimationState();
    public final AnimationState bW = new AnimationState();
    public final AnimationState bX = new AnimationState();
    public final AnimationState bY = new AnimationState();

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.1f).a(GenericAttributes.a, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.J().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cg, State.a);
        this.am.a(ch, 0);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.a((EntityPose)pose).b * 0.6f;
    }

    @Override
    public void A() {
        super.A();
        if (this.bL() || this.aV()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void C() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.am.a(cg) && this.gk() == State.f ? cf.a(this.dV()) : super.a(pose);
    }

    public boolean r() {
        return this.bA.c(MemoryModuleType.Y).isPresent();
    }

    public boolean w() {
        return this.gk() == State.e;
    }

    public boolean fY() {
        return this.bA.c(MemoryModuleType.Q).orElse(false);
    }

    public boolean ge() {
        return !this.fY() && !this.r() && !this.aV() && !this.gc() && this.ay() && !this.bM();
    }

    public boolean gf() {
        return this.gk() == State.f || this.gk() == State.e;
    }

    private BlockPosition gi() {
        Vec3D vec3d = this.gj();
        return BlockPosition.a(vec3d.a(), this.dp() + (double)0.2f, vec3d.c());
    }

    private Vec3D gj() {
        return this.dg().e(this.bF().a(2.25));
    }

    public State gk() {
        return this.am.b(cg);
    }

    private Sniffer b(State state) {
        this.am.b(cg, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cg.equals(data)) {
            State sniffer_state = this.gk();
            this.gl();
            switch (sniffer_state) {
                case c: {
                    this.bU.b(this.ag);
                    break;
                }
                case d: {
                    this.bW.b(this.ag);
                    break;
                }
                case f: {
                    this.bX.b(this.ag);
                    break;
                }
                case g: {
                    this.bY.b(this.ag);
                    break;
                }
                case b: {
                    this.bT.b(this.ag);
                }
            }
            this.d_();
        }
        super.a(data);
    }

    private void gl() {
        this.bX.a();
        this.bW.a();
        this.bY.a();
        this.bT.a();
        this.bU.a();
    }

    public Sniffer a(State state) {
        switch (state) {
            case c: {
                this.b(State.c).gm();
                break;
            }
            case d: {
                this.a(SoundEffects.wF, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case f: {
                this.b(State.f).gn();
                break;
            }
            case g: {
                this.a(SoundEffects.wI, 1.0f, 1.0f);
                this.b(State.g);
                break;
            }
            case b: {
                this.a(SoundEffects.wJ, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case a: {
                this.b(State.a);
                break;
            }
            case e: {
                this.b(State.e);
            }
        }
        return this;
    }

    private Sniffer gm() {
        this.a(SoundEffects.wE, 1.0f, this.h_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gn() {
        this.am.b(ch, this.ag + 120);
        this.dI().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer w(boolean explored) {
        if (explored) {
            this.j(this.aF());
        }
        return this;
    }

    public Optional<BlockPosition> gg() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.dI().w_().a((BlockPosition)blockposition)).map(BlockPosition::d).filter(this::i).findFirst();
    }

    public boolean gh() {
        return !this.r() && !this.fY() && !this.h_() && !this.aV() && this.ay() && !this.bM() && this.i(this.gi().d());
    }

    private boolean i(BlockPosition pos) {
        return this.dI().a_(pos).a(TagsBlock.ch) && this.gp().noneMatch(globalpos -> GlobalPos.a(this.dI().ac(), pos).equals(globalpos)) && Optional.ofNullable(this.J().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void go() {
        if (!this.dI().r_() && this.am.b(ch) == this.ag) {
            WorldServer worldserver = (WorldServer)this.dI();
            LootTable loottable = worldserver.n().aH().getLootTable(LootTables.aA);
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, this.gj()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams);
            BlockPosition blockposition = this.gi();
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(worldserver, blockposition.u(), blockposition.v(), blockposition.w(), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                entityitem.o();
                worldserver.b(entityitem);
            }
            this.a(SoundEffects.wD, 1.0f, 1.0f);
        }
    }

    private Sniffer a(AnimationState diggingAnimationState) {
        boolean flag;
        boolean bl = flag = diggingAnimationState.b() > 1700L && diggingAnimationState.b() < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gi();
            IBlockData iblockdata = this.dI().a_(blockposition.d());
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.dI().a(new ParticleParamBlock(Particles.c, iblockdata), vec3d.c, vec3d.d, vec3d.e, 0.0, 0.0, 0.0);
                }
                if (this.ag % 10 == 0) {
                    this.dI().a(this.dn(), this.dp(), this.dt(), iblockdata.w().f(), this.cY(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.ag % 10 == 0) {
            this.dI().a(GameEvent.v, this.gi(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer j(BlockPosition pos) {
        List list = this.gp().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dI().ac(), pos));
        this.dK().a(MemoryModuleType.aP, list);
        return this;
    }

    public Stream<GlobalPos> gp() {
        return this.dK().c(MemoryModuleType.aP).stream().flatMap(Collection::stream);
    }

    @Override
    protected void eW() {
        double d1;
        super.eW();
        double d0 = this.bL.c();
        if (d0 > 0.0 && (d1 = this.dl().i()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemstack = new ItemStack(Items.jU);
        EntityItem entityitem = new EntityItem(world, this.dg().a(), this.dg().b(), this.dg().c(), itemstack);
        entityitem.o();
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        if (this.spawnAtLocation(entityitem) != null) {
            this.a(SoundEffects.wK, 1.0f, (this.af.i() - this.af.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void l() {
        switch (this.gk()) {
            case f: {
                this.a(this.bX).go();
                break;
            }
            case e: {
                this.gq();
            }
        }
        super.l();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        boolean flag = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && flag) {
            this.dI().a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dI().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public double bx() {
        return 1.8;
    }

    @Override
    public float df() {
        return super.df() + 0.3f;
    }

    private void gq() {
        if (this.dI().r_() && this.ag % 20 == 0) {
            this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.wG, this.cY(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.wy, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.wz;
    }

    @Override
    protected SoundEffect s() {
        return Set.of(State.f, State.e).contains((Object)this.gk()) ? null : SoundEffects.wA;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wB;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.wC;
    }

    @Override
    public int fC() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aN.a(world);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!(other instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)other;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gk()) && set.contains((Object)sniffer.gk()) && super.a(other);
    }

    @Override
    public AxisAlignedBB j_() {
        return super.j_().g(0.6f);
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.aK);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.dL().a(dynamic));
    }

    public BehaviorController<Sniffer> dK() {
        return super.dK();
    }

    protected BehaviorController.b<Sniffer> dL() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void W() {
        this.dI().ad().a("snifferBrain");
        this.dK().a((WorldServer)this.dI(), this);
        this.dI().ad().b("snifferActivityUpdate");
        SnifferAi.a(this);
        this.dI().ad().c();
        super.W();
    }

    @Override
    protected void V() {
        super.V();
        PacketDebug.a(this);
    }

    public static enum State {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

