/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int b;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.H = true;
        this.b = this.af.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.B, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission aS() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.aj().a(c, Optional.empty());
        this.aj().a(d, true);
    }

    @Override
    public void l() {
        ++this.b;
        if (this.dI() instanceof WorldServer) {
            BlockPosition blockposition = this.di();
            if (((WorldServer)this.dI()).B() != null && this.dI().a_(blockposition).i() && !CraftEventFactory.callBlockIgniteEvent(this.dI(), blockposition, this).isCancelled()) {
                this.dI().b(blockposition, BlockFireAbstract.a(this.dI(), blockposition));
            }
            if (!LeavesConfig.mcTechnicalMode && this.dI().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.co() && (!Objects.equals(((WorldServer)this.dI()).uuid, this.getOriginWorld()) || ((WorldServer)this.dI()).B() == null || ((WorldServer)this.dI()).B().z == null || ((WorldServer)this.dI()).B().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.j() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.j()));
        }
        nbt.a("ShowBottom", this.k());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bo() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dD() && !this.dI().B) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            this.a(Entity.RemovalReason.a);
            if (!source.a(DamageTypeTags.l)) {
                DamageSource damagesource1 = source.d() != null ? this.dJ().d(this, source.d()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    this.dF();
                    return false;
                }
                this.dI().a(this, damagesource1, null, this.dn(), this.dp(), this.dt(), event.getRadius(), event.getFire(), World.a.b);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void ah() {
        this.a(this.dJ().n());
        super.ah();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.dI() instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.dI()).B()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.aj().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition j() {
        return this.aj().b(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.aj().b(d, showBottom);
    }

    public boolean k() {
        return this.aj().b(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.j() != null;
    }

    @Override
    public ItemStack dv() {
        return new ItemStack(Items.ul);
    }
}

